package example.tryspring.cb2_oxm;

import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.stereotype.Component;

/**
 * 動作確認のため、ProductXmlクラスの処理状況をログ出力するクラスです。
 */
@Aspect
@Component
public class ProductXmlAspect {

	@Before("execution(* ProductXml.save(..)) || execution(* ProductXml.load(..))")
	public void before(JoinPoint jp) {
		Signature sig = jp.getSignature();
		String name = sig.getDeclaringTypeName() + "#" + sig.getName() + "メソッド";
		String args = StringUtils.join(jp.getArgs(), ",");
		System.out.println(name + " 開始 args=" + args);
	}

	@AfterReturning(value = "execution(* ProductXml.save(..))")
	public void after(JoinPoint jp) {
		Signature sig = jp.getSignature();
		String name = sig.getDeclaringTypeName() + "#" + sig.getName() + "メソッド";
		System.out.println(name + " 終了");
	}

	@AfterReturning(value = "execution(* ProductXml.load(..))", returning = "product")
	public void after(JoinPoint jp, Product product) {
		Signature sig = jp.getSignature();
		String name = sig.getDeclaringTypeName() + "#" + sig.getName() + "メソッド";
		System.out.println(name + " 終了 product=" + product);
	}

}
