package example.tryspring.cb2_oxm;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.stereotype.Component;

/**
 * ProductインスタンスとXMLファイルを相互変換するクラスです。
 * <p>
 * マーシャル、アンマーシャルのインスタンス変数は、Spring OXM（JAXB）で設定されます。 JAXBは、Java SE
 * 6以降のJDKに同梱されているらしいです。
 * </p>
 */
@Component
public class ProductXmlImpl implements ProductXml {

	@Autowired
	private Marshaller marshaller;
	@Autowired
	private Unmarshaller unmarshaller;

	@Override
	public void save(String path, Product product) throws IOException {
		FileOutputStream os = null;
		try {
			os = new FileOutputStream(path);
			this.marshaller.marshal(product, new StreamResult(os));
		} finally {
			if (os != null) {
				os.close();
			}
		}
	}

	@Override
	public Product load(String path) throws IOException {
		Product product = null;
		FileInputStream is = null;
		try {
			is = new FileInputStream(path);
			product = (Product) this.unmarshaller
					.unmarshal(new StreamSource(is));
		} finally {
			if (is != null) {
				is.close();
			}
		}
		return product;
	}

}
