package example.tryspring.cb6_embeddeddatabase;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import example.tryspring.c4_db.Product;
import example.tryspring.c4_db.ProductDao;

/**
 * 「付録B.6 組み込みデータベースサポート」用のメインクラスです。
 * 書籍では、具体的なコーディング例が、applicationContext.xmlのみでした。 その他の部分は、調べながら作成しました。
 */
public class ChapterB6Main {

	public static void main(String[] args) {
		ChapterB6Main main = new ChapterB6Main();
		main.run();
	}

	private void run() {
		ApplicationContext appContext = new ClassPathXmlApplicationContext(
				"/example/tryspring/cb6_embeddeddatabase/applicationContext.xml");
		ProductDao dao = appContext.getBean(ProductDao.class);

		// SELECT
		print("count=" + dao.count());
		print("product=" + dao.find("ホッチキス"));

		// INSERT
		print("insert=" + dao.insert(new Product("定規", 50)));
		print("count=" + dao.count());
	}

	private void print(String msg) {
		System.out.println(msg);
	}
}
