//
//  BSIPreferenceWindowController.m
//  BSInlinePreviewer
//
//  Created by 堀 昌樹 on 12/07/22.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "BSIPreferenceWindowController.h"
#import "BSIThumbnailSizeView.h"


@interface BSIPreferenceWindowController ()

@end

@implementation BSIPreferenceWindowController
@synthesize sizeView;

- (id)init
{
	self = [super initWithWindowNibName:NSStringFromClass([self class])];
	return self;
}
//- (id)initWithWindow:(NSWindow *)window
//{
//    self = [super initWithWindow:window];
//    if (self) {
//        // Initialization code here.
//    }
//    
//    return self;
//}
//
- (void)windowDidLoad
{
    [super windowDidLoad];
	
	[[self window] setFrameAutosaveName:@"com.masakih.BSInlinePreviewer.BSIPreferenceWindow"];
	[self willChangeValueForKey:@"sizeString"];
    self.sizeView.imageSize = _thumbailSize;
	[self didChangeValueForKey:@"sizeString"];
    [sizeView addObserver:self
			   forKeyPath:@"imageSize"
				  options:0
				  context:sizeView];
}
- (NSSize)thumbnailSize
{
	return sizeView.imageSize;
}
- (void)setThumbnailSize:(NSSize)thumbnailSize
{
	if(NSEqualSizes(_thumbailSize, thumbnailSize)) return;
	
	_thumbailSize = thumbnailSize;
	sizeView.imageSize = thumbnailSize;
}

- (NSString *)sizeString
{
	return [NSString stringWithFormat:@"%.0f %C %.0f", self.thumbnailSize.width, 0x00D7, self.thumbnailSize.height];
}

+(NSSet *)keyPathsForValuesAffectingSizeString
{
	return [NSSet setWithObject:@"thumbnailSize"];
}
- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context
{
	if(context == sizeView) {
		[self willChangeValueForKey:@"thumbnailSize"];
		_thumbailSize = sizeView.imageSize;
		[self didChangeValueForKey:@"thumbnailSize"];
		return;
	}
	
	[super observeValueForKeyPath:keyPath ofObject:object change:change context:context];
}

@end
