//
//  BSInlinePreviewerEx.m
//  BSInlinePreviewer
//
//  Created by 堀 昌樹 on 12/05/17.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "BSInlinePreviewerEx.h"

NSString *const CMRThreadViewerDidChangeThreadNotification  = @"CMRThreadViewerDidChangeThreadNotification";
#import "BSIPEReplacer.h"


@implementation BSInlinePreviewerEx
// Designated Initializer
- (id)initWithPreferences:(AppDefaults *)prefs
{
	self = [super initWithPreferences:prefs];
	if(self) {
		NSNotificationCenter *nc = [NSNotificationCenter defaultCenter];
		[nc addObserver:self
			   selector:@selector(viewerDidEndFinishing:)
				   name:CMRThreadViewerDidChangeThreadNotification
				 object:nil];
	}
	
	return self;
}

- (void)viewerDidEndFinishing:(id)no
{
	id threadViewer = [no object];
	NSTextView *tv = [threadViewer textView];
	BSIPEReplacer *replacer = [BSIPEReplacer replaserWithTextView:tv];
	replacer.owner = self;
	replacer.textView = tv;
}


@end
