//
//  BEBooklogBooksExporter.m
//  BooksExporter
//
//  Created by Hori,Masaki on 11/02/28.
//  Copyright 2011 masakih. All rights reserved.
//

#import "BEBooklogBooksExporter.h"
#import "BEBookInformation.h"


@implementation BEBooklogBooksExporter
- (NSString *)statusNameWithBook:(BEBookInformation *)book
{
	NSString *result = nil;
	switch([book.status intValue]) {
		case 0:
			result = @"-";
			break;
		case 1:
			result = NSLocalizedString(@"Want read", @"Want read");
			break;
		case 2:
			result = NSLocalizedString(@"Now reading", @"Now reading");
			break;
		case 3:
			result = NSLocalizedString(@"Already read", @"Already read");
			break;
		case 4:
			result = NSLocalizedString(@"Stack", @"Stack");
			break;
		default:
			return @"";
	}
	return result;
}

- (id)init
{
	self = [super init];
	if(self) {
		registerDateFormatter = [[NSDateFormatter alloc] init];
		[registerDateFormatter setDateFormat:@"YYYY-MM-dd' 'HH':'mm':'ss"];
		publicateionDateFormatter = [[NSDateFormatter alloc] init];
		[publicateionDateFormatter setDateFormat:@"YYYY"];
	}
	return self;
}
- (void)dealloc
{
	[registerDateFormatter release];
	[publicateionDateFormatter release];
	[super dealloc];
}
- (NSString *)lineForBook:(BEBookInformation *)book
{
	return [NSString stringWithFormat:
			@"\"1\",\"%@\",\"%@\",\"%@\",\"%@\",\"%@\",\"%@\",\"%@\",\"%@\",\"%@\",\"%@\"",
			doubleQuoteQuotedString(book.asin),
			doubleQuoteQuotedString(book.isbn),
			doubleQuoteQuotedString(book.category),
			doubleQuoteQuotedString([book.rating stringValue]),
			doubleQuoteQuotedString([self statusNameWithBook:book]),
			doubleQuoteQuotedString(book.review),
			doubleQuoteQuotedString(tagsString(book.tags)),
			@"",
			doubleQuoteQuotedString([registerDateFormatter stringFromDate:book.registerDate]),
			doubleQuoteQuotedString([registerDateFormatter stringFromDate:book.readDate])];

}
- (BOOL)needsNewLineAtEndOfFile
{
	return YES;
}

@end
