//
//  BEBooksExporter.h
//  BooksExporter
//
//  Created by Hori,Masaki on 11/02/28.
//  Copyright 2011 masakih. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class BEBookInformation;

enum {
	typeBooklogExport = 0,
	typeMediaMarkerExport = 1,
	typeMediaMarkerImport = 2,
	typeMonoColleExport = 3,
	
	typeHatenaDairyType = 100,
};
typedef NSUInteger ExporterType;

@interface BEBooksExporter : NSObject
{
	NSArray *books;
	
	NSMutableArray *lines;
}
@property (retain) NSArray *books;

+ (id)exporterWithType:(NSNumber *)type;

- (BOOL)exportToURL:(NSURL *)url;

NSString *normalizeString(NSString *string);
NSString *doubleQuoteQuotedString(NSString *string);
NSString *tagsString(NSArray *tags);


// for subclass
- (void)buildLines; // send lineForBook: message for each books if needed. you can override for anothor building way.
- (NSString *)lineForBook:(BEBookInformation *)book;
- (NSString *)lineSeparator;  // default line sparator is CRLF.
- (NSStringEncoding)fileEncoding; // default fileEncoding is NSShiftJISStringEncoding.
- (BOOL)needsNewLineAtEndOfFile; // default is NO.

@end
