//
//  BEHatenaDairyExporter.m
//  BooksExporter
//
//  Created by Hori,Masaki on 11/03/05.
//  Copyright 2011 masakih. All rights reserved.
//

#import "BEHatenaDairyExporter.h"
#import "BEBookInformation.h"


@implementation BEHatenaDairyExporter
- (NSString *)lineForBook:(BEBookInformation *)book
{
	if(book.review) {
		return [NSString stringWithFormat:@"[asin:%@:detail]\n%@\n\n",
				book.asin, normalizeString(book.review)];
	}
	return [NSString stringWithFormat:@"[asin:%@:detail]\n\n", book.asin];
}
- (NSString *)lineSeparator
{
	return @"\n";
}
- (NSStringEncoding)fileEncoding
{
	return NSUTF8StringEncoding;
}
@end
