//
//  BEMonoColleExporter.m
//  BooksExporter
//
//  Created by Hori,Masaki on 11/06/02.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "BEMonoColleExporter.h"
#import "BEBookInformation.h"


@implementation BEMonoColleExporter
- (id)init
{
	self = [super init];
	if(self) {
		dateFormatter = [[NSDateFormatter alloc] init];
		[dateFormatter setDateFormat:@"YYYY/MM/dd"];
	}
	return self;
}
- (void)dealloc
{
	[dateFormatter release];
	[super dealloc];
}
- (NSString *)lineForBook:(BEBookInformation *)book
{
	NSString *tag[5];
	NSInteger i = 0;
	for(i = 0; i < 5; i++) {
		tag[i] = @"";
	}
	i = 0;
	for(NSString *tagString in book.tags) {
		tag[i++] = tagString;
		if(i >= 5) break;
	}
	
	return [NSString stringWithFormat:@"%@,,%@,,,,,,,,%@,%@,,,1,1,%@,%@,%@,%@,%@,%@,%@",
			doubleQuoteQuotedString(book.asin),
			// rakuten ID
			doubleQuoteQuotedString(book.isbn),
			// JAN
			// Product Name
			// Page URL
			// Category 1
			// Category 2
			// Category 3
			doubleQuoteQuotedString([dateFormatter stringFromDate:book.registerDate]),
			doubleQuoteQuotedString([dateFormatter stringFromDate:book.readDate]),
			// Purchase location
			// Purchase price
			// Is public
			// type
			doubleQuoteQuotedString(book.review),
			doubleQuoteQuotedString([book.rating stringValue]),
			doubleQuoteQuotedString(tag[0]),
			doubleQuoteQuotedString(tag[1]),
			doubleQuoteQuotedString(tag[2]),
			doubleQuoteQuotedString(tag[3]),
			doubleQuoteQuotedString(tag[4])
			];
}
- (BOOL)needsNewLineAtEndOfFile
{
	return YES;
}

@end
