//
//  BEPreferencePanel.m
//  BooksExporter
//
//  Created by Hori,Masaki on 11/03/25.
//  Copyright 2011 masakih. All rights reserved.
//

#import "BEPreferencePanel.h"

@interface BEPreferencePanel ()
@property (nonatomic, retain) NSViewController *currentPane;
@end

@interface BEPreferencePanel (BEPrivate)
- (NSToolbarItem *)toolbarItemForIdentifier:(NSString *)identifier;
- (void)setCurrentPane:(NSViewController *)newPane;
- (void)setPaneView:(NSView *)view;
@end

@implementation BEPreferencePanel
@synthesize toolbar;
@synthesize viewControllerClassNames;
@synthesize currentPane;

#pragma mark singleton
static BEPreferencePanel *sharedInstance = nil;

+ (BEPreferencePanel *)sharedInstance
{
	if (sharedInstance == nil) {
		sharedInstance = [[super allocWithZone:NULL] init];
	}
    return sharedInstance;
}

+ (id)allocWithZone:(NSZone *)zone
{
    return [[self sharedInstance] retain];
}

- (id)copyWithZone:(NSZone *)zone
{
    return self;
}

- (id)retain
{
    return self;
}

- (NSUInteger)retainCount
{
    return NSUIntegerMax;  //denotes an object that cannot be released
}

- (void)release
{
    //do nothing
}

- (id)autorelease
{
    return self;
}


- (id)init
{
	if(sharedInstance) {
		[super init];
		[self release];
		return sharedInstance;
	}
	
	self = [super initWithWindowNibName:@"PreferencePanel"];
	if(self) {
		panes = [[NSMutableDictionary alloc] init];
	}
	return self;
}
- (void)dealloc
{
	[toolbar release];
	[panes release];
	[super dealloc];
}

- (void)windowDidLoad
{
	NSString *firstSelectItemIdentifier = [viewControllerClassNames objectAtIndex:0];
	[toolbar setSelectedItemIdentifier:firstSelectItemIdentifier];
	NSViewController *pane = [panes objectForKey:firstSelectItemIdentifier];
	[self setCurrentPane:pane];
}

- (NSToolbarItem *)toolbarItemForIdentifier:(NSString *)identifier
{
	NSToolbarItem *item = [[[NSToolbarItem alloc] initWithItemIdentifier:identifier] autorelease];
	[item setAction:@selector(didSelectToolbarItem:)];
	[item setTarget:self];
	
	return item;
}

- (void)setCurrentPane:(NSViewController *)newPane
{
	if(currentPane == newPane) return;
	currentPane = newPane;
	
	NSView *view = currentPane.view;
	[self setPaneView:view];
}

- (void)setPaneView:(NSView *)view
{
	NSView *contView = self.window.contentView;
	
	NSRect frame = view.frame;
	[contView addSubview:view];
	NSRect winFrame = [self.window frameRectForContentRect:frame];
	winFrame.origin = self.window.frame.origin;
	winFrame.origin.y -= NSHeight(frame) - NSHeight(winFrame);
	[self.window setFrame:winFrame display:YES animate:YES];
}

- (void)setViewControllerClassNames:(NSArray *)array
{
	if(viewControllerClassNames) return;
	
	viewControllerClassNames = [[NSArray alloc] initWithArray:array];
}

- (IBAction)didSelectToolbarItem:(id)sender
{
	NSViewController *pane = [panes objectForKey:[sender itemIdentifier]];
	[self setCurrentPane:pane];
}

#pragma mark Toolbar Delegate
- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag
{
	if(flag) {
		Class class = NSClassFromString(itemIdentifier);
		id pane = [[[class alloc] init] autorelease];
		[panes setObject:pane forKey:itemIdentifier];
	}
	
	NSToolbarItem *item = [self toolbarItemForIdentifier:itemIdentifier];
	id pane = [panes objectForKey:itemIdentifier];
	if(pane) {
		[item setLabel:[pane title]];
		if([pane respondsToSelector:@selector(iconName)]) {
			[item setImage:[NSImage imageNamed:[pane iconName]]];
		} else if([pane respondsToSelector:@selector(icon)]) {
			[item setImage:[pane icon]];
		} else {
			[item setImage:[NSImage imageNamed:NSImageNamePreferencesGeneral]];
		}
	} else {
		item = nil;
	}
	
	return item;
}
- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar*)toolbar
{
	return viewControllerClassNames;
}
- (NSArray *)toolbarSelectableItemIdentifiers:(NSToolbar *)toolbar
{
	return viewControllerClassNames;
}

@end
