//
//  GroEvader.h
//  MosaicPreviewerForThousand
//
//  Created by Hori,Masaki on 06/01/15.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "BSImagePreviewerInterface.h"
#import "T2PluginProtocols.h"
#import "MosaicView.h"

@class TemporaryFolder, CIContext, CIFilter, CIImage;

typedef enum {
	kHostBathyScaphe,
	kHostThousand,
} HostType;

@interface GroEvader : NSWindowController <T2URLPreviewing_v100,BSImagePreviewerProtocol>
{
    IBOutlet NSImage *image;
	IBOutlet id indicator;
	IBOutlet MosaicView *view;
		
	int scale;
	NSURLDownload *download;
	TemporaryFolder *downloadFolder;
	NSString *lastFileName;
	NSURL *imageURL;
		
	CIFilter *pixellate;
	CIImage *cImage;
	
	NSTimer *scallingTimer;
	
	AppDefaults *pref;
	
	HostType hostType;
}

-(void)setScale:(int)newScale;
-(int)scale;
-(void)setImage:(NSImage *)image;
-(NSImage *)image;

-(void)setCImage:(CIImage *)cImage;
- (CIImage *)cImage;

- (CIImage *)viewImage;

- (NSURL *)imageURL;
- (void)setImageURL:(NSURL *)url;

-(void)registNotigications;

-(void)loadInBackground:(NSURL *)url;

- (void)openURL:(id)sender;

- (void)setErrorText:(NSString *)text;

@end



#define GELocalizedString(key, comment) \
	[[NSBundle bundleForClass:[GroEvader class]] localizedStringForKey:(key) value:@"" table:nil]
