/**********************************************************************
  unicode.c -  Oniguruma (regular expression library)
**********************************************************************/
/*-
 * Copyright (c) 2002-2008  K.Kosako  <sndgk393 AT ybb DOT ne DOT jp>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "regint.h"

#define ONIGENC_IS_UNICODE_ISO_8859_1_CTYPE(code,ctype) \
  ((EncUNICODE_ISO_8859_1_CtypeTable[code] & CTYPE_TO_BIT(ctype)) != 0)
#if 0
#define ONIGENC_IS_UNICODE_ISO_8859_1_BIT_CTYPE(code,cbit) \
  ((EncUNICODE_ISO_8859_1_CtypeTable[code] & (cbit)) != 0)
#endif

static const unsigned short EncUNICODE_ISO_8859_1_CtypeTable[256] = {
  0x4008, 0x4008, 0x4008, 0x4008, 0x4008, 0x4008, 0x4008, 0x4008,
  0x4008, 0x428c, 0x4289, 0x4288, 0x4288, 0x4288, 0x4008, 0x4008,
  0x4008, 0x4008, 0x4008, 0x4008, 0x4008, 0x4008, 0x4008, 0x4008,
  0x4008, 0x4008, 0x4008, 0x4008, 0x4008, 0x4008, 0x4008, 0x4008,
  0x4284, 0x41a0, 0x41a0, 0x41a0, 0x41a0, 0x41a0, 0x41a0, 0x41a0,
  0x41a0, 0x41a0, 0x41a0, 0x41a0, 0x41a0, 0x41a0, 0x41a0, 0x41a0,
  0x78b0, 0x78b0, 0x78b0, 0x78b0, 0x78b0, 0x78b0, 0x78b0, 0x78b0,
  0x78b0, 0x78b0, 0x41a0, 0x41a0, 0x41a0, 0x41a0, 0x41a0, 0x41a0,
  0x41a0, 0x7ca2, 0x7ca2, 0x7ca2, 0x7ca2, 0x7ca2, 0x7ca2, 0x74a2,
  0x74a2, 0x74a2, 0x74a2, 0x74a2, 0x74a2, 0x74a2, 0x74a2, 0x74a2,
  0x74a2, 0x74a2, 0x74a2, 0x74a2, 0x74a2, 0x74a2, 0x74a2, 0x74a2,
  0x74a2, 0x74a2, 0x74a2, 0x41a0, 0x41a0, 0x41a0, 0x41a0, 0x51a0,
  0x41a0, 0x78e2, 0x78e2, 0x78e2, 0x78e2, 0x78e2, 0x78e2, 0x70e2,
  0x70e2, 0x70e2, 0x70e2, 0x70e2, 0x70e2, 0x70e2, 0x70e2, 0x70e2,
  0x70e2, 0x70e2, 0x70e2, 0x70e2, 0x70e2, 0x70e2, 0x70e2, 0x70e2,
  0x70e2, 0x70e2, 0x70e2, 0x41a0, 0x41a0, 0x41a0, 0x41a0, 0x4008,
  0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0288, 0x0008, 0x0008,
  0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
  0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
  0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
  0x0284, 0x01a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0, 0x00a0,
  0x00a0, 0x00a0, 0x30e2, 0x01a0, 0x00a0, 0x00a8, 0x00a0, 0x00a0,
  0x00a0, 0x00a0, 0x10a0, 0x10a0, 0x00a0, 0x30e2, 0x00a0, 0x01a0,
  0x00a0, 0x10a0, 0x30e2, 0x01a0, 0x10a0, 0x10a0, 0x10a0, 0x01a0,
  0x34a2, 0x34a2, 0x34a2, 0x34a2, 0x34a2, 0x34a2, 0x34a2, 0x34a2,
  0x34a2, 0x34a2, 0x34a2, 0x34a2, 0x34a2, 0x34a2, 0x34a2, 0x34a2,
  0x34a2, 0x34a2, 0x34a2, 0x34a2, 0x34a2, 0x34a2, 0x34a2, 0x00a0,
  0x34a2, 0x34a2, 0x34a2, 0x34a2, 0x34a2, 0x34a2, 0x34a2, 0x30e2,
  0x30e2, 0x30e2, 0x30e2, 0x30e2, 0x30e2, 0x30e2, 0x30e2, 0x30e2,
  0x30e2, 0x30e2, 0x30e2, 0x30e2, 0x30e2, 0x30e2, 0x30e2, 0x30e2,
  0x30e2, 0x30e2, 0x30e2, 0x30e2, 0x30e2, 0x30e2, 0x30e2, 0x00a0,
  0x30e2, 0x30e2, 0x30e2, 0x30e2, 0x30e2, 0x30e2, 0x30e2, 0x30e2
};

/* 'NEWLINE' */
static const OnigCodePoint CR_NEWLINE[] = {
  1,
  0x000a, 0x000a
}; /* CR_NEWLINE */

/* 'Alpha': [[:Alpha:]] */
static const OnigCodePoint CR_Alpha[] = {
  418,
  0x0041, 0x005a,
  0x0061, 0x007a,
  0x00aa, 0x00aa,
  0x00b5, 0x00b5,
  0x00ba, 0x00ba,
  0x00c0, 0x00d6,
  0x00d8, 0x00f6,
  0x00f8, 0x0241,
  0x0250, 0x02c1,
  0x02c6, 0x02d1,
  0x02e0, 0x02e4,
  0x02ee, 0x02ee,
  0x0300, 0x036f,
  0x037a, 0x037a,
  0x0386, 0x0386,
  0x0388, 0x038a,
  0x038c, 0x038c,
  0x038e, 0x03a1,
  0x03a3, 0x03ce,
  0x03d0, 0x03f5,
  0x03f7, 0x0481,
  0x0483, 0x0486,
  0x0488, 0x04ce,
  0x04d0, 0x04f9,
  0x0500, 0x050f,
  0x0531, 0x0556,
  0x0559, 0x0559,
  0x0561, 0x0587,
  0x0591, 0x05b9,
  0x05bb, 0x05bd,
  0x05bf, 0x05bf,
  0x05c1, 0x05c2,
  0x05c4, 0x05c5,
  0x05c7, 0x05c7,
  0x05d0, 0x05ea,
  0x05f0, 0x05f2,
  0x0610, 0x0615,
  0x0621, 0x063a,
  0x0640, 0x065e,
  0x066e, 0x06d3,
  0x06d5, 0x06dc,
  0x06de, 0x06e8,
  0x06ea, 0x06ef,
  0x06fa, 0x06fc,
  0x06ff, 0x06ff,
  0x0710, 0x074a,
  0x074d, 0x076d,
  0x0780, 0x07b1,
  0x0901, 0x0939,
  0x093c, 0x094d,
  0x0950, 0x0954,
  0x0958, 0x0963,
  0x097d, 0x097d,
  0x0981, 0x0983,
  0x0985, 0x098c,
  0x098f, 0x0990,
  0x0993, 0x09a8,
  0x09aa, 0x09b0,
  0x09b2, 0x09b2,
  0x09b6, 0x09b9,
  0x09bc, 0x09c4,
  0x09c7, 0x09c8,
  0x09cb, 0x09ce,
  0x09d7, 0x09d7,
  0x09dc, 0x09dd,
  0x09df, 0x09e3,
  0x09f0, 0x09f1,
  0x0a01, 0x0a03,
  0x0a05, 0x0a0a,
  0x0a0f, 0x0a10,
  0x0a13, 0x0a28,
  0x0a2a, 0x0a30,
  0x0a32, 0x0a33,
  0x0a35, 0x0a36,
  0x0a38, 0x0a39,
  0x0a3c, 0x0a3c,
  0x0a3e, 0x0a42,
  0x0a47, 0x0a48,
  0x0a4b, 0x0a4d,
  0x0a59, 0x0a5c,
  0x0a5e, 0x0a5e,
  0x0a70, 0x0a74,
  0x0a81, 0x0a83,
  0x0a85, 0x0a8d,
  0x0a8f, 0x0a91,
  0x0a93, 0x0aa8,
  0x0aaa, 0x0ab0,
  0x0ab2, 0x0ab3,
  0x0ab5, 0x0ab9,
  0x0abc, 0x0ac5,
  0x0ac7, 0x0ac9,
  0x0acb, 0x0acd,
  0x0ad0, 0x0ad0,
  0x0ae0, 0x0ae3,
  0x0b01, 0x0b03,
  0x0b05, 0x0b0c,
  0x0b0f, 0x0b10,
  0x0b13, 0x0b28,
  0x0b2a, 0x0b30,
  0x0b32, 0x0b33,
  0x0b35, 0x0b39,
  0x0b3c, 0x0b43,
  0x0b47, 0x0b48,
  0x0b4b, 0x0b4d,
  0x0b56, 0x0b57,
  0x0b5c, 0x0b5d,
  0x0b5f, 0x0b61,
  0x0b71, 0x0b71,
  0x0b82, 0x0b83,
  0x0b85, 0x0b8a,
  0x0b8e, 0x0b90,
  0x0b92, 0x0b95,
  0x0b99, 0x0b9a,
  0x0b9c, 0x0b9c,
  0x0b9e, 0x0b9f,
  0x0ba3, 0x0ba4,
  0x0ba8, 0x0baa,
  0x0bae, 0x0bb9,
  0x0bbe, 0x0bc2,
  0x0bc6, 0x0bc8,
  0x0bca, 0x0bcd,
  0x0bd7, 0x0bd7,
  0x0c01, 0x0c03,
  0x0c05, 0x0c0c,
  0x0c0e, 0x0c10,
  0x0c12, 0x0c28,
  0x0c2a, 0x0c33,
  0x0c35, 0x0c39,
  0x0c3e, 0x0c44,
  0x0c46, 0x0c48,
  0x0c4a, 0x0c4d,
  0x0c55, 0x0c56,
  0x0c60, 0x0c61,
  0x0c82, 0x0c83,
  0x0c85, 0x0c8c,
  0x0c8e, 0x0c90,
  0x0c92, 0x0ca8,
  0x0caa, 0x0cb3,
  0x0cb5, 0x0cb9,
  0x0cbc, 0x0cc4,
  0x0cc6, 0x0cc8,
  0x0cca, 0x0ccd,
  0x0cd5, 0x0cd6,
  0x0cde, 0x0cde,
  0x0ce0, 0x0ce1,
  0x0d02, 0x0d03,
  0x0d05, 0x0d0c,
  0x0d0e, 0x0d10,
  0x0d12, 0x0d28,
  0x0d2a, 0x0d39,
  0x0d3e, 0x0d43,
  0x0d46, 0x0d48,
  0x0d4a, 0x0d4d,
  0x0d57, 0x0d57,
  0x0d60, 0x0d61,
  0x0d82, 0x0d83,
  0x0d85, 0x0d96,
  0x0d9a, 0x0db1,
  0x0db3, 0x0dbb,
  0x0dbd, 0x0dbd,
  0x0dc0, 0x0dc6,
  0x0dca, 0x0dca,
  0x0dcf, 0x0dd4,
  0x0dd6, 0x0dd6,
  0x0dd8, 0x0ddf,
  0x0df2, 0x0df3,
  0x0e01, 0x0e3a,
  0x0e40, 0x0e4e,
  0x0e81, 0x0e82,
  0x0e84, 0x0e84,
  0x0e87, 0x0e88,
  0x0e8a, 0x0e8a,
  0x0e8d, 0x0e8d,
  0x0e94, 0x0e97,
  0x0e99, 0x0e9f,
  0x0ea1, 0x0ea3,
  0x0ea5, 0x0ea5,
  0x0ea7, 0x0ea7,
  0x0eaa, 0x0eab,
  0x0ead, 0x0eb9,
  0x0ebb, 0x0ebd,
  0x0ec0, 0x0ec4,
  0x0ec6, 0x0ec6,
  0x0ec8, 0x0ecd,
  0x0edc, 0x0edd,
  0x0f00, 0x0f00,
  0x0f18, 0x0f19,
  0x0f35, 0x0f35,
  0x0f37, 0x0f37,
  0x0f39, 0x0f39,
  0x0f3e, 0x0f47,
  0x0f49, 0x0f6a,
  0x0f71, 0x0f84,
  0x0f86, 0x0f8b,
  0x0f90, 0x0f97,
  0x0f99, 0x0fbc,
  0x0fc6, 0x0fc6,
  0x1000, 0x1021,
  0x1023, 0x1027,
  0x1029, 0x102a,
  0x102c, 0x1032,
  0x1036, 0x1039,
  0x1050, 0x1059,
  0x10a0, 0x10c5,
  0x10d0, 0x10fa,
  0x10fc, 0x10fc,
  0x1100, 0x1159,
  0x115f, 0x11a2,
  0x11a8, 0x11f9,
  0x1200, 0x1248,
  0x124a, 0x124d,
  0x1250, 0x1256,
  0x1258, 0x1258,
  0x125a, 0x125d,
  0x1260, 0x1288,
  0x128a, 0x128d,
  0x1290, 0x12b0,
  0x12b2, 0x12b5,
  0x12b8, 0x12be,
  0x12c0, 0x12c0,
  0x12c2, 0x12c5,
  0x12c8, 0x12d6,
  0x12d8, 0x1310,
  0x1312, 0x1315,
  0x1318, 0x135a,
  0x135f, 0x135f,
  0x1380, 0x138f,
  0x13a0, 0x13f4,
  0x1401, 0x166c,
  0x166f, 0x1676,
  0x1681, 0x169a,
  0x16a0, 0x16ea,
  0x1700, 0x170c,
  0x170e, 0x1714,
  0x1720, 0x1734,
  0x1740, 0x1753,
  0x1760, 0x176c,
  0x176e, 0x1770,
  0x1772, 0x1773,
  0x1780, 0x17b3,
  0x17b6, 0x17d3,
  0x17d7, 0x17d7,
  0x17dc, 0x17dd,
  0x180b, 0x180d,
  0x1820, 0x1877,
  0x1880, 0x18a9,
  0x1900, 0x191c,
  0x1920, 0x192b,
  0x1930, 0x193b,
  0x1950, 0x196d,
  0x1970, 0x1974,
  0x1980, 0x19a9,
  0x19b0, 0x19c9,
  0x1a00, 0x1a1b,
  0x1d00, 0x1dc3,
  0x1e00, 0x1e9b,
  0x1ea0, 0x1ef9,
  0x1f00, 0x1f15,
  0x1f18, 0x1f1d,
  0x1f20, 0x1f45,
  0x1f48, 0x1f4d,
  0x1f50, 0x1f57,
  0x1f59, 0x1f59,
  0x1f5b, 0x1f5b,
  0x1f5d, 0x1f5d,
  0x1f5f, 0x1f7d,
  0x1f80, 0x1fb4,
  0x1fb6, 0x1fbc,
  0x1fbe, 0x1fbe,
  0x1fc2, 0x1fc4,
  0x1fc6, 0x1fcc,
  0x1fd0, 0x1fd3,
  0x1fd6, 0x1fdb,
  0x1fe0, 0x1fec,
  0x1ff2, 0x1ff4,
  0x1ff6, 0x1ffc,
  0x2071, 0x2071,
  0x207f, 0x207f,
  0x2090, 0x2094,
  0x20d0, 0x20eb,
  0x2102, 0x2102,
  0x2107, 0x2107,
  0x210a, 0x2113,
  0x2115, 0x2115,
  0x2119, 0x211d,
  0x2124, 0x2124,
  0x2126, 0x2126,
  0x2128, 0x2128,
  0x212a, 0x212d,
  0x212f, 0x2131,
  0x2133, 0x2139,
  0x213c, 0x213f,
  0x2145, 0x2149,
  0x2c00, 0x2c2e,
  0x2c30, 0x2c5e,
  0x2c80, 0x2ce4,
  0x2d00, 0x2d25,
  0x2d30, 0x2d65,
  0x2d6f, 0x2d6f,
  0x2d80, 0x2d96,
  0x2da0, 0x2da6,
  0x2da8, 0x2dae,
  0x2db0, 0x2db6,
  0x2db8, 0x2dbe,
  0x2dc0, 0x2dc6,
  0x2dc8, 0x2dce,
  0x2dd0, 0x2dd6,
  0x2dd8, 0x2dde,
  0x3005, 0x3006,
  0x302a, 0x302f,
  0x3031, 0x3035,
  0x303b, 0x303c,
  0x3041, 0x3096,
  0x3099, 0x309a,
  0x309d, 0x309f,
  0x30a1, 0x30fa,
  0x30fc, 0x30ff,
  0x3105, 0x312c,
  0x3131, 0x318e,
  0x31a0, 0x31b7,
  0x31f0, 0x31ff,
  0x3400, 0x4db5,
  0x4e00, 0x9fbb,
  0xa000, 0xa48c,
  0xa800, 0xa827,
  0xac00, 0xd7a3,
  0xf900, 0xfa2d,
  0xfa30, 0xfa6a,
  0xfa70, 0xfad9,
  0xfb00, 0xfb06,
  0xfb13, 0xfb17,
  0xfb1d, 0xfb28,
  0xfb2a, 0xfb36,
  0xfb38, 0xfb3c,
  0xfb3e, 0xfb3e,
  0xfb40, 0xfb41,
  0xfb43, 0xfb44,
  0xfb46, 0xfbb1,
  0xfbd3, 0xfd3d,
  0xfd50, 0xfd8f,
  0xfd92, 0xfdc7,
  0xfdf0, 0xfdfb,
  0xfe00, 0xfe0f,
  0xfe20, 0xfe23,
  0xfe70, 0xfe74,
  0xfe76, 0xfefc,
  0xff21, 0xff3a,
  0xff41, 0xff5a,
  0xff66, 0xffbe,
  0xffc2, 0xffc7,
  0xffca, 0xffcf,
  0xffd2, 0xffd7,
  0xffda, 0xffdc,
  0x10000, 0x1000b,
  0x1000d, 0x10026,
  0x10028, 0x1003a,
  0x1003c, 0x1003d,
  0x1003f, 0x1004d,
  0x10050, 0x1005d,
  0x10080, 0x100fa,
  0x10300, 0x1031e,
  0x10330, 0x10349,
  0x10380, 0x1039d,
  0x103a0, 0x103c3,
  0x103c8, 0x103cf,
  0x10400, 0x1049d,
  0x10800, 0x10805,
  0x10808, 0x10808,
  0x1080a, 0x10835,
  0x10837, 0x10838,
  0x1083c, 0x1083c,
  0x1083f, 0x1083f,
  0x10a00, 0x10a03,
  0x10a05, 0x10a06,
  0x10a0c, 0x10a13,
  0x10a15, 0x10a17,
  0x10a19, 0x10a33,
  0x10a38, 0x10a3a,
  0x10a3f, 0x10a3f,
  0x1d165, 0x1d169,
  0x1d16d, 0x1d172,
  0x1d17b, 0x1d182,
  0x1d185, 0x1d18b,
  0x1d1aa, 0x1d1ad,
  0x1d242, 0x1d244,
  0x1d400, 0x1d454,
  0x1d456, 0x1d49c,
  0x1d49e, 0x1d49f,
  0x1d4a2, 0x1d4a2,
  0x1d4a5, 0x1d4a6,
  0x1d4a9, 0x1d4ac,
  0x1d4ae, 0x1d4b9,
  0x1d4bb, 0x1d4bb,
  0x1d4bd, 0x1d4c3,
  0x1d4c5, 0x1d505,
  0x1d507, 0x1d50a,
  0x1d50d, 0x1d514,
  0x1d516, 0x1d51c,
  0x1d51e, 0x1d539,
  0x1d53b, 0x1d53e,
  0x1d540, 0x1d544,
  0x1d546, 0x1d546,
  0x1d54a, 0x1d550,
  0x1d552, 0x1d6a5,
  0x1d6a8, 0x1d6c0,
  0x1d6c2, 0x1d6da,
  0x1d6dc, 0x1d6fa,
  0x1d6fc, 0x1d714,
  0x1d716, 0x1d734,
  0x1d736, 0x1d74e,
  0x1d750, 0x1d76e,
  0x1d770, 0x1d788,
  0x1d78a, 0x1d7a8,
  0x1d7aa, 0x1d7c2,
  0x1d7c4, 0x1d7c9,
  0x20000, 0x2a6d6,
  0x2f800, 0x2fa1d,
  0xe0100, 0xe01ef
}; /* CR_Alpha */

/* 'Blank': [[:Blank:]] */
static const OnigCodePoint CR_Blank[] = {
  9,
  0x0009, 0x0009,
  0x0020, 0x0020,
  0x00a0, 0x00a0,
  0x1680, 0x1680,
  0x180e, 0x180e,
  0x2000, 0x200a,
  0x202f, 0x202f,
  0x205f, 0x205f,
  0x3000, 0x3000
}; /* CR_Blank */

/* 'Cntrl': [[:Cntrl:]] */
static const OnigCodePoint CR_Cntrl[] = {
  19,
  0x0000, 0x001f,
  0x007f, 0x009f,
  0x00ad, 0x00ad,
  0x0600, 0x0603,
  0x06dd, 0x06dd,
  0x070f, 0x070f,
  0x17b4, 0x17b5,
  0x200b, 0x200f,
  0x202a, 0x202e,
  0x2060, 0x2063,
  0x206a, 0x206f,
  0xd800, 0xf8ff,
  0xfeff, 0xfeff,
  0xfff9, 0xfffb,
  0x1d173, 0x1d17a,
  0xe0001, 0xe0001,
  0xe0020, 0xe007f,
  0xf0000, 0xffffd,
  0x100000, 0x10fffd
}; /* CR_Cntrl */

/* 'Digit': [[:Digit:]] */
static const OnigCodePoint CR_Digit[] = {
  23,
  0x0030, 0x0039,
  0x0660, 0x0669,
  0x06f0, 0x06f9,
  0x0966, 0x096f,
  0x09e6, 0x09ef,
  0x0a66, 0x0a6f,
  0x0ae6, 0x0aef,
  0x0b66, 0x0b6f,
  0x0be6, 0x0bef,
  0x0c66, 0x0c6f,
  0x0ce6, 0x0cef,
  0x0d66, 0x0d6f,
  0x0e50, 0x0e59,
  0x0ed0, 0x0ed9,
  0x0f20, 0x0f29,
  0x1040, 0x1049,
  0x17e0, 0x17e9,
  0x1810, 0x1819,
  0x1946, 0x194f,
  0x19d0, 0x19d9,
  0xff10, 0xff19,
  0x104a0, 0x104a9,
  0x1d7ce, 0x1d7ff
}; /* CR_Digit */

/* 'Graph': [[:Graph:]] */
static const OnigCodePoint CR_Graph[] = {
  424,
  0x0021, 0x007e,
  0x00a1, 0x0241,
  0x0250, 0x036f,
  0x0374, 0x0375,
  0x037a, 0x037a,
  0x037e, 0x037e,
  0x0384, 0x038a,
  0x038c, 0x038c,
  0x038e, 0x03a1,
  0x03a3, 0x03ce,
  0x03d0, 0x0486,
  0x0488, 0x04ce,
  0x04d0, 0x04f9,
  0x0500, 0x050f,
  0x0531, 0x0556,
  0x0559, 0x055f,
  0x0561, 0x0587,
  0x0589, 0x058a,
  0x0591, 0x05b9,
  0x05bb, 0x05c7,
  0x05d0, 0x05ea,
  0x05f0, 0x05f4,
  0x0600, 0x0603,
  0x060b, 0x0615,
  0x061b, 0x061b,
  0x061e, 0x061f,
  0x0621, 0x063a,
  0x0640, 0x065e,
  0x0660, 0x070d,
  0x070f, 0x074a,
  0x074d, 0x076d,
  0x0780, 0x07b1,
  0x0901, 0x0939,
  0x093c, 0x094d,
  0x0950, 0x0954,
  0x0958, 0x0970,
  0x097d, 0x097d,
  0x0981, 0x0983,
  0x0985, 0x098c,
  0x098f, 0x0990,
  0x0993, 0x09a8,
  0x09aa, 0x09b0,
  0x09b2, 0x09b2,
  0x09b6, 0x09b9,
  0x09bc, 0x09c4,
  0x09c7, 0x09c8,
  0x09cb, 0x09ce,
  0x09d7, 0x09d7,
  0x09dc, 0x09dd,
  0x09df, 0x09e3,
  0x09e6, 0x09fa,
  0x0a01, 0x0a03,
  0x0a05, 0x0a0a,
  0x0a0f, 0x0a10,
  0x0a13, 0x0a28,
  0x0a2a, 0x0a30,
  0x0a32, 0x0a33,
  0x0a35, 0x0a36,
  0x0a38, 0x0a39,
  0x0a3c, 0x0a3c,
  0x0a3e, 0x0a42,
  0x0a47, 0x0a48,
  0x0a4b, 0x0a4d,
  0x0a59, 0x0a5c,
  0x0a5e, 0x0a5e,
  0x0a66, 0x0a74,
  0x0a81, 0x0a83,
  0x0a85, 0x0a8d,
  0x0a8f, 0x0a91,
  0x0a93, 0x0aa8,
  0x0aaa, 0x0ab0,
  0x0ab2, 0x0ab3,
  0x0ab5, 0x0ab9,
  0x0abc, 0x0ac5,
  0x0ac7, 0x0ac9,
  0x0acb, 0x0acd,
  0x0ad0, 0x0ad0,
  0x0ae0, 0x0ae3,
  0x0ae6, 0x0aef,
  0x0af1, 0x0af1,
  0x0b01, 0x0b03,
  0x0b05, 0x0b0c,
  0x0b0f, 0x0b10,
  0x0b13, 0x0b28,
  0x0b2a, 0x0b30,
  0x0b32, 0x0b33,
  0x0b35, 0x0b39,
  0x0b3c, 0x0b43,
  0x0b47, 0x0b48,
  0x0b4b, 0x0b4d,
  0x0b56, 0x0b57,
  0x0b5c, 0x0b5d,
  0x0b5f, 0x0b61,
  0x0b66, 0x0b71,
  0x0b82, 0x0b83,
  0x0b85, 0x0b8a,
  0x0b8e, 0x0b90,
  0x0b92, 0x0b95,
  0x0b99, 0x0b9a,
  0x0b9c, 0x0b9c,
  0x0b9e, 0x0b9f,
  0x0ba3, 0x0ba4,
  0x0ba8, 0x0baa,
  0x0bae, 0x0bb9,
  0x0bbe, 0x0bc2,
  0x0bc6, 0x0bc8,
  0x0bca, 0x0bcd,
  0x0bd7, 0x0bd7,
  0x0be6, 0x0bfa,
  0x0c01, 0x0c03,
  0x0c05, 0x0c0c,
  0x0c0e, 0x0c10,
  0x0c12, 0x0c28,
  0x0c2a, 0x0c33,
  0x0c35, 0x0c39,
  0x0c3e, 0x0c44,
  0x0c46, 0x0c48,
  0x0c4a, 0x0c4d,
  0x0c55, 0x0c56,
  0x0c60, 0x0c61,
  0x0c66, 0x0c6f,
  0x0c82, 0x0c83,
  0x0c85, 0x0c8c,
  0x0c8e, 0x0c90,
  0x0c92, 0x0ca8,
  0x0caa, 0x0cb3,
  0x0cb5, 0x0cb9,
  0x0cbc, 0x0cc4,
  0x0cc6, 0x0cc8,
  0x0cca, 0x0ccd,
  0x0cd5, 0x0cd6,
  0x0cde, 0x0cde,
  0x0ce0, 0x0ce1,
  0x0ce6, 0x0cef,
  0x0d02, 0x0d03,
  0x0d05, 0x0d0c,
  0x0d0e, 0x0d10,
  0x0d12, 0x0d28,
  0x0d2a, 0x0d39,
  0x0d3e, 0x0d43,
  0x0d46, 0x0d48,
  0x0d4a, 0x0d4d,
  0x0d57, 0x0d57,
  0x0d60, 0x0d61,
  0x0d66, 0x0d6f,
  0x0d82, 0x0d83,
  0x0d85, 0x0d96,
  0x0d9a, 0x0db1,
  0x0db3, 0x0dbb,
  0x0dbd, 0x0dbd,
  0x0dc0, 0x0dc6,
  0x0dca, 0x0dca,
  0x0dcf, 0x0dd4,
  0x0dd6, 0x0dd6,
  0x0dd8, 0x0ddf,
  0x0df2, 0x0df4,
  0x0e01, 0x0e3a,
  0x0e3f, 0x0e5b,
  0x0e81, 0x0e82,
  0x0e84, 0x0e84,
  0x0e87, 0x0e88,
  0x0e8a, 0x0e8a,
  0x0e8d, 0x0e8d,
  0x0e94, 0x0e97,
  0x0e99, 0x0e9f,
  0x0ea1, 0x0ea3,
  0x0ea5, 0x0ea5,
  0x0ea7, 0x0ea7,
  0x0eaa, 0x0eab,
  0x0ead, 0x0eb9,
  0x0ebb, 0x0ebd,
  0x0ec0, 0x0ec4,
  0x0ec6, 0x0ec6,
  0x0ec8, 0x0ecd,
  0x0ed0, 0x0ed9,
  0x0edc, 0x0edd,
  0x0f00, 0x0f47,
  0x0f49, 0x0f6a,
  0x0f71, 0x0f8b,
  0x0f90, 0x0f97,
  0x0f99, 0x0fbc,
  0x0fbe, 0x0fcc,
  0x0fcf, 0x0fd1,
  0x1000, 0x1021,
  0x1023, 0x1027,
  0x1029, 0x102a,
  0x102c, 0x1032,
  0x1036, 0x1039,
  0x1040, 0x1059,
  0x10a0, 0x10c5,
  0x10d0, 0x10fc,
  0x1100, 0x1159,
  0x115f, 0x11a2,
  0x11a8, 0x11f9,
  0x1200, 0x1248,
  0x124a, 0x124d,
  0x1250, 0x1256,
  0x1258, 0x1258,
  0x125a, 0x125d,
  0x1260, 0x1288,
  0x128a, 0x128d,
  0x1290, 0x12b0,
  0x12b2, 0x12b5,
  0x12b8, 0x12be,
  0x12c0, 0x12c0,
  0x12c2, 0x12c5,
  0x12c8, 0x12d6,
  0x12d8, 0x1310,
  0x1312, 0x1315,
  0x1318, 0x135a,
  0x135f, 0x137c,
  0x1380, 0x1399,
  0x13a0, 0x13f4,
  0x1401, 0x1676,
  0x1681, 0x169c,
  0x16a0, 0x16f0,
  0x1700, 0x170c,
  0x170e, 0x1714,
  0x1720, 0x1736,
  0x1740, 0x1753,
  0x1760, 0x176c,
  0x176e, 0x1770,
  0x1772, 0x1773,
  0x1780, 0x17dd,
  0x17e0, 0x17e9,
  0x17f0, 0x17f9,
  0x1800, 0x180d,
  0x1810, 0x1819,
  0x1820, 0x1877,
  0x1880, 0x18a9,
  0x1900, 0x191c,
  0x1920, 0x192b,
  0x1930, 0x193b,
  0x1940, 0x1940,
  0x1944, 0x196d,
  0x1970, 0x1974,
  0x1980, 0x19a9,
  0x19b0, 0x19c9,
  0x19d0, 0x19d9,
  0x19de, 0x1a1b,
  0x1a1e, 0x1a1f,
  0x1d00, 0x1dc3,
  0x1e00, 0x1e9b,
  0x1ea0, 0x1ef9,
  0x1f00, 0x1f15,
  0x1f18, 0x1f1d,
  0x1f20, 0x1f45,
  0x1f48, 0x1f4d,
  0x1f50, 0x1f57,
  0x1f59, 0x1f59,
  0x1f5b, 0x1f5b,
  0x1f5d, 0x1f5d,
  0x1f5f, 0x1f7d,
  0x1f80, 0x1fb4,
  0x1fb6, 0x1fc4,
  0x1fc6, 0x1fd3,
  0x1fd6, 0x1fdb,
  0x1fdd, 0x1fef,
  0x1ff2, 0x1ff4,
  0x1ff6, 0x1ffe,
  0x200b, 0x2027,
  0x202a, 0x202e,
  0x2030, 0x205e,
  0x2060, 0x2063,
  0x206a, 0x2071,
  0x2074, 0x208e,
  0x2090, 0x2094,
  0x20a0, 0x20b5,
  0x20d0, 0x20eb,
  0x2100, 0x214c,
  0x2153, 0x2183,
  0x2190, 0x23db,
  0x2400, 0x2426,
  0x2440, 0x244a,
  0x2460, 0x269c,
  0x26a0, 0x26b1,
  0x2701, 0x2704,
  0x2706, 0x2709,
  0x270c, 0x2727,
  0x2729, 0x274b,
  0x274d, 0x274d,
  0x274f, 0x2752,
  0x2756, 0x2756,
  0x2758, 0x275e,
  0x2761, 0x2794,
  0x2798, 0x27af,
  0x27b1, 0x27be,
  0x27c0, 0x27c6,
  0x27d0, 0x27eb,
  0x27f0, 0x2b13,
  0x2c00, 0x2c2e,
  0x2c30, 0x2c5e,
  0x2c80, 0x2cea,
  0x2cf9, 0x2d25,
  0x2d30, 0x2d65,
  0x2d6f, 0x2d6f,
  0x2d80, 0x2d96,
  0x2da0, 0x2da6,
  0x2da8, 0x2dae,
  0x2db0, 0x2db6,
  0x2db8, 0x2dbe,
  0x2dc0, 0x2dc6,
  0x2dc8, 0x2dce,
  0x2dd0, 0x2dd6,
  0x2dd8, 0x2dde,
  0x2e00, 0x2e17,
  0x2e1c, 0x2e1d,
  0x2e80, 0x2e99,
  0x2e9b, 0x2ef3,
  0x2f00, 0x2fd5,
  0x2ff0, 0x2ffb,
  0x3001, 0x303f,
  0x3041, 0x3096,
  0x3099, 0x30ff,
  0x3105, 0x312c,
  0x3131, 0x318e,
  0x3190, 0x31b7,
  0x31c0, 0x31cf,
  0x31f0, 0x321e,
  0x3220, 0x3243,
  0x3250, 0x32fe,
  0x3300, 0x4db5,
  0x4dc0, 0x9fbb,
  0xa000, 0xa48c,
  0xa490, 0xa4c6,
  0xa700, 0xa716,
  0xa800, 0xa82b,
  0xac00, 0xd7a3,
  0xe000, 0xfa2d,
  0xfa30, 0xfa6a,
  0xfa70, 0xfad9,
  0xfb00, 0xfb06,
  0xfb13, 0xfb17,
  0xfb1d, 0xfb36,
  0xfb38, 0xfb3c,
  0xfb3e, 0xfb3e,
  0xfb40, 0xfb41,
  0xfb43, 0xfb44,
  0xfb46, 0xfbb1,
  0xfbd3, 0xfd3f,
  0xfd50, 0xfd8f,
  0xfd92, 0xfdc7,
  0xfdf0, 0xfdfd,
  0xfe00, 0xfe19,
  0xfe20, 0xfe23,
  0xfe30, 0xfe52,
  0xfe54, 0xfe66,
  0xfe68, 0xfe6b,
  0xfe70, 0xfe74,
  0xfe76, 0xfefc,
  0xfeff, 0xfeff,
  0xff01, 0xffbe,
  0xffc2, 0xffc7,
  0xffca, 0xffcf,
  0xffd2, 0xffd7,
  0xffda, 0xffdc,
  0xffe0, 0xffe6,
  0xffe8, 0xffee,
  0xfff9, 0xfffd,
  0x10000, 0x1000b,
  0x1000d, 0x10026,
  0x10028, 0x1003a,
  0x1003c, 0x1003d,
  0x1003f, 0x1004d,
  0x10050, 0x1005d,
  0x10080, 0x100fa,
  0x10100, 0x10102,
  0x10107, 0x10133,
  0x10137, 0x1018a,
  0x10300, 0x1031e,
  0x10320, 0x10323,
  0x10330, 0x1034a,
  0x10380, 0x1039d,
  0x1039f, 0x103c3,
  0x103c8, 0x103d5,
  0x10400, 0x1049d,
  0x104a0, 0x104a9,
  0x10800, 0x10805,
  0x10808, 0x10808,
  0x1080a, 0x10835,
  0x10837, 0x10838,
  0x1083c, 0x1083c,
  0x1083f, 0x1083f,
  0x10a00, 0x10a03,
  0x10a05, 0x10a06,
  0x10a0c, 0x10a13,
  0x10a15, 0x10a17,
  0x10a19, 0x10a33,
  0x10a38, 0x10a3a,
  0x10a3f, 0x10a47,
  0x10a50, 0x10a58,
  0x1d000, 0x1d0f5,
  0x1d100, 0x1d126,
  0x1d12a, 0x1d1dd,
  0x1d200, 0x1d245,
  0x1d300, 0x1d356,
  0x1d400, 0x1d454,
  0x1d456, 0x1d49c,
  0x1d49e, 0x1d49f,
  0x1d4a2, 0x1d4a2,
  0x1d4a5, 0x1d4a6,
  0x1d4a9, 0x1d4ac,
  0x1d4ae, 0x1d4b9,
  0x1d4bb, 0x1d4bb,
  0x1d4bd, 0x1d4c3,
  0x1d4c5, 0x1d505,
  0x1d507, 0x1d50a,
  0x1d50d, 0x1d514,
  0x1d516, 0x1d51c,
  0x1d51e, 0x1d539,
  0x1d53b, 0x1d53e,
  0x1d540, 0x1d544,
  0x1d546, 0x1d546,
  0x1d54a, 0x1d550,
  0x1d552, 0x1d6a5,
  0x1d6a8, 0x1d7c9,
  0x1d7ce, 0x1d7ff,
  0x20000, 0x2a6d6,
  0x2f800, 0x2fa1d,
  0xe0001, 0xe0001,
  0xe0020, 0xe007f,
  0xe0100, 0xe01ef,
  0xf0000, 0xffffd,
  0x100000, 0x10fffd
}; /* CR_Graph */

/* 'Lower': [[:Lower:]] */
static const OnigCodePoint CR_Lower[] = {
  480,
  0x0061, 0x007a,
  0x00aa, 0x00aa,
  0x00b5, 0x00b5,
  0x00ba, 0x00ba,
  0x00df, 0x00f6,
  0x00f8, 0x00ff,
  0x0101, 0x0101,
  0x0103, 0x0103,
  0x0105, 0x0105,
  0x0107, 0x0107,
  0x0109, 0x0109,
  0x010b, 0x010b,
  0x010d, 0x010d,
  0x010f, 0x010f,
  0x0111, 0x0111,
  0x0113, 0x0113,
  0x0115, 0x0115,
  0x0117, 0x0117,
  0x0119, 0x0119,
  0x011b, 0x011b,
  0x011d, 0x011d,
  0x011f, 0x011f,
  0x0121, 0x0121,
  0x0123, 0x0123,
  0x0125, 0x0125,
  0x0127, 0x0127,
  0x0129, 0x0129,
  0x012b, 0x012b,
  0x012d, 0x012d,
  0x012f, 0x012f,
  0x0131, 0x0131,
  0x0133, 0x0133,
  0x0135, 0x0135,
  0x0137, 0x0138,
  0x013a, 0x013a,
  0x013c, 0x013c,
  0x013e, 0x013e,
  0x0140, 0x0140,
  0x0142, 0x0142,
  0x0144, 0x0144,
  0x0146, 0x0146,
  0x0148, 0x0149,
  0x014b, 0x014b,
  0x014d, 0x014d,
  0x014f, 0x014f,
  0x0151, 0x0151,
  0x0153, 0x0153,
  0x0155, 0x0155,
  0x0157, 0x0157,
  0x0159, 0x0159,
  0x015b, 0x015b,
  0x015d, 0x015d,
  0x015f, 0x015f,
  0x0161, 0x0161,
  0x0163, 0x0163,
  0x0165, 0x0165,
  0x0167, 0x0167,
  0x0169, 0x0169,
  0x016b, 0x016b,
  0x016d, 0x016d,
  0x016f, 0x016f,
  0x0171, 0x0171,
  0x0173, 0x0173,
  0x0175, 0x0175,
  0x0177, 0x0177,
  0x017a, 0x017a,
  0x017c, 0x017c,
  0x017e, 0x0180,
  0x0183, 0x0183,
  0x0185, 0x0185,
  0x0188, 0x0188,
  0x018c, 0x018d,
  0x0192, 0x0192,
  0x0195, 0x0195,
  0x0199, 0x019b,
  0x019e, 0x019e,
  0x01a1, 0x01a1,
  0x01a3, 0x01a3,
  0x01a5, 0x01a5,
  0x01a8, 0x01a8,
  0x01aa, 0x01ab,
  0x01ad, 0x01ad,
  0x01b0, 0x01b0,
  0x01b4, 0x01b4,
  0x01b6, 0x01b6,
  0x01b9, 0x01ba,
  0x01bd, 0x01bf,
  0x01c6, 0x01c6,
  0x01c9, 0x01c9,
  0x01cc, 0x01cc,
  0x01ce, 0x01ce,
  0x01d0, 0x01d0,
  0x01d2, 0x01d2,
  0x01d4, 0x01d4,
  0x01d6, 0x01d6,
  0x01d8, 0x01d8,
  0x01da, 0x01da,
  0x01dc, 0x01dd,
  0x01df, 0x01df,
  0x01e1, 0x01e1,
  0x01e3, 0x01e3,
  0x01e5, 0x01e5,
  0x01e7, 0x01e7,
  0x01e9, 0x01e9,
  0x01eb, 0x01eb,
  0x01ed, 0x01ed,
  0x01ef, 0x01f0,
  0x01f3, 0x01f3,
  0x01f5, 0x01f5,
  0x01f9, 0x01f9,
  0x01fb, 0x01fb,
  0x01fd, 0x01fd,
  0x01ff, 0x01ff,
  0x0201, 0x0201,
  0x0203, 0x0203,
  0x0205, 0x0205,
  0x0207, 0x0207,
  0x0209, 0x0209,
  0x020b, 0x020b,
  0x020d, 0x020d,
  0x020f, 0x020f,
  0x0211, 0x0211,
  0x0213, 0x0213,
  0x0215, 0x0215,
  0x0217, 0x0217,
  0x0219, 0x0219,
  0x021b, 0x021b,
  0x021d, 0x021d,
  0x021f, 0x021f,
  0x0221, 0x0221,
  0x0223, 0x0223,
  0x0225, 0x0225,
  0x0227, 0x0227,
  0x0229, 0x0229,
  0x022b, 0x022b,
  0x022d, 0x022d,
  0x022f, 0x022f,
  0x0231, 0x0231,
  0x0233, 0x0239,
  0x023c, 0x023c,
  0x023f, 0x0240,
  0x0250, 0x02af,
  0x0390, 0x0390,
  0x03ac, 0x03ce,
  0x03d0, 0x03d1,
  0x03d5, 0x03d7,
  0x03d9, 0x03d9,
  0x03db, 0x03db,
  0x03dd, 0x03dd,
  0x03df, 0x03df,
  0x03e1, 0x03e1,
  0x03e3, 0x03e3,
  0x03e5, 0x03e5,
  0x03e7, 0x03e7,
  0x03e9, 0x03e9,
  0x03eb, 0x03eb,
  0x03ed, 0x03ed,
  0x03ef, 0x03f3,
  0x03f5, 0x03f5,
  0x03f8, 0x03f8,
  0x03fb, 0x03fc,
  0x0430, 0x045f,
  0x0461, 0x0461,
  0x0463, 0x0463,
  0x0465, 0x0465,
  0x0467, 0x0467,
  0x0469, 0x0469,
  0x046b, 0x046b,
  0x046d, 0x046d,
  0x046f, 0x046f,
  0x0471, 0x0471,
  0x0473, 0x0473,
  0x0475, 0x0475,
  0x0477, 0x0477,
  0x0479, 0x0479,
  0x047b, 0x047b,
  0x047d, 0x047d,
  0x047f, 0x047f,
  0x0481, 0x0481,
  0x048b, 0x048b,
  0x048d, 0x048d,
  0x048f, 0x048f,
  0x0491, 0x0491,
  0x0493, 0x0493,
  0x0495, 0x0495,
  0x0497, 0x0497,
  0x0499, 0x0499,
  0x049b, 0x049b,
  0x049d, 0x049d,
  0x049f, 0x049f,
  0x04a1, 0x04a1,
  0x04a3, 0x04a3,
  0x04a5, 0x04a5,
  0x04a7, 0x04a7,
  0x04a9, 0x04a9,
  0x04ab, 0x04ab,
  0x04ad, 0x04ad,
  0x04af, 0x04af,
  0x04b1, 0x04b1,
  0x04b3, 0x04b3,
  0x04b5, 0x04b5,
  0x04b7, 0x04b7,
  0x04b9, 0x04b9,
  0x04bb, 0x04bb,
  0x04bd, 0x04bd,
  0x04bf, 0x04bf,
  0x04c2, 0x04c2,
  0x04c4, 0x04c4,
  0x04c6, 0x04c6,
  0x04c8, 0x04c8,
  0x04ca, 0x04ca,
  0x04cc, 0x04cc,
  0x04ce, 0x04ce,
  0x04d1, 0x04d1,
  0x04d3, 0x04d3,
  0x04d5, 0x04d5,
  0x04d7, 0x04d7,
  0x04d9, 0x04d9,
  0x04db, 0x04db,
  0x04dd, 0x04dd,
  0x04df, 0x04df,
  0x04e1, 0x04e1,
  0x04e3, 0x04e3,
  0x04e5, 0x04e5,
  0x04e7, 0x04e7,
  0x04e9, 0x04e9,
  0x04eb, 0x04eb,
  0x04ed, 0x04ed,
  0x04ef, 0x04ef,
  0x04f1, 0x04f1,
  0x04f3, 0x04f3,
  0x04f5, 0x04f5,
  0x04f7, 0x04f7,
  0x04f9, 0x04f9,
  0x0501, 0x0501,
  0x0503, 0x0503,
  0x0505, 0x0505,
  0x0507, 0x0507,
  0x0509, 0x0509,
  0x050b, 0x050b,
  0x050d, 0x050d,
  0x050f, 0x050f,
  0x0561, 0x0587,
  0x1d00, 0x1d2b,
  0x1d62, 0x1d77,
  0x1d79, 0x1d9a,
  0x1e01, 0x1e01,
  0x1e03, 0x1e03,
  0x1e05, 0x1e05,
  0x1e07, 0x1e07,
  0x1e09, 0x1e09,
  0x1e0b, 0x1e0b,
  0x1e0d, 0x1e0d,
  0x1e0f, 0x1e0f,
  0x1e11, 0x1e11,
  0x1e13, 0x1e13,
  0x1e15, 0x1e15,
  0x1e17, 0x1e17,
  0x1e19, 0x1e19,
  0x1e1b, 0x1e1b,
  0x1e1d, 0x1e1d,
  0x1e1f, 0x1e1f,
  0x1e21, 0x1e21,
  0x1e23, 0x1e23,
  0x1e25, 0x1e25,
  0x1e27, 0x1e27,
  0x1e29, 0x1e29,
  0x1e2b, 0x1e2b,
  0x1e2d, 0x1e2d,
  0x1e2f, 0x1e2f,
  0x1e31, 0x1e31,
  0x1e33, 0x1e33,
  0x1e35, 0x1e35,
  0x1e37, 0x1e37,
  0x1e39, 0x1e39,
  0x1e3b, 0x1e3b,
  0x1e3d, 0x1e3d,
  0x1e3f, 0x1e3f,
  0x1e41, 0x1e41,
  0x1e43, 0x1e43,
  0x1e45, 0x1e45,
  0x1e47, 0x1e47,
  0x1e49, 0x1e49,
  0x1e4b, 0x1e4b,
  0x1e4d, 0x1e4d,
  0x1e4f, 0x1e4f,
  0x1e51, 0x1e51,
  0x1e53, 0x1e53,
  0x1e55, 0x1e55,
  0x1e57, 0x1e57,
  0x1e59, 0x1e59,
  0x1e5b, 0x1e5b,
  0x1e5d, 0x1e5d,
  0x1e5f, 0x1e5f,
  0x1e61, 0x1e61,
  0x1e63, 0x1e63,
  0x1e65, 0x1e65,
  0x1e67, 0x1e67,
  0x1e69, 0x1e69,
  0x1e6b, 0x1e6b,
  0x1e6d, 0x1e6d,
  0x1e6f, 0x1e6f,
  0x1e71, 0x1e71,
  0x1e73, 0x1e73,
  0x1e75, 0x1e75,
  0x1e77, 0x1e77,
  0x1e79, 0x1e79,
  0x1e7b, 0x1e7b,
  0x1e7d, 0x1e7d,
  0x1e7f, 0x1e7f,
  0x1e81, 0x1e81,
  0x1e83, 0x1e83,
  0x1e85, 0x1e85,
  0x1e87, 0x1e87,
  0x1e89, 0x1e89,
  0x1e8b, 0x1e8b,
  0x1e8d, 0x1e8d,
  0x1e8f, 0x1e8f,
  0x1e91, 0x1e91,
  0x1e93, 0x1e93,
  0x1e95, 0x1e9b,
  0x1ea1, 0x1ea1,
  0x1ea3, 0x1ea3,
  0x1ea5, 0x1ea5,
  0x1ea7, 0x1ea7,
  0x1ea9, 0x1ea9,
  0x1eab, 0x1eab,
  0x1ead, 0x1ead,
  0x1eaf, 0x1eaf,
  0x1eb1, 0x1eb1,
  0x1eb3, 0x1eb3,
  0x1eb5, 0x1eb5,
  0x1eb7, 0x1eb7,
  0x1eb9, 0x1eb9,
  0x1ebb, 0x1ebb,
  0x1ebd, 0x1ebd,
  0x1ebf, 0x1ebf,
  0x1ec1, 0x1ec1,
  0x1ec3, 0x1ec3,
  0x1ec5, 0x1ec5,
  0x1ec7, 0x1ec7,
  0x1ec9, 0x1ec9,
  0x1ecb, 0x1ecb,
  0x1ecd, 0x1ecd,
  0x1ecf, 0x1ecf,
  0x1ed1, 0x1ed1,
  0x1ed3, 0x1ed3,
  0x1ed5, 0x1ed5,
  0x1ed7, 0x1ed7,
  0x1ed9, 0x1ed9,
  0x1edb, 0x1edb,
  0x1edd, 0x1edd,
  0x1edf, 0x1edf,
  0x1ee1, 0x1ee1,
  0x1ee3, 0x1ee3,
  0x1ee5, 0x1ee5,
  0x1ee7, 0x1ee7,
  0x1ee9, 0x1ee9,
  0x1eeb, 0x1eeb,
  0x1eed, 0x1eed,
  0x1eef, 0x1eef,
  0x1ef1, 0x1ef1,
  0x1ef3, 0x1ef3,
  0x1ef5, 0x1ef5,
  0x1ef7, 0x1ef7,
  0x1ef9, 0x1ef9,
  0x1f00, 0x1f07,
  0x1f10, 0x1f15,
  0x1f20, 0x1f27,
  0x1f30, 0x1f37,
  0x1f40, 0x1f45,
  0x1f50, 0x1f57,
  0x1f60, 0x1f67,
  0x1f70, 0x1f7d,
  0x1f80, 0x1f87,
  0x1f90, 0x1f97,
  0x1fa0, 0x1fa7,
  0x1fb0, 0x1fb4,
  0x1fb6, 0x1fb7,
  0x1fbe, 0x1fbe,
  0x1fc2, 0x1fc4,
  0x1fc6, 0x1fc7,
  0x1fd0, 0x1fd3,
  0x1fd6, 0x1fd7,
  0x1fe0, 0x1fe7,
  0x1ff2, 0x1ff4,
  0x1ff6, 0x1ff7,
  0x2071, 0x2071,
  0x207f, 0x207f,
  0x210a, 0x210a,
  0x210e, 0x210f,
  0x2113, 0x2113,
  0x212f, 0x212f,
  0x2134, 0x2134,
  0x2139, 0x2139,
  0x213c, 0x213d,
  0x2146, 0x2149,
  0x2c30, 0x2c5e,
  0x2c81, 0x2c81,
  0x2c83, 0x2c83,
  0x2c85, 0x2c85,
  0x2c87, 0x2c87,
  0x2c89, 0x2c89,
  0x2c8b, 0x2c8b,
  0x2c8d, 0x2c8d,
  0x2c8f, 0x2c8f,
  0x2c91, 0x2c91,
  0x2c93, 0x2c93,
  0x2c95, 0x2c95,
  0x2c97, 0x2c97,
  0x2c99, 0x2c99,
  0x2c9b, 0x2c9b,
  0x2c9d, 0x2c9d,
  0x2c9f, 0x2c9f,
  0x2ca1, 0x2ca1,
  0x2ca3, 0x2ca3,
  0x2ca5, 0x2ca5,
  0x2ca7, 0x2ca7,
  0x2ca9, 0x2ca9,
  0x2cab, 0x2cab,
  0x2cad, 0x2cad,
  0x2caf, 0x2caf,
  0x2cb1, 0x2cb1,
  0x2cb3, 0x2cb3,
  0x2cb5, 0x2cb5,
  0x2cb7, 0x2cb7,
  0x2cb9, 0x2cb9,
  0x2cbb, 0x2cbb,
  0x2cbd, 0x2cbd,
  0x2cbf, 0x2cbf,
  0x2cc1, 0x2cc1,
  0x2cc3, 0x2cc3,
  0x2cc5, 0x2cc5,
  0x2cc7, 0x2cc7,
  0x2cc9, 0x2cc9,
  0x2ccb, 0x2ccb,
  0x2ccd, 0x2ccd,
  0x2ccf, 0x2ccf,
  0x2cd1, 0x2cd1,
  0x2cd3, 0x2cd3,
  0x2cd5, 0x2cd5,
  0x2cd7, 0x2cd7,
  0x2cd9, 0x2cd9,
  0x2cdb, 0x2cdb,
  0x2cdd, 0x2cdd,
  0x2cdf, 0x2cdf,
  0x2ce1, 0x2ce1,
  0x2ce3, 0x2ce4,
  0x2d00, 0x2d25,
  0xfb00, 0xfb06,
  0xfb13, 0xfb17,
  0xff41, 0xff5a,
  0x10428, 0x1044f,
  0x1d41a, 0x1d433,
  0x1d44e, 0x1d454,
  0x1d456, 0x1d467,
  0x1d482, 0x1d49b,
  0x1d4b6, 0x1d4b9,
  0x1d4bb, 0x1d4bb,
  0x1d4bd, 0x1d4c3,
  0x1d4c5, 0x1d4cf,
  0x1d4ea, 0x1d503,
  0x1d51e, 0x1d537,
  0x1d552, 0x1d56b,
  0x1d586, 0x1d59f,
  0x1d5ba, 0x1d5d3,
  0x1d5ee, 0x1d607,
  0x1d622, 0x1d63b,
  0x1d656, 0x1d66f,
  0x1d68a, 0x1d6a5,
  0x1d6c2, 0x1d6da,
  0x1d6dc, 0x1d6e1,
  0x1d6fc, 0x1d714,
  0x1d716, 0x1d71b,
  0x1d736, 0x1d74e,
  0x1d750, 0x1d755,
  0x1d770, 0x1d788,
  0x1d78a, 0x1d78f,
  0x1d7aa, 0x1d7c2,
  0x1d7c4, 0x1d7c9
}; /* CR_Lower */

/* 'Print': [[:Print:]] */
static const OnigCodePoint CR_Print[] = {
  423,
  0x0009, 0x000d,
  0x0020, 0x007e,
  0x0085, 0x0085,
  0x00a0, 0x0241,
  0x0250, 0x036f,
  0x0374, 0x0375,
  0x037a, 0x037a,
  0x037e, 0x037e,
  0x0384, 0x038a,
  0x038c, 0x038c,
  0x038e, 0x03a1,
  0x03a3, 0x03ce,
  0x03d0, 0x0486,
  0x0488, 0x04ce,
  0x04d0, 0x04f9,
  0x0500, 0x050f,
  0x0531, 0x0556,
  0x0559, 0x055f,
  0x0561, 0x0587,
  0x0589, 0x058a,
  0x0591, 0x05b9,
  0x05bb, 0x05c7,
  0x05d0, 0x05ea,
  0x05f0, 0x05f4,
  0x0600, 0x0603,
  0x060b, 0x0615,
  0x061b, 0x061b,
  0x061e, 0x061f,
  0x0621, 0x063a,
  0x0640, 0x065e,
  0x0660, 0x070d,
  0x070f, 0x074a,
  0x074d, 0x076d,
  0x0780, 0x07b1,
  0x0901, 0x0939,
  0x093c, 0x094d,
  0x0950, 0x0954,
  0x0958, 0x0970,
  0x097d, 0x097d,
  0x0981, 0x0983,
  0x0985, 0x098c,
  0x098f, 0x0990,
  0x0993, 0x09a8,
  0x09aa, 0x09b0,
  0x09b2, 0x09b2,
  0x09b6, 0x09b9,
  0x09bc, 0x09c4,
  0x09c7, 0x09c8,
  0x09cb, 0x09ce,
  0x09d7, 0x09d7,
  0x09dc, 0x09dd,
  0x09df, 0x09e3,
  0x09e6, 0x09fa,
  0x0a01, 0x0a03,
  0x0a05, 0x0a0a,
  0x0a0f, 0x0a10,
  0x0a13, 0x0a28,
  0x0a2a, 0x0a30,
  0x0a32, 0x0a33,
  0x0a35, 0x0a36,
  0x0a38, 0x0a39,
  0x0a3c, 0x0a3c,
  0x0a3e, 0x0a42,
  0x0a47, 0x0a48,
  0x0a4b, 0x0a4d,
  0x0a59, 0x0a5c,
  0x0a5e, 0x0a5e,
  0x0a66, 0x0a74,
  0x0a81, 0x0a83,
  0x0a85, 0x0a8d,
  0x0a8f, 0x0a91,
  0x0a93, 0x0aa8,
  0x0aaa, 0x0ab0,
  0x0ab2, 0x0ab3,
  0x0ab5, 0x0ab9,
  0x0abc, 0x0ac5,
  0x0ac7, 0x0ac9,
  0x0acb, 0x0acd,
  0x0ad0, 0x0ad0,
  0x0ae0, 0x0ae3,
  0x0ae6, 0x0aef,
  0x0af1, 0x0af1,
  0x0b01, 0x0b03,
  0x0b05, 0x0b0c,
  0x0b0f, 0x0b10,
  0x0b13, 0x0b28,
  0x0b2a, 0x0b30,
  0x0b32, 0x0b33,
  0x0b35, 0x0b39,
  0x0b3c, 0x0b43,
  0x0b47, 0x0b48,
  0x0b4b, 0x0b4d,
  0x0b56, 0x0b57,
  0x0b5c, 0x0b5d,
  0x0b5f, 0x0b61,
  0x0b66, 0x0b71,
  0x0b82, 0x0b83,
  0x0b85, 0x0b8a,
  0x0b8e, 0x0b90,
  0x0b92, 0x0b95,
  0x0b99, 0x0b9a,
  0x0b9c, 0x0b9c,
  0x0b9e, 0x0b9f,
  0x0ba3, 0x0ba4,
  0x0ba8, 0x0baa,
  0x0bae, 0x0bb9,
  0x0bbe, 0x0bc2,
  0x0bc6, 0x0bc8,
  0x0bca, 0x0bcd,
  0x0bd7, 0x0bd7,
  0x0be6, 0x0bfa,
  0x0c01, 0x0c03,
  0x0c05, 0x0c0c,
  0x0c0e, 0x0c10,
  0x0c12, 0x0c28,
  0x0c2a, 0x0c33,
  0x0c35, 0x0c39,
  0x0c3e, 0x0c44,
  0x0c46, 0x0c48,
  0x0c4a, 0x0c4d,
  0x0c55, 0x0c56,
  0x0c60, 0x0c61,
  0x0c66, 0x0c6f,
  0x0c82, 0x0c83,
  0x0c85, 0x0c8c,
  0x0c8e, 0x0c90,
  0x0c92, 0x0ca8,
  0x0caa, 0x0cb3,
  0x0cb5, 0x0cb9,
  0x0cbc, 0x0cc4,
  0x0cc6, 0x0cc8,
  0x0cca, 0x0ccd,
  0x0cd5, 0x0cd6,
  0x0cde, 0x0cde,
  0x0ce0, 0x0ce1,
  0x0ce6, 0x0cef,
  0x0d02, 0x0d03,
  0x0d05, 0x0d0c,
  0x0d0e, 0x0d10,
  0x0d12, 0x0d28,
  0x0d2a, 0x0d39,
  0x0d3e, 0x0d43,
  0x0d46, 0x0d48,
  0x0d4a, 0x0d4d,
  0x0d57, 0x0d57,
  0x0d60, 0x0d61,
  0x0d66, 0x0d6f,
  0x0d82, 0x0d83,
  0x0d85, 0x0d96,
  0x0d9a, 0x0db1,
  0x0db3, 0x0dbb,
  0x0dbd, 0x0dbd,
  0x0dc0, 0x0dc6,
  0x0dca, 0x0dca,
  0x0dcf, 0x0dd4,
  0x0dd6, 0x0dd6,
  0x0dd8, 0x0ddf,
  0x0df2, 0x0df4,
  0x0e01, 0x0e3a,
  0x0e3f, 0x0e5b,
  0x0e81, 0x0e82,
  0x0e84, 0x0e84,
  0x0e87, 0x0e88,
  0x0e8a, 0x0e8a,
  0x0e8d, 0x0e8d,
  0x0e94, 0x0e97,
  0x0e99, 0x0e9f,
  0x0ea1, 0x0ea3,
  0x0ea5, 0x0ea5,
  0x0ea7, 0x0ea7,
  0x0eaa, 0x0eab,
  0x0ead, 0x0eb9,
  0x0ebb, 0x0ebd,
  0x0ec0, 0x0ec4,
  0x0ec6, 0x0ec6,
  0x0ec8, 0x0ecd,
  0x0ed0, 0x0ed9,
  0x0edc, 0x0edd,
  0x0f00, 0x0f47,
  0x0f49, 0x0f6a,
  0x0f71, 0x0f8b,
  0x0f90, 0x0f97,
  0x0f99, 0x0fbc,
  0x0fbe, 0x0fcc,
  0x0fcf, 0x0fd1,
  0x1000, 0x1021,
  0x1023, 0x1027,
  0x1029, 0x102a,
  0x102c, 0x1032,
  0x1036, 0x1039,
  0x1040, 0x1059,
  0x10a0, 0x10c5,
  0x10d0, 0x10fc,
  0x1100, 0x1159,
  0x115f, 0x11a2,
  0x11a8, 0x11f9,
  0x1200, 0x1248,
  0x124a, 0x124d,
  0x1250, 0x1256,
  0x1258, 0x1258,
  0x125a, 0x125d,
  0x1260, 0x1288,
  0x128a, 0x128d,
  0x1290, 0x12b0,
  0x12b2, 0x12b5,
  0x12b8, 0x12be,
  0x12c0, 0x12c0,
  0x12c2, 0x12c5,
  0x12c8, 0x12d6,
  0x12d8, 0x1310,
  0x1312, 0x1315,
  0x1318, 0x135a,
  0x135f, 0x137c,
  0x1380, 0x1399,
  0x13a0, 0x13f4,
  0x1401, 0x1676,
  0x1680, 0x169c,
  0x16a0, 0x16f0,
  0x1700, 0x170c,
  0x170e, 0x1714,
  0x1720, 0x1736,
  0x1740, 0x1753,
  0x1760, 0x176c,
  0x176e, 0x1770,
  0x1772, 0x1773,
  0x1780, 0x17dd,
  0x17e0, 0x17e9,
  0x17f0, 0x17f9,
  0x1800, 0x180e,
  0x1810, 0x1819,
  0x1820, 0x1877,
  0x1880, 0x18a9,
  0x1900, 0x191c,
  0x1920, 0x192b,
  0x1930, 0x193b,
  0x1940, 0x1940,
  0x1944, 0x196d,
  0x1970, 0x1974,
  0x1980, 0x19a9,
  0x19b0, 0x19c9,
  0x19d0, 0x19d9,
  0x19de, 0x1a1b,
  0x1a1e, 0x1a1f,
  0x1d00, 0x1dc3,
  0x1e00, 0x1e9b,
  0x1ea0, 0x1ef9,
  0x1f00, 0x1f15,
  0x1f18, 0x1f1d,
  0x1f20, 0x1f45,
  0x1f48, 0x1f4d,
  0x1f50, 0x1f57,
  0x1f59, 0x1f59,
  0x1f5b, 0x1f5b,
  0x1f5d, 0x1f5d,
  0x1f5f, 0x1f7d,
  0x1f80, 0x1fb4,
  0x1fb6, 0x1fc4,
  0x1fc6, 0x1fd3,
  0x1fd6, 0x1fdb,
  0x1fdd, 0x1fef,
  0x1ff2, 0x1ff4,
  0x1ff6, 0x1ffe,
  0x2000, 0x2063,
  0x206a, 0x2071,
  0x2074, 0x208e,
  0x2090, 0x2094,
  0x20a0, 0x20b5,
  0x20d0, 0x20eb,
  0x2100, 0x214c,
  0x2153, 0x2183,
  0x2190, 0x23db,
  0x2400, 0x2426,
  0x2440, 0x244a,
  0x2460, 0x269c,
  0x26a0, 0x26b1,
  0x2701, 0x2704,
  0x2706, 0x2709,
  0x270c, 0x2727,
  0x2729, 0x274b,
  0x274d, 0x274d,
  0x274f, 0x2752,
  0x2756, 0x2756,
  0x2758, 0x275e,
  0x2761, 0x2794,
  0x2798, 0x27af,
  0x27b1, 0x27be,
  0x27c0, 0x27c6,
  0x27d0, 0x27eb,
  0x27f0, 0x2b13,
  0x2c00, 0x2c2e,
  0x2c30, 0x2c5e,
  0x2c80, 0x2cea,
  0x2cf9, 0x2d25,
  0x2d30, 0x2d65,
  0x2d6f, 0x2d6f,
  0x2d80, 0x2d96,
  0x2da0, 0x2da6,
  0x2da8, 0x2dae,
  0x2db0, 0x2db6,
  0x2db8, 0x2dbe,
  0x2dc0, 0x2dc6,
  0x2dc8, 0x2dce,
  0x2dd0, 0x2dd6,
  0x2dd8, 0x2dde,
  0x2e00, 0x2e17,
  0x2e1c, 0x2e1d,
  0x2e80, 0x2e99,
  0x2e9b, 0x2ef3,
  0x2f00, 0x2fd5,
  0x2ff0, 0x2ffb,
  0x3000, 0x303f,
  0x3041, 0x3096,
  0x3099, 0x30ff,
  0x3105, 0x312c,
  0x3131, 0x318e,
  0x3190, 0x31b7,
  0x31c0, 0x31cf,
  0x31f0, 0x321e,
  0x3220, 0x3243,
  0x3250, 0x32fe,
  0x3300, 0x4db5,
  0x4dc0, 0x9fbb,
  0xa000, 0xa48c,
  0xa490, 0xa4c6,
  0xa700, 0xa716,
  0xa800, 0xa82b,
  0xac00, 0xd7a3,
  0xe000, 0xfa2d,
  0xfa30, 0xfa6a,
  0xfa70, 0xfad9,
  0xfb00, 0xfb06,
  0xfb13, 0xfb17,
  0xfb1d, 0xfb36,
  0xfb38, 0xfb3c,
  0xfb3e, 0xfb3e,
  0xfb40, 0xfb41,
  0xfb43, 0xfb44,
  0xfb46, 0xfbb1,
  0xfbd3, 0xfd3f,
  0xfd50, 0xfd8f,
  0xfd92, 0xfdc7,
  0xfdf0, 0xfdfd,
  0xfe00, 0xfe19,
  0xfe20, 0xfe23,
  0xfe30, 0xfe52,
  0xfe54, 0xfe66,
  0xfe68, 0xfe6b,
  0xfe70, 0xfe74,
  0xfe76, 0xfefc,
  0xfeff, 0xfeff,
  0xff01, 0xffbe,
  0xffc2, 0xffc7,
  0xffca, 0xffcf,
  0xffd2, 0xffd7,
  0xffda, 0xffdc,
  0xffe0, 0xffe6,
  0xffe8, 0xffee,
  0xfff9, 0xfffd,
  0x10000, 0x1000b,
  0x1000d, 0x10026,
  0x10028, 0x1003a,
  0x1003c, 0x1003d,
  0x1003f, 0x1004d,
  0x10050, 0x1005d,
  0x10080, 0x100fa,
  0x10100, 0x10102,
  0x10107, 0x10133,
  0x10137, 0x1018a,
  0x10300, 0x1031e,
  0x10320, 0x10323,
  0x10330, 0x1034a,
  0x10380, 0x1039d,
  0x1039f, 0x103c3,
  0x103c8, 0x103d5,
  0x10400, 0x1049d,
  0x104a0, 0x104a9,
  0x10800, 0x10805,
  0x10808, 0x10808,
  0x1080a, 0x10835,
  0x10837, 0x10838,
  0x1083c, 0x1083c,
  0x1083f, 0x1083f,
  0x10a00, 0x10a03,
  0x10a05, 0x10a06,
  0x10a0c, 0x10a13,
  0x10a15, 0x10a17,
  0x10a19, 0x10a33,
  0x10a38, 0x10a3a,
  0x10a3f, 0x10a47,
  0x10a50, 0x10a58,
  0x1d000, 0x1d0f5,
  0x1d100, 0x1d126,
  0x1d12a, 0x1d1dd,
  0x1d200, 0x1d245,
  0x1d300, 0x1d356,
  0x1d400, 0x1d454,
  0x1d456, 0x1d49c,
  0x1d49e, 0x1d49f,
  0x1d4a2, 0x1d4a2,
  0x1d4a5, 0x1d4a6,
  0x1d4a9, 0x1d4ac,
  0x1d4ae, 0x1d4b9,
  0x1d4bb, 0x1d4bb,
  0x1d4bd, 0x1d4c3,
  0x1d4c5, 0x1d505,
  0x1d507, 0x1d50a,
  0x1d50d, 0x1d514,
  0x1d516, 0x1d51c,
  0x1d51e, 0x1d539,
  0x1d53b, 0x1d53e,
  0x1d540, 0x1d544,
  0x1d546, 0x1d546,
  0x1d54a, 0x1d550,
  0x1d552, 0x1d6a5,
  0x1d6a8, 0x1d7c9,
  0x1d7ce, 0x1d7ff,
  0x20000, 0x2a6d6,
  0x2f800, 0x2fa1d,
  0xe0001, 0xe0001,
  0xe0020, 0xe007f,
  0xe0100, 0xe01ef,
  0xf0000, 0xffffd,
  0x100000, 0x10fffd
}; /* CR_Print */

/* 'Punct': [[:Punct:]] */
static const OnigCodePoint CR_Punct[] = {
  96,
  0x0021, 0x0023,
  0x0025, 0x002a,
  0x002c, 0x002f,
  0x003a, 0x003b,
  0x003f, 0x0040,
  0x005b, 0x005d,
  0x005f, 0x005f,
  0x007b, 0x007b,
  0x007d, 0x007d,
  0x00a1, 0x00a1,
  0x00ab, 0x00ab,
  0x00b7, 0x00b7,
  0x00bb, 0x00bb,
  0x00bf, 0x00bf,
  0x037e, 0x037e,
  0x0387, 0x0387,
  0x055a, 0x055f,
  0x0589, 0x058a,
  0x05be, 0x05be,
  0x05c0, 0x05c0,
  0x05c3, 0x05c3,
  0x05c6, 0x05c6,
  0x05f3, 0x05f4,
  0x060c, 0x060d,
  0x061b, 0x061b,
  0x061e, 0x061f,
  0x066a, 0x066d,
  0x06d4, 0x06d4,
  0x0700, 0x070d,
  0x0964, 0x0965,
  0x0970, 0x0970,
  0x0df4, 0x0df4,
  0x0e4f, 0x0e4f,
  0x0e5a, 0x0e5b,
  0x0f04, 0x0f12,
  0x0f3a, 0x0f3d,
  0x0f85, 0x0f85,
  0x0fd0, 0x0fd1,
  0x104a, 0x104f,
  0x10fb, 0x10fb,
  0x1361, 0x1368,
  0x166d, 0x166e,
  0x169b, 0x169c,
  0x16eb, 0x16ed,
  0x1735, 0x1736,
  0x17d4, 0x17d6,
  0x17d8, 0x17da,
  0x1800, 0x180a,
  0x1944, 0x1945,
  0x19de, 0x19df,
  0x1a1e, 0x1a1f,
  0x2010, 0x2027,
  0x2030, 0x2043,
  0x2045, 0x2051,
  0x2053, 0x205e,
  0x207d, 0x207e,
  0x208d, 0x208e,
  0x2329, 0x232a,
  0x23b4, 0x23b6,
  0x2768, 0x2775,
  0x27c5, 0x27c6,
  0x27e6, 0x27eb,
  0x2983, 0x2998,
  0x29d8, 0x29db,
  0x29fc, 0x29fd,
  0x2cf9, 0x2cfc,
  0x2cfe, 0x2cff,
  0x2e00, 0x2e17,
  0x2e1c, 0x2e1d,
  0x3001, 0x3003,
  0x3008, 0x3011,
  0x3014, 0x301f,
  0x3030, 0x3030,
  0x303d, 0x303d,
  0x30a0, 0x30a0,
  0x30fb, 0x30fb,
  0xfd3e, 0xfd3f,
  0xfe10, 0xfe19,
  0xfe30, 0xfe52,
  0xfe54, 0xfe61,
  0xfe63, 0xfe63,
  0xfe68, 0xfe68,
  0xfe6a, 0xfe6b,
  0xff01, 0xff03,
  0xff05, 0xff0a,
  0xff0c, 0xff0f,
  0xff1a, 0xff1b,
  0xff1f, 0xff20,
  0xff3b, 0xff3d,
  0xff3f, 0xff3f,
  0xff5b, 0xff5b,
  0xff5d, 0xff5d,
  0xff5f, 0xff65,
  0x10100, 0x10101,
  0x1039f, 0x1039f,
  0x10a50, 0x10a58
}; /* CR_Punct */

/* 'Space': [[:Space:]] */
static const OnigCodePoint CR_Space[] = {
  11,
  0x0009, 0x000d,
  0x0020, 0x0020,
  0x0085, 0x0085,
  0x00a0, 0x00a0,
  0x1680, 0x1680,
  0x180e, 0x180e,
  0x2000, 0x200a,
  0x2028, 0x2029,
  0x202f, 0x202f,
  0x205f, 0x205f,
  0x3000, 0x3000
}; /* CR_Space */

/* 'Upper': [[:Upper:]] */
static const OnigCodePoint CR_Upper[] = {
  476,
  0x0041, 0x005a,
  0x00c0, 0x00d6,
  0x00d8, 0x00de,
  0x0100, 0x0100,
  0x0102, 0x0102,
  0x0104, 0x0104,
  0x0106, 0x0106,
  0x0108, 0x0108,
  0x010a, 0x010a,
  0x010c, 0x010c,
  0x010e, 0x010e,
  0x0110, 0x0110,
  0x0112, 0x0112,
  0x0114, 0x0114,
  0x0116, 0x0116,
  0x0118, 0x0118,
  0x011a, 0x011a,
  0x011c, 0x011c,
  0x011e, 0x011e,
  0x0120, 0x0120,
  0x0122, 0x0122,
  0x0124, 0x0124,
  0x0126, 0x0126,
  0x0128, 0x0128,
  0x012a, 0x012a,
  0x012c, 0x012c,
  0x012e, 0x012e,
  0x0130, 0x0130,
  0x0132, 0x0132,
  0x0134, 0x0134,
  0x0136, 0x0136,
  0x0139, 0x0139,
  0x013b, 0x013b,
  0x013d, 0x013d,
  0x013f, 0x013f,
  0x0141, 0x0141,
  0x0143, 0x0143,
  0x0145, 0x0145,
  0x0147, 0x0147,
  0x014a, 0x014a,
  0x014c, 0x014c,
  0x014e, 0x014e,
  0x0150, 0x0150,
  0x0152, 0x0152,
  0x0154, 0x0154,
  0x0156, 0x0156,
  0x0158, 0x0158,
  0x015a, 0x015a,
  0x015c, 0x015c,
  0x015e, 0x015e,
  0x0160, 0x0160,
  0x0162, 0x0162,
  0x0164, 0x0164,
  0x0166, 0x0166,
  0x0168, 0x0168,
  0x016a, 0x016a,
  0x016c, 0x016c,
  0x016e, 0x016e,
  0x0170, 0x0170,
  0x0172, 0x0172,
  0x0174, 0x0174,
  0x0176, 0x0176,
  0x0178, 0x0179,
  0x017b, 0x017b,
  0x017d, 0x017d,
  0x0181, 0x0182,
  0x0184, 0x0184,
  0x0186, 0x0187,
  0x0189, 0x018b,
  0x018e, 0x0191,
  0x0193, 0x0194,
  0x0196, 0x0198,
  0x019c, 0x019d,
  0x019f, 0x01a0,
  0x01a2, 0x01a2,
  0x01a4, 0x01a4,
  0x01a6, 0x01a7,
  0x01a9, 0x01a9,
  0x01ac, 0x01ac,
  0x01ae, 0x01af,
  0x01b1, 0x01b3,
  0x01b5, 0x01b5,
  0x01b7, 0x01b8,
  0x01bc, 0x01bc,
  0x01c4, 0x01c4,
  0x01c7, 0x01c7,
  0x01ca, 0x01ca,
  0x01cd, 0x01cd,
  0x01cf, 0x01cf,
  0x01d1, 0x01d1,
  0x01d3, 0x01d3,
  0x01d5, 0x01d5,
  0x01d7, 0x01d7,
  0x01d9, 0x01d9,
  0x01db, 0x01db,
  0x01de, 0x01de,
  0x01e0, 0x01e0,
  0x01e2, 0x01e2,
  0x01e4, 0x01e4,
  0x01e6, 0x01e6,
  0x01e8, 0x01e8,
  0x01ea, 0x01ea,
  0x01ec, 0x01ec,
  0x01ee, 0x01ee,
  0x01f1, 0x01f1,
  0x01f4, 0x01f4,
  0x01f6, 0x01f8,
  0x01fa, 0x01fa,
  0x01fc, 0x01fc,
  0x01fe, 0x01fe,
  0x0200, 0x0200,
  0x0202, 0x0202,
  0x0204, 0x0204,
  0x0206, 0x0206,
  0x0208, 0x0208,
  0x020a, 0x020a,
  0x020c, 0x020c,
  0x020e, 0x020e,
  0x0210, 0x0210,
  0x0212, 0x0212,
  0x0214, 0x0214,
  0x0216, 0x0216,
  0x0218, 0x0218,
  0x021a, 0x021a,
  0x021c, 0x021c,
  0x021e, 0x021e,
  0x0220, 0x0220,
  0x0222, 0x0222,
  0x0224, 0x0224,
  0x0226, 0x0226,
  0x0228, 0x0228,
  0x022a, 0x022a,
  0x022c, 0x022c,
  0x022e, 0x022e,
  0x0230, 0x0230,
  0x0232, 0x0232,
  0x023a, 0x023b,
  0x023d, 0x023e,
  0x0241, 0x0241,
  0x0386, 0x0386,
  0x0388, 0x038a,
  0x038c, 0x038c,
  0x038e, 0x038f,
  0x0391, 0x03a1,
  0x03a3, 0x03ab,
  0x03d2, 0x03d4,
  0x03d8, 0x03d8,
  0x03da, 0x03da,
  0x03dc, 0x03dc,
  0x03de, 0x03de,
  0x03e0, 0x03e0,
  0x03e2, 0x03e2,
  0x03e4, 0x03e4,
  0x03e6, 0x03e6,
  0x03e8, 0x03e8,
  0x03ea, 0x03ea,
  0x03ec, 0x03ec,
  0x03ee, 0x03ee,
  0x03f4, 0x03f4,
  0x03f7, 0x03f7,
  0x03f9, 0x03fa,
  0x03fd, 0x042f,
  0x0460, 0x0460,
  0x0462, 0x0462,
  0x0464, 0x0464,
  0x0466, 0x0466,
  0x0468, 0x0468,
  0x046a, 0x046a,
  0x046c, 0x046c,
  0x046e, 0x046e,
  0x0470, 0x0470,
  0x0472, 0x0472,
  0x0474, 0x0474,
  0x0476, 0x0476,
  0x0478, 0x0478,
  0x047a, 0x047a,
  0x047c, 0x047c,
  0x047e, 0x047e,
  0x0480, 0x0480,
  0x048a, 0x048a,
  0x048c, 0x048c,
  0x048e, 0x048e,
  0x0490, 0x0490,
  0x0492, 0x0492,
  0x0494, 0x0494,
  0x0496, 0x0496,
  0x0498, 0x0498,
  0x049a, 0x049a,
  0x049c, 0x049c,
  0x049e, 0x049e,
  0x04a0, 0x04a0,
  0x04a2, 0x04a2,
  0x04a4, 0x04a4,
  0x04a6, 0x04a6,
  0x04a8, 0x04a8,
  0x04aa, 0x04aa,
  0x04ac, 0x04ac,
  0x04ae, 0x04ae,
  0x04b0, 0x04b0,
  0x04b2, 0x04b2,
  0x04b4, 0x04b4,
  0x04b6, 0x04b6,
  0x04b8, 0x04b8,
  0x04ba, 0x04ba,
  0x04bc, 0x04bc,
  0x04be, 0x04be,
  0x04c0, 0x04c1,
  0x04c3, 0x04c3,
  0x04c5, 0x04c5,
  0x04c7, 0x04c7,
  0x04c9, 0x04c9,
  0x04cb, 0x04cb,
  0x04cd, 0x04cd,
  0x04d0, 0x04d0,
  0x04d2, 0x04d2,
  0x04d4, 0x04d4,
  0x04d6, 0x04d6,
  0x04d8, 0x04d8,
  0x04da, 0x04da,
  0x04dc, 0x04dc,
  0x04de, 0x04de,
  0x04e0, 0x04e0,
  0x04e2, 0x04e2,
  0x04e4, 0x04e4,
  0x04e6, 0x04e6,
  0x04e8, 0x04e8,
  0x04ea, 0x04ea,
  0x04ec, 0x04ec,
  0x04ee, 0x04ee,
  0x04f0, 0x04f0,
  0x04f2, 0x04f2,
  0x04f4, 0x04f4,
  0x04f6, 0x04f6,
  0x04f8, 0x04f8,
  0x0500, 0x0500,
  0x0502, 0x0502,
  0x0504, 0x0504,
  0x0506, 0x0506,
  0x0508, 0x0508,
  0x050a, 0x050a,
  0x050c, 0x050c,
  0x050e, 0x050e,
  0x0531, 0x0556,
  0x10a0, 0x10c5,
  0x1e00, 0x1e00,
  0x1e02, 0x1e02,
  0x1e04, 0x1e04,
  0x1e06, 0x1e06,
  0x1e08, 0x1e08,
  0x1e0a, 0x1e0a,
  0x1e0c, 0x1e0c,
  0x1e0e, 0x1e0e,
  0x1e10, 0x1e10,
  0x1e12, 0x1e12,
  0x1e14, 0x1e14,
  0x1e16, 0x1e16,
  0x1e18, 0x1e18,
  0x1e1a, 0x1e1a,
  0x1e1c, 0x1e1c,
  0x1e1e, 0x1e1e,
  0x1e20, 0x1e20,
  0x1e22, 0x1e22,
  0x1e24, 0x1e24,
  0x1e26, 0x1e26,
  0x1e28, 0x1e28,
  0x1e2a, 0x1e2a,
  0x1e2c, 0x1e2c,
  0x1e2e, 0x1e2e,
  0x1e30, 0x1e30,
  0x1e32, 0x1e32,
  0x1e34, 0x1e34,
  0x1e36, 0x1e36,
  0x1e38, 0x1e38,
  0x1e3a, 0x1e3a,
  0x1e3c, 0x1e3c,
  0x1e3e, 0x1e3e,
  0x1e40, 0x1e40,
  0x1e42, 0x1e42,
  0x1e44, 0x1e44,
  0x1e46, 0x1e46,
  0x1e48, 0x1e48,
  0x1e4a, 0x1e4a,
  0x1e4c, 0x1e4c,
  0x1e4e, 0x1e4e,
  0x1e50, 0x1e50,
  0x1e52, 0x1e52,
  0x1e54, 0x1e54,
  0x1e56, 0x1e56,
  0x1e58, 0x1e58,
  0x1e5a, 0x1e5a,
  0x1e5c, 0x1e5c,
  0x1e5e, 0x1e5e,
  0x1e60, 0x1e60,
  0x1e62, 0x1e62,
  0x1e64, 0x1e64,
  0x1e66, 0x1e66,
  0x1e68, 0x1e68,
  0x1e6a, 0x1e6a,
  0x1e6c, 0x1e6c,
  0x1e6e, 0x1e6e,
  0x1e70, 0x1e70,
  0x1e72, 0x1e72,
  0x1e74, 0x1e74,
  0x1e76, 0x1e76,
  0x1e78, 0x1e78,
  0x1e7a, 0x1e7a,
  0x1e7c, 0x1e7c,
  0x1e7e, 0x1e7e,
  0x1e80, 0x1e80,
  0x1e82, 0x1e82,
  0x1e84, 0x1e84,
  0x1e86, 0x1e86,
  0x1e88, 0x1e88,
  0x1e8a, 0x1e8a,
  0x1e8c, 0x1e8c,
  0x1e8e, 0x1e8e,
  0x1e90, 0x1e90,
  0x1e92, 0x1e92,
  0x1e94, 0x1e94,
  0x1ea0, 0x1ea0,
  0x1ea2, 0x1ea2,
  0x1ea4, 0x1ea4,
  0x1ea6, 0x1ea6,
  0x1ea8, 0x1ea8,
  0x1eaa, 0x1eaa,
  0x1eac, 0x1eac,
  0x1eae, 0x1eae,
  0x1eb0, 0x1eb0,
  0x1eb2, 0x1eb2,
  0x1eb4, 0x1eb4,
  0x1eb6, 0x1eb6,
  0x1eb8, 0x1eb8,
  0x1eba, 0x1eba,
  0x1ebc, 0x1ebc,
  0x1ebe, 0x1ebe,
  0x1ec0, 0x1ec0,
  0x1ec2, 0x1ec2,
  0x1ec4, 0x1ec4,
  0x1ec6, 0x1ec6,
  0x1ec8, 0x1ec8,
  0x1eca, 0x1eca,
  0x1ecc, 0x1ecc,
  0x1ece, 0x1ece,
  0x1ed0, 0x1ed0,
  0x1ed2, 0x1ed2,
  0x1ed4, 0x1ed4,
  0x1ed6, 0x1ed6,
  0x1ed8, 0x1ed8,
  0x1eda, 0x1eda,
  0x1edc, 0x1edc,
  0x1ede, 0x1ede,
  0x1ee0, 0x1ee0,
  0x1ee2, 0x1ee2,
  0x1ee4, 0x1ee4,
  0x1ee6, 0x1ee6,
  0x1ee8, 0x1ee8,
  0x1eea, 0x1eea,
  0x1eec, 0x1eec,
  0x1eee, 0x1eee,
  0x1ef0, 0x1ef0,
  0x1ef2, 0x1ef2,
  0x1ef4, 0x1ef4,
  0x1ef6, 0x1ef6,
  0x1ef8, 0x1ef8,
  0x1f08, 0x1f0f,
  0x1f18, 0x1f1d,
  0x1f28, 0x1f2f,
  0x1f38, 0x1f3f,
  0x1f48, 0x1f4d,
  0x1f59, 0x1f59,
  0x1f5b, 0x1f5b,
  0x1f5d, 0x1f5d,
  0x1f5f, 0x1f5f,
  0x1f68, 0x1f6f,
  0x1fb8, 0x1fbb,
  0x1fc8, 0x1fcb,
  0x1fd8, 0x1fdb,
  0x1fe8, 0x1fec,
  0x1ff8, 0x1ffb,
  0x2102, 0x2102,
  0x2107, 0x2107,
  0x210b, 0x210d,
  0x2110, 0x2112,
  0x2115, 0x2115,
  0x2119, 0x211d,
  0x2124, 0x2124,
  0x2126, 0x2126,
  0x2128, 0x2128,
  0x212a, 0x212d,
  0x2130, 0x2131,
  0x2133, 0x2133,
  0x213e, 0x213f,
  0x2145, 0x2145,
  0x2c00, 0x2c2e,
  0x2c80, 0x2c80,
  0x2c82, 0x2c82,
  0x2c84, 0x2c84,
  0x2c86, 0x2c86,
  0x2c88, 0x2c88,
  0x2c8a, 0x2c8a,
  0x2c8c, 0x2c8c,
  0x2c8e, 0x2c8e,
  0x2c90, 0x2c90,
  0x2c92, 0x2c92,
  0x2c94, 0x2c94,
  0x2c96, 0x2c96,
  0x2c98, 0x2c98,
  0x2c9a, 0x2c9a,
  0x2c9c, 0x2c9c,
  0x2c9e, 0x2c9e,
  0x2ca0, 0x2ca0,
  0x2ca2, 0x2ca2,
  0x2ca4, 0x2ca4,
  0x2ca6, 0x2ca6,
  0x2ca8, 0x2ca8,
  0x2caa, 0x2caa,
  0x2cac, 0x2cac,
  0x2cae, 0x2cae,
  0x2cb0, 0x2cb0,
  0x2cb2, 0x2cb2,
  0x2cb4, 0x2cb4,
  0x2cb6, 0x2cb6,
  0x2cb8, 0x2cb8,
  0x2cba, 0x2cba,
  0x2cbc, 0x2cbc,
  0x2cbe, 0x2cbe,
  0x2cc0, 0x2cc0,
  0x2cc2, 0x2cc2,
  0x2cc4, 0x2cc4,
  0x2cc6, 0x2cc6,
  0x2cc8, 0x2cc8,
  0x2cca, 0x2cca,
  0x2ccc, 0x2ccc,
  0x2cce, 0x2cce,
  0x2cd0, 0x2cd0,
  0x2cd2, 0x2cd2,
  0x2cd4, 0x2cd4,
  0x2cd6, 0x2cd6,
  0x2cd8, 0x2cd8,
  0x2cda, 0x2cda,
  0x2cdc, 0x2cdc,
  0x2cde, 0x2cde,
  0x2ce0, 0x2ce0,
  0x2ce2, 0x2ce2,
  0xff21, 0xff3a,
  0x10400, 0x10427,
  0x1d400, 0x1d419,
  0x1d434, 0x1d44d,
  0x1d468, 0x1d481,
  0x1d49c, 0x1d49c,
  0x1d49e, 0x1d49f,
  0x1d4a2, 0x1d4a2,
  0x1d4a5, 0x1d4a6,
  0x1d4a9, 0x1d4ac,
  0x1d4ae, 0x1d4b5,
  0x1d4d0, 0x1d4e9,
  0x1d504, 0x1d505,
  0x1d507, 0x1d50a,
  0x1d50d, 0x1d514,
  0x1d516, 0x1d51c,
  0x1d538, 0x1d539,
  0x1d53b, 0x1d53e,
  0x1d540, 0x1d544,
  0x1d546, 0x1d546,
  0x1d54a, 0x1d550,
  0x1d56c, 0x1d585,
  0x1d5a0, 0x1d5b9,
  0x1d5d4, 0x1d5ed,
  0x1d608, 0x1d621,
  0x1d63c, 0x1d655,
  0x1d670, 0x1d689,
  0x1d6a8, 0x1d6c0,
  0x1d6e2, 0x1d6fa,
  0x1d71c, 0x1d734,
  0x1d756, 0x1d76e,
  0x1d790, 0x1d7a8
}; /* CR_Upper */

/* 'XDigit': [[:XDigit:]] */
static const OnigCodePoint CR_XDigit[] = {
  3,
  0x0030, 0x0039,
  0x0041, 0x0046,
  0x0061, 0x0066
}; /* CR_XDigit */

/* 'Word': [[:Word:]] */
static const OnigCodePoint CR_Word[] = {
  464,
  0x0030, 0x0039,
  0x0041, 0x005a,
  0x005f, 0x005f,
  0x0061, 0x007a,
  0x00aa, 0x00aa,
  0x00b2, 0x00b3,
  0x00b5, 0x00b5,
  0x00b9, 0x00ba,
  0x00bc, 0x00be,
  0x00c0, 0x00d6,
  0x00d8, 0x00f6,
  0x00f8, 0x0241,
  0x0250, 0x02c1,
  0x02c6, 0x02d1,
  0x02e0, 0x02e4,
  0x02ee, 0x02ee,
  0x0300, 0x036f,
  0x037a, 0x037a,
  0x0386, 0x0386,
  0x0388, 0x038a,
  0x038c, 0x038c,
  0x038e, 0x03a1,
  0x03a3, 0x03ce,
  0x03d0, 0x03f5,
  0x03f7, 0x0481,
  0x0483, 0x0486,
  0x0488, 0x04ce,
  0x04d0, 0x04f9,
  0x0500, 0x050f,
  0x0531, 0x0556,
  0x0559, 0x0559,
  0x0561, 0x0587,
  0x0591, 0x05b9,
  0x05bb, 0x05bd,
  0x05bf, 0x05bf,
  0x05c1, 0x05c2,
  0x05c4, 0x05c5,
  0x05c7, 0x05c7,
  0x05d0, 0x05ea,
  0x05f0, 0x05f2,
  0x0610, 0x0615,
  0x0621, 0x063a,
  0x0640, 0x065e,
  0x0660, 0x0669,
  0x066e, 0x06d3,
  0x06d5, 0x06dc,
  0x06de, 0x06e8,
  0x06ea, 0x06fc,
  0x06ff, 0x06ff,
  0x0710, 0x074a,
  0x074d, 0x076d,
  0x0780, 0x07b1,
  0x0901, 0x0939,
  0x093c, 0x094d,
  0x0950, 0x0954,
  0x0958, 0x0963,
  0x0966, 0x096f,
  0x097d, 0x097d,
  0x0981, 0x0983,
  0x0985, 0x098c,
  0x098f, 0x0990,
  0x0993, 0x09a8,
  0x09aa, 0x09b0,
  0x09b2, 0x09b2,
  0x09b6, 0x09b9,
  0x09bc, 0x09c4,
  0x09c7, 0x09c8,
  0x09cb, 0x09ce,
  0x09d7, 0x09d7,
  0x09dc, 0x09dd,
  0x09df, 0x09e3,
  0x09e6, 0x09f1,
  0x09f4, 0x09f9,
  0x0a01, 0x0a03,
  0x0a05, 0x0a0a,
  0x0a0f, 0x0a10,
  0x0a13, 0x0a28,
  0x0a2a, 0x0a30,
  0x0a32, 0x0a33,
  0x0a35, 0x0a36,
  0x0a38, 0x0a39,
  0x0a3c, 0x0a3c,
  0x0a3e, 0x0a42,
  0x0a47, 0x0a48,
  0x0a4b, 0x0a4d,
  0x0a59, 0x0a5c,
  0x0a5e, 0x0a5e,
  0x0a66, 0x0a74,
  0x0a81, 0x0a83,
  0x0a85, 0x0a8d,
  0x0a8f, 0x0a91,
  0x0a93, 0x0aa8,
  0x0aaa, 0x0ab0,
  0x0ab2, 0x0ab3,
  0x0ab5, 0x0ab9,
  0x0abc, 0x0ac5,
  0x0ac7, 0x0ac9,
  0x0acb, 0x0acd,
  0x0ad0, 0x0ad0,
  0x0ae0, 0x0ae3,
  0x0ae6, 0x0aef,
  0x0b01, 0x0b03,
  0x0b05, 0x0b0c,
  0x0b0f, 0x0b10,
  0x0b13, 0x0b28,
  0x0b2a, 0x0b30,
  0x0b32, 0x0b33,
  0x0b35, 0x0b39,
  0x0b3c, 0x0b43,
  0x0b47, 0x0b48,
  0x0b4b, 0x0b4d,
  0x0b56, 0x0b57,
  0x0b5c, 0x0b5d,
  0x0b5f, 0x0b61,
  0x0b66, 0x0b6f,
  0x0b71, 0x0b71,
  0x0b82, 0x0b83,
  0x0b85, 0x0b8a,
  0x0b8e, 0x0b90,
  0x0b92, 0x0b95,
  0x0b99, 0x0b9a,
  0x0b9c, 0x0b9c,
  0x0b9e, 0x0b9f,
  0x0ba3, 0x0ba4,
  0x0ba8, 0x0baa,
  0x0bae, 0x0bb9,
  0x0bbe, 0x0bc2,
  0x0bc6, 0x0bc8,
  0x0bca, 0x0bcd,
  0x0bd7, 0x0bd7,
  0x0be6, 0x0bf2,
  0x0c01, 0x0c03,
  0x0c05, 0x0c0c,
  0x0c0e, 0x0c10,
  0x0c12, 0x0c28,
  0x0c2a, 0x0c33,
  0x0c35, 0x0c39,
  0x0c3e, 0x0c44,
  0x0c46, 0x0c48,
  0x0c4a, 0x0c4d,
  0x0c55, 0x0c56,
  0x0c60, 0x0c61,
  0x0c66, 0x0c6f,
  0x0c82, 0x0c83,
  0x0c85, 0x0c8c,
  0x0c8e, 0x0c90,
  0x0c92, 0x0ca8,
  0x0caa, 0x0cb3,
  0x0cb5, 0x0cb9,
  0x0cbc, 0x0cc4,
  0x0cc6, 0x0cc8,
  0x0cca, 0x0ccd,
  0x0cd5, 0x0cd6,
  0x0cde, 0x0cde,
  0x0ce0, 0x0ce1,
  0x0ce6, 0x0cef,
  0x0d02, 0x0d03,
  0x0d05, 0x0d0c,
  0x0d0e, 0x0d10,
  0x0d12, 0x0d28,
  0x0d2a, 0x0d39,
  0x0d3e, 0x0d43,
  0x0d46, 0x0d48,
  0x0d4a, 0x0d4d,
  0x0d57, 0x0d57,
  0x0d60, 0x0d61,
  0x0d66, 0x0d6f,
  0x0d82, 0x0d83,
  0x0d85, 0x0d96,
  0x0d9a, 0x0db1,
  0x0db3, 0x0dbb,
  0x0dbd, 0x0dbd,
  0x0dc0, 0x0dc6,
  0x0dca, 0x0dca,
  0x0dcf, 0x0dd4,
  0x0dd6, 0x0dd6,
  0x0dd8, 0x0ddf,
  0x0df2, 0x0df3,
  0x0e01, 0x0e3a,
  0x0e40, 0x0e4e,
  0x0e50, 0x0e59,
  0x0e81, 0x0e82,
  0x0e84, 0x0e84,
  0x0e87, 0x0e88,
  0x0e8a, 0x0e8a,
  0x0e8d, 0x0e8d,
  0x0e94, 0x0e97,
  0x0e99, 0x0e9f,
  0x0ea1, 0x0ea3,
  0x0ea5, 0x0ea5,
  0x0ea7, 0x0ea7,
  0x0eaa, 0x0eab,
  0x0ead, 0x0eb9,
  0x0ebb, 0x0ebd,
  0x0ec0, 0x0ec4,
  0x0ec6, 0x0ec6,
  0x0ec8, 0x0ecd,
  0x0ed0, 0x0ed9,
  0x0edc, 0x0edd,
  0x0f00, 0x0f00,
  0x0f18, 0x0f19,
  0x0f20, 0x0f33,
  0x0f35, 0x0f35,
  0x0f37, 0x0f37,
  0x0f39, 0x0f39,
  0x0f3e, 0x0f47,
  0x0f49, 0x0f6a,
  0x0f71, 0x0f84,
  0x0f86, 0x0f8b,
  0x0f90, 0x0f97,
  0x0f99, 0x0fbc,
  0x0fc6, 0x0fc6,
  0x1000, 0x1021,
  0x1023, 0x1027,
  0x1029, 0x102a,
  0x102c, 0x1032,
  0x1036, 0x1039,
  0x1040, 0x1049,
  0x1050, 0x1059,
  0x10a0, 0x10c5,
  0x10d0, 0x10fa,
  0x10fc, 0x10fc,
  0x1100, 0x1159,
  0x115f, 0x11a2,
  0x11a8, 0x11f9,
  0x1200, 0x1248,
  0x124a, 0x124d,
  0x1250, 0x1256,
  0x1258, 0x1258,
  0x125a, 0x125d,
  0x1260, 0x1288,
  0x128a, 0x128d,
  0x1290, 0x12b0,
  0x12b2, 0x12b5,
  0x12b8, 0x12be,
  0x12c0, 0x12c0,
  0x12c2, 0x12c5,
  0x12c8, 0x12d6,
  0x12d8, 0x1310,
  0x1312, 0x1315,
  0x1318, 0x135a,
  0x135f, 0x135f,
  0x1369, 0x137c,
  0x1380, 0x138f,
  0x13a0, 0x13f4,
  0x1401, 0x166c,
  0x166f, 0x1676,
  0x1681, 0x169a,
  0x16a0, 0x16ea,
  0x16ee, 0x16f0,
  0x1700, 0x170c,
  0x170e, 0x1714,
  0x1720, 0x1734,
  0x1740, 0x1753,
  0x1760, 0x176c,
  0x176e, 0x1770,
  0x1772, 0x1773,
  0x1780, 0x17b3,
  0x17b6, 0x17d3,
  0x17d7, 0x17d7,
  0x17dc, 0x17dd,
  0x17e0, 0x17e9,
  0x17f0, 0x17f9,
  0x180b, 0x180d,
  0x1810, 0x1819,
  0x1820, 0x1877,
  0x1880, 0x18a9,
  0x1900, 0x191c,
  0x1920, 0x192b,
  0x1930, 0x193b,
  0x1946, 0x196d,
  0x1970, 0x1974,
  0x1980, 0x19a9,
  0x19b0, 0x19c9,
  0x19d0, 0x19d9,
  0x1a00, 0x1a1b,
  0x1d00, 0x1dc3,
  0x1e00, 0x1e9b,
  0x1ea0, 0x1ef9,
  0x1f00, 0x1f15,
  0x1f18, 0x1f1d,
  0x1f20, 0x1f45,
  0x1f48, 0x1f4d,
  0x1f50, 0x1f57,
  0x1f59, 0x1f59,
  0x1f5b, 0x1f5b,
  0x1f5d, 0x1f5d,
  0x1f5f, 0x1f7d,
  0x1f80, 0x1fb4,
  0x1fb6, 0x1fbc,
  0x1fbe, 0x1fbe,
  0x1fc2, 0x1fc4,
  0x1fc6, 0x1fcc,
  0x1fd0, 0x1fd3,
  0x1fd6, 0x1fdb,
  0x1fe0, 0x1fec,
  0x1ff2, 0x1ff4,
  0x1ff6, 0x1ffc,
  0x203f, 0x2040,
  0x2054, 0x2054,
  0x2070, 0x2071,
  0x2074, 0x2079,
  0x207f, 0x2089,
  0x2090, 0x2094,
  0x20d0, 0x20eb,
  0x2102, 0x2102,
  0x2107, 0x2107,
  0x210a, 0x2113,
  0x2115, 0x2115,
  0x2119, 0x211d,
  0x2124, 0x2124,
  0x2126, 0x2126,
  0x2128, 0x2128,
  0x212a, 0x212d,
  0x212f, 0x2131,
  0x2133, 0x2139,
  0x213c, 0x213f,
  0x2145, 0x2149,
  0x2153, 0x2183,
  0x2460, 0x249b,
  0x24ea, 0x24ff,
  0x2776, 0x2793,
  0x2c00, 0x2c2e,
  0x2c30, 0x2c5e,
  0x2c80, 0x2ce4,
  0x2cfd, 0x2cfd,
  0x2d00, 0x2d25,
  0x2d30, 0x2d65,
  0x2d6f, 0x2d6f,
  0x2d80, 0x2d96,
  0x2da0, 0x2da6,
  0x2da8, 0x2dae,
  0x2db0, 0x2db6,
  0x2db8, 0x2dbe,
  0x2dc0, 0x2dc6,
  0x2dc8, 0x2dce,
  0x2dd0, 0x2dd6,
  0x2dd8, 0x2dde,
  0x3005, 0x3007,
  0x3021, 0x302f,
  0x3031, 0x3035,
  0x3038, 0x303c,
  0x3041, 0x3096,
  0x3099, 0x309a,
  0x309d, 0x309f,
  0x30a1, 0x30fa,
  0x30fc, 0x30ff,
  0x3105, 0x312c,
  0x3131, 0x318e,
  0x3192, 0x3195,
  0x31a0, 0x31b7,
  0x31f0, 0x31ff,
  0x3220, 0x3229,
  0x3251, 0x325f,
  0x3280, 0x3289,
  0x32b1, 0x32bf,
  0x3400, 0x4db5,
  0x4e00, 0x9fbb,
  0xa000, 0xa48c,
  0xa800, 0xa827,
  0xac00, 0xd7a3,
  0xf900, 0xfa2d,
  0xfa30, 0xfa6a,
  0xfa70, 0xfad9,
  0xfb00, 0xfb06,
  0xfb13, 0xfb17,
  0xfb1d, 0xfb28,
  0xfb2a, 0xfb36,
  0xfb38, 0xfb3c,
  0xfb3e, 0xfb3e,
  0xfb40, 0xfb41,
  0xfb43, 0xfb44,
  0xfb46, 0xfbb1,
  0xfbd3, 0xfd3d,
  0xfd50, 0xfd8f,
  0xfd92, 0xfdc7,
  0xfdf0, 0xfdfb,
  0xfe00, 0xfe0f,
  0xfe20, 0xfe23,
  0xfe33, 0xfe34,
  0xfe4d, 0xfe4f,
  0xfe70, 0xfe74,
  0xfe76, 0xfefc,
  0xff10, 0xff19,
  0xff21, 0xff3a,
  0xff3f, 0xff3f,
  0xff41, 0xff5a,
  0xff66, 0xffbe,
  0xffc2, 0xffc7,
  0xffca, 0xffcf,
  0xffd2, 0xffd7,
  0xffda, 0xffdc,
  0x10000, 0x1000b,
  0x1000d, 0x10026,
  0x10028, 0x1003a,
  0x1003c, 0x1003d,
  0x1003f, 0x1004d,
  0x10050, 0x1005d,
  0x10080, 0x100fa,
  0x10107, 0x10133,
  0x10140, 0x10178,
  0x1018a, 0x1018a,
  0x10300, 0x1031e,
  0x10320, 0x10323,
  0x10330, 0x1034a,
  0x10380, 0x1039d,
  0x103a0, 0x103c3,
  0x103c8, 0x103cf,
  0x103d1, 0x103d5,
  0x10400, 0x1049d,
  0x104a0, 0x104a9,
  0x10800, 0x10805,
  0x10808, 0x10808,
  0x1080a, 0x10835,
  0x10837, 0x10838,
  0x1083c, 0x1083c,
  0x1083f, 0x1083f,
  0x10a00, 0x10a03,
  0x10a05, 0x10a06,
  0x10a0c, 0x10a13,
  0x10a15, 0x10a17,
  0x10a19, 0x10a33,
  0x10a38, 0x10a3a,
  0x10a3f, 0x10a47,
  0x1d165, 0x1d169,
  0x1d16d, 0x1d172,
  0x1d17b, 0x1d182,
  0x1d185, 0x1d18b,
  0x1d1aa, 0x1d1ad,
  0x1d242, 0x1d244,
  0x1d400, 0x1d454,
  0x1d456, 0x1d49c,
  0x1d49e, 0x1d49f,
  0x1d4a2, 0x1d4a2,
  0x1d4a5, 0x1d4a6,
  0x1d4a9, 0x1d4ac,
  0x1d4ae, 0x1d4b9,
  0x1d4bb, 0x1d4bb,
  0x1d4bd, 0x1d4c3,
  0x1d4c5, 0x1d505,
  0x1d507, 0x1d50a,
  0x1d50d, 0x1d514,
  0x1d516, 0x1d51c,
  0x1d51e, 0x1d539,
  0x1d53b, 0x1d53e,
  0x1d540, 0x1d544,
  0x1d546, 0x1d546,
  0x1d54a, 0x1d550,
  0x1d552, 0x1d6a5,
  0x1d6a8, 0x1d6c0,
  0x1d6c2, 0x1d6da,
  0x1d6dc, 0x1d6fa,
  0x1d6fc, 0x1d714,
  0x1d716, 0x1d734,
  0x1d736, 0x1d74e,
  0x1d750, 0x1d76e,
  0x1d770, 0x1d788,
  0x1d78a, 0x1d7a8,
  0x1d7aa, 0x1d7c2,
  0x1d7c4, 0x1d7c9,
  0x1d7ce, 0x1d7ff,
  0x20000, 0x2a6d6,
  0x2f800, 0x2fa1d,
  0xe0100, 0xe01ef
}; /* CR_Word */

/* 'Alnum': [[:Alnum:]] */
static const OnigCodePoint CR_Alnum[] = {
  436,
  0x0030, 0x0039,
  0x0041, 0x005a,
  0x0061, 0x007a,
  0x00aa, 0x00aa,
  0x00b5, 0x00b5,
  0x00ba, 0x00ba,
  0x00c0, 0x00d6,
  0x00d8, 0x00f6,
  0x00f8, 0x0241,
  0x0250, 0x02c1,
  0x02c6, 0x02d1,
  0x02e0, 0x02e4,
  0x02ee, 0x02ee,
  0x0300, 0x036f,
  0x037a, 0x037a,
  0x0386, 0x0386,
  0x0388, 0x038a,
  0x038c, 0x038c,
  0x038e, 0x03a1,
  0x03a3, 0x03ce,
  0x03d0, 0x03f5,
  0x03f7, 0x0481,
  0x0483, 0x0486,
  0x0488, 0x04ce,
  0x04d0, 0x04f9,
  0x0500, 0x050f,
  0x0531, 0x0556,
  0x0559, 0x0559,
  0x0561, 0x0587,
  0x0591, 0x05b9,
  0x05bb, 0x05bd,
  0x05bf, 0x05bf,
  0x05c1, 0x05c2,
  0x05c4, 0x05c5,
  0x05c7, 0x05c7,
  0x05d0, 0x05ea,
  0x05f0, 0x05f2,
  0x0610, 0x0615,
  0x0621, 0x063a,
  0x0640, 0x065e,
  0x0660, 0x0669,
  0x066e, 0x06d3,
  0x06d5, 0x06dc,
  0x06de, 0x06e8,
  0x06ea, 0x06fc,
  0x06ff, 0x06ff,
  0x0710, 0x074a,
  0x074d, 0x076d,
  0x0780, 0x07b1,
  0x0901, 0x0939,
  0x093c, 0x094d,
  0x0950, 0x0954,
  0x0958, 0x0963,
  0x0966, 0x096f,
  0x097d, 0x097d,
  0x0981, 0x0983,
  0x0985, 0x098c,
  0x098f, 0x0990,
  0x0993, 0x09a8,
  0x09aa, 0x09b0,
  0x09b2, 0x09b2,
  0x09b6, 0x09b9,
  0x09bc, 0x09c4,
  0x09c7, 0x09c8,
  0x09cb, 0x09ce,
  0x09d7, 0x09d7,
  0x09dc, 0x09dd,
  0x09df, 0x09e3,
  0x09e6, 0x09f1,
  0x0a01, 0x0a03,
  0x0a05, 0x0a0a,
  0x0a0f, 0x0a10,
  0x0a13, 0x0a28,
  0x0a2a, 0x0a30,
  0x0a32, 0x0a33,
  0x0a35, 0x0a36,
  0x0a38, 0x0a39,
  0x0a3c, 0x0a3c,
  0x0a3e, 0x0a42,
  0x0a47, 0x0a48,
  0x0a4b, 0x0a4d,
  0x0a59, 0x0a5c,
  0x0a5e, 0x0a5e,
  0x0a66, 0x0a74,
  0x0a81, 0x0a83,
  0x0a85, 0x0a8d,
  0x0a8f, 0x0a91,
  0x0a93, 0x0aa8,
  0x0aaa, 0x0ab0,
  0x0ab2, 0x0ab3,
  0x0ab5, 0x0ab9,
  0x0abc, 0x0ac5,
  0x0ac7, 0x0ac9,
  0x0acb, 0x0acd,
  0x0ad0, 0x0ad0,
  0x0ae0, 0x0ae3,
  0x0ae6, 0x0aef,
  0x0b01, 0x0b03,
  0x0b05, 0x0b0c,
  0x0b0f, 0x0b10,
  0x0b13, 0x0b28,
  0x0b2a, 0x0b30,
  0x0b32, 0x0b33,
  0x0b35, 0x0b39,
  0x0b3c, 0x0b43,
  0x0b47, 0x0b48,
  0x0b4b, 0x0b4d,
  0x0b56, 0x0b57,
  0x0b5c, 0x0b5d,
  0x0b5f, 0x0b61,
  0x0b66, 0x0b6f,
  0x0b71, 0x0b71,
  0x0b82, 0x0b83,
  0x0b85, 0x0b8a,
  0x0b8e, 0x0b90,
  0x0b92, 0x0b95,
  0x0b99, 0x0b9a,
  0x0b9c, 0x0b9c,
  0x0b9e, 0x0b9f,
  0x0ba3, 0x0ba4,
  0x0ba8, 0x0baa,
  0x0bae, 0x0bb9,
  0x0bbe, 0x0bc2,
  0x0bc6, 0x0bc8,
  0x0bca, 0x0bcd,
  0x0bd7, 0x0bd7,
  0x0be6, 0x0bef,
  0x0c01, 0x0c03,
  0x0c05, 0x0c0c,
  0x0c0e, 0x0c10,
  0x0c12, 0x0c28,
  0x0c2a, 0x0c33,
  0x0c35, 0x0c39,
  0x0c3e, 0x0c44,
  0x0c46, 0x0c48,
  0x0c4a, 0x0c4d,
  0x0c55, 0x0c56,
  0x0c60, 0x0c61,
  0x0c66, 0x0c6f,
  0x0c82, 0x0c83,
  0x0c85, 0x0c8c,
  0x0c8e, 0x0c90,
  0x0c92, 0x0ca8,
  0x0caa, 0x0cb3,
  0x0cb5, 0x0cb9,
  0x0cbc, 0x0cc4,
  0x0cc6, 0x0cc8,
  0x0cca, 0x0ccd,
  0x0cd5, 0x0cd6,
  0x0cde, 0x0cde,
  0x0ce0, 0x0ce1,
  0x0ce6, 0x0cef,
  0x0d02, 0x0d03,
  0x0d05, 0x0d0c,
  0x0d0e, 0x0d10,
  0x0d12, 0x0d28,
  0x0d2a, 0x0d39,
  0x0d3e, 0x0d43,
  0x0d46, 0x0d48,
  0x0d4a, 0x0d4d,
  0x0d57, 0x0d57,
  0x0d60, 0x0d61,
  0x0d66, 0x0d6f,
  0x0d82, 0x0d83,
  0x0d85, 0x0d96,
  0x0d9a, 0x0db1,
  0x0db3, 0x0dbb,
  0x0dbd, 0x0dbd,
  0x0dc0, 0x0dc6,
  0x0dca, 0x0dca,
  0x0dcf, 0x0dd4,
  0x0dd6, 0x0dd6,
  0x0dd8, 0x0ddf,
  0x0df2, 0x0df3,
  0x0e01, 0x0e3a,
  0x0e40, 0x0e4e,
  0x0e50, 0x0e59,
  0x0e81, 0x0e82,
  0x0e84, 0x0e84,
  0x0e87, 0x0e88,
  0x0e8a, 0x0e8a,
  0x0e8d, 0x0e8d,
  0x0e94, 0x0e97,
  0x0e99, 0x0e9f,
  0x0ea1, 0x0ea3,
  0x0ea5, 0x0ea5,
  0x0ea7, 0x0ea7,
  0x0eaa, 0x0eab,
  0x0ead, 0x0eb9,
  0x0ebb, 0x0ebd,
  0x0ec0, 0x0ec4,
  0x0ec6, 0x0ec6,
  0x0ec8, 0x0ecd,
  0x0ed0, 0x0ed9,
  0x0edc, 0x0edd,
  0x0f00, 0x0f00,
  0x0f18, 0x0f19,
  0x0f20, 0x0f29,
  0x0f35, 0x0f35,
  0x0f37, 0x0f37,
  0x0f39, 0x0f39,
  0x0f3e, 0x0f47,
  0x0f49, 0x0f6a,
  0x0f71, 0x0f84,
  0x0f86, 0x0f8b,
  0x0f90, 0x0f97,
  0x0f99, 0x0fbc,
  0x0fc6, 0x0fc6,
  0x1000, 0x1021,
  0x1023, 0x1027,
  0x1029, 0x102a,
  0x102c, 0x1032,
  0x1036, 0x1039,
  0x1040, 0x1049,
  0x1050, 0x1059,
  0x10a0, 0x10c5,
  0x10d0, 0x10fa,
  0x10fc, 0x10fc,
  0x1100, 0x1159,
  0x115f, 0x11a2,
  0x11a8, 0x11f9,
  0x1200, 0x1248,
  0x124a, 0x124d,
  0x1250, 0x1256,
  0x1258, 0x1258,
  0x125a, 0x125d,
  0x1260, 0x1288,
  0x128a, 0x128d,
  0x1290, 0x12b0,
  0x12b2, 0x12b5,
  0x12b8, 0x12be,
  0x12c0, 0x12c0,
  0x12c2, 0x12c5,
  0x12c8, 0x12d6,
  0x12d8, 0x1310,
  0x1312, 0x1315,
  0x1318, 0x135a,
  0x135f, 0x135f,
  0x1380, 0x138f,
  0x13a0, 0x13f4,
  0x1401, 0x166c,
  0x166f, 0x1676,
  0x1681, 0x169a,
  0x16a0, 0x16ea,
  0x1700, 0x170c,
  0x170e, 0x1714,
  0x1720, 0x1734,
  0x1740, 0x1753,
  0x1760, 0x176c,
  0x176e, 0x1770,
  0x1772, 0x1773,
  0x1780, 0x17b3,
  0x17b6, 0x17d3,
  0x17d7, 0x17d7,
  0x17dc, 0x17dd,
  0x17e0, 0x17e9,
  0x180b, 0x180d,
  0x1810, 0x1819,
  0x1820, 0x1877,
  0x1880, 0x18a9,
  0x1900, 0x191c,
  0x1920, 0x192b,
  0x1930, 0x193b,
  0x1946, 0x196d,
  0x1970, 0x1974,
  0x1980, 0x19a9,
  0x19b0, 0x19c9,
  0x19d0, 0x19d9,
  0x1a00, 0x1a1b,
  0x1d00, 0x1dc3,
  0x1e00, 0x1e9b,
  0x1ea0, 0x1ef9,
  0x1f00, 0x1f15,
  0x1f18, 0x1f1d,
  0x1f20, 0x1f45,
  0x1f48, 0x1f4d,
  0x1f50, 0x1f57,
  0x1f59, 0x1f59,
  0x1f5b, 0x1f5b,
  0x1f5d, 0x1f5d,
  0x1f5f, 0x1f7d,
  0x1f80, 0x1fb4,
  0x1fb6, 0x1fbc,
  0x1fbe, 0x1fbe,
  0x1fc2, 0x1fc4,
  0x1fc6, 0x1fcc,
  0x1fd0, 0x1fd3,
  0x1fd6, 0x1fdb,
  0x1fe0, 0x1fec,
  0x1ff2, 0x1ff4,
  0x1ff6, 0x1ffc,
  0x2071, 0x2071,
  0x207f, 0x207f,
  0x2090, 0x2094,
  0x20d0, 0x20eb,
  0x2102, 0x2102,
  0x2107, 0x2107,
  0x210a, 0x2113,
  0x2115, 0x2115,
  0x2119, 0x211d,
  0x2124, 0x2124,
  0x2126, 0x2126,
  0x2128, 0x2128,
  0x212a, 0x212d,
  0x212f, 0x2131,
  0x2133, 0x2139,
  0x213c, 0x213f,
  0x2145, 0x2149,
  0x2c00, 0x2c2e,
  0x2c30, 0x2c5e,
  0x2c80, 0x2ce4,
  0x2d00, 0x2d25,
  0x2d30, 0x2d65,
  0x2d6f, 0x2d6f,
  0x2d80, 0x2d96,
  0x2da0, 0x2da6,
  0x2da8, 0x2dae,
  0x2db0, 0x2db6,
  0x2db8, 0x2dbe,
  0x2dc0, 0x2dc6,
  0x2dc8, 0x2dce,
  0x2dd0, 0x2dd6,
  0x2dd8, 0x2dde,
  0x3005, 0x3006,
  0x302a, 0x302f,
  0x3031, 0x3035,
  0x303b, 0x303c,
  0x3041, 0x3096,
  0x3099, 0x309a,
  0x309d, 0x309f,
  0x30a1, 0x30fa,
  0x30fc, 0x30ff,
  0x3105, 0x312c,
  0x3131, 0x318e,
  0x31a0, 0x31b7,
  0x31f0, 0x31ff,
  0x3400, 0x4db5,
  0x4e00, 0x9fbb,
  0xa000, 0xa48c,
  0xa800, 0xa827,
  0xac00, 0xd7a3,
  0xf900, 0xfa2d,
  0xfa30, 0xfa6a,
  0xfa70, 0xfad9,
  0xfb00, 0xfb06,
  0xfb13, 0xfb17,
  0xfb1d, 0xfb28,
  0xfb2a, 0xfb36,
  0xfb38, 0xfb3c,
  0xfb3e, 0xfb3e,
  0xfb40, 0xfb41,
  0xfb43, 0xfb44,
  0xfb46, 0xfbb1,
  0xfbd3, 0xfd3d,
  0xfd50, 0xfd8f,
  0xfd92, 0xfdc7,
  0xfdf0, 0xfdfb,
  0xfe00, 0xfe0f,
  0xfe20, 0xfe23,
  0xfe70, 0xfe74,
  0xfe76, 0xfefc,
  0xff10, 0xff19,
  0xff21, 0xff3a,
  0xff41, 0xff5a,
  0xff66, 0xffbe,
  0xffc2, 0xffc7,
  0xffca, 0xffcf,
  0xffd2, 0xffd7,
  0xffda, 0xffdc,
  0x10000, 0x1000b,
  0x1000d, 0x10026,
  0x10028, 0x1003a,
  0x1003c, 0x1003d,
  0x1003f, 0x1004d,
  0x10050, 0x1005d,
  0x10080, 0x100fa,
  0x10300, 0x1031e,
  0x10330, 0x10349,
  0x10380, 0x1039d,
  0x103a0, 0x103c3,
  0x103c8, 0x103cf,
  0x10400, 0x1049d,
  0x104a0, 0x104a9,
  0x10800, 0x10805,
  0x10808, 0x10808,
  0x1080a, 0x10835,
  0x10837, 0x10838,
  0x1083c, 0x1083c,
  0x1083f, 0x1083f,
  0x10a00, 0x10a03,
  0x10a05, 0x10a06,
  0x10a0c, 0x10a13,
  0x10a15, 0x10a17,
  0x10a19, 0x10a33,
  0x10a38, 0x10a3a,
  0x10a3f, 0x10a3f,
  0x1d165, 0x1d169,
  0x1d16d, 0x1d172,
  0x1d17b, 0x1d182,
  0x1d185, 0x1d18b,
  0x1d1aa, 0x1d1ad,
  0x1d242, 0x1d244,
  0x1d400, 0x1d454,
  0x1d456, 0x1d49c,
  0x1d49e, 0x1d49f,
  0x1d4a2, 0x1d4a2,
  0x1d4a5, 0x1d4a6,
  0x1d4a9, 0x1d4ac,
  0x1d4ae, 0x1d4b9,
  0x1d4bb, 0x1d4bb,
  0x1d4bd, 0x1d4c3,
  0x1d4c5, 0x1d505,
  0x1d507, 0x1d50a,
  0x1d50d, 0x1d514,
  0x1d516, 0x1d51c,
  0x1d51e, 0x1d539,
  0x1d53b, 0x1d53e,
  0x1d540, 0x1d544,
  0x1d546, 0x1d546,
  0x1d54a, 0x1d550,
  0x1d552, 0x1d6a5,
  0x1d6a8, 0x1d6c0,
  0x1d6c2, 0x1d6da,
  0x1d6dc, 0x1d6fa,
  0x1d6fc, 0x1d714,
  0x1d716, 0x1d734,
  0x1d736, 0x1d74e,
  0x1d750, 0x1d76e,
  0x1d770, 0x1d788,
  0x1d78a, 0x1d7a8,
  0x1d7aa, 0x1d7c2,
  0x1d7c4, 0x1d7c9,
  0x1d7ce, 0x1d7ff,
  0x20000, 0x2a6d6,
  0x2f800, 0x2fa1d,
  0xe0100, 0xe01ef
}; /* CR_Alnum */

/* 'ASCII': [[:ASCII:]] */
static const OnigCodePoint CR_ASCII[] = {
  1,
  0x0000, 0x007f
}; /* CR_ASCII */


typedef struct {
  int n;
  OnigCodePoint code[3];
} CodePointList3;

typedef struct {
  OnigCodePoint  from;
  CodePointList3 to;
} CaseFold_11_Type;

typedef struct {
  OnigCodePoint  from;
  CodePointList3 to;
} CaseUnfold_11_Type;

typedef struct {
  int n;
  OnigCodePoint code[2];
} CodePointList2;

typedef struct {
  OnigCodePoint  from[2];
  CodePointList2 to;
} CaseUnfold_12_Type;

typedef struct {
  OnigCodePoint  from[3];
  CodePointList2 to;
} CaseUnfold_13_Type;

static const CaseFold_11_Type CaseFold[] = {
 { 0x0041, {1, {0x0061}}},
 { 0x0042, {1, {0x0062}}},
 { 0x0043, {1, {0x0063}}},
 { 0x0044, {1, {0x0064}}},
 { 0x0045, {1, {0x0065}}},
 { 0x0046, {1, {0x0066}}},
 { 0x0047, {1, {0x0067}}},
 { 0x0048, {1, {0x0068}}},
 { 0x004a, {1, {0x006a}}},
 { 0x004b, {1, {0x006b}}},
 { 0x004c, {1, {0x006c}}},
 { 0x004d, {1, {0x006d}}},
 { 0x004e, {1, {0x006e}}},
 { 0x004f, {1, {0x006f}}},
 { 0x0050, {1, {0x0070}}},
 { 0x0051, {1, {0x0071}}},
 { 0x0052, {1, {0x0072}}},
 { 0x0053, {1, {0x0073}}},
 { 0x0054, {1, {0x0074}}},
 { 0x0055, {1, {0x0075}}},
 { 0x0056, {1, {0x0076}}},
 { 0x0057, {1, {0x0077}}},
 { 0x0058, {1, {0x0078}}},
 { 0x0059, {1, {0x0079}}},
 { 0x005a, {1, {0x007a}}},
 { 0x00b5, {1, {0x03bc}}},
 { 0x00c0, {1, {0x00e0}}},
 { 0x00c1, {1, {0x00e1}}},
 { 0x00c2, {1, {0x00e2}}},
 { 0x00c3, {1, {0x00e3}}},
 { 0x00c4, {1, {0x00e4}}},
 { 0x00c5, {1, {0x00e5}}},
 { 0x00c6, {1, {0x00e6}}},
 { 0x00c7, {1, {0x00e7}}},
 { 0x00c8, {1, {0x00e8}}},
 { 0x00c9, {1, {0x00e9}}},
 { 0x00ca, {1, {0x00ea}}},
 { 0x00cb, {1, {0x00eb}}},
 { 0x00cc, {1, {0x00ec}}},
 { 0x00cd, {1, {0x00ed}}},
 { 0x00ce, {1, {0x00ee}}},
 { 0x00cf, {1, {0x00ef}}},
 { 0x00d0, {1, {0x00f0}}},
 { 0x00d1, {1, {0x00f1}}},
 { 0x00d2, {1, {0x00f2}}},
 { 0x00d3, {1, {0x00f3}}},
 { 0x00d4, {1, {0x00f4}}},
 { 0x00d5, {1, {0x00f5}}},
 { 0x00d6, {1, {0x00f6}}},
 { 0x00d8, {1, {0x00f8}}},
 { 0x00d9, {1, {0x00f9}}},
 { 0x00da, {1, {0x00fa}}},
 { 0x00db, {1, {0x00fb}}},
 { 0x00dc, {1, {0x00fc}}},
 { 0x00dd, {1, {0x00fd}}},
 { 0x00de, {1, {0x00fe}}},
 { 0x00df, {2, {0x0073, 0x0073}}},
 { 0x0100, {1, {0x0101}}},
 { 0x0102, {1, {0x0103}}},
 { 0x0104, {1, {0x0105}}},
 { 0x0106, {1, {0x0107}}},
 { 0x0108, {1, {0x0109}}},
 { 0x010a, {1, {0x010b}}},
 { 0x010c, {1, {0x010d}}},
 { 0x010e, {1, {0x010f}}},
 { 0x0110, {1, {0x0111}}},
 { 0x0112, {1, {0x0113}}},
 { 0x0114, {1, {0x0115}}},
 { 0x0116, {1, {0x0117}}},
 { 0x0118, {1, {0x0119}}},
 { 0x011a, {1, {0x011b}}},
 { 0x011c, {1, {0x011d}}},
 { 0x011e, {1, {0x011f}}},
 { 0x0120, {1, {0x0121}}},
 { 0x0122, {1, {0x0123}}},
 { 0x0124, {1, {0x0125}}},
 { 0x0126, {1, {0x0127}}},
 { 0x0128, {1, {0x0129}}},
 { 0x012a, {1, {0x012b}}},
 { 0x012c, {1, {0x012d}}},
 { 0x012e, {1, {0x012f}}},
 { 0x0132, {1, {0x0133}}},
 { 0x0134, {1, {0x0135}}},
 { 0x0136, {1, {0x0137}}},
 { 0x0139, {1, {0x013a}}},
 { 0x013b, {1, {0x013c}}},
 { 0x013d, {1, {0x013e}}},
 { 0x013f, {1, {0x0140}}},
 { 0x0141, {1, {0x0142}}},
 { 0x0143, {1, {0x0144}}},
 { 0x0145, {1, {0x0146}}},
 { 0x0147, {1, {0x0148}}},
 { 0x0149, {2, {0x02bc, 0x006e}}},
 { 0x014a, {1, {0x014b}}},
 { 0x014c, {1, {0x014d}}},
 { 0x014e, {1, {0x014f}}},
 { 0x0150, {1, {0x0151}}},
 { 0x0152, {1, {0x0153}}},
 { 0x0154, {1, {0x0155}}},
 { 0x0156, {1, {0x0157}}},
 { 0x0158, {1, {0x0159}}},
 { 0x015a, {1, {0x015b}}},
 { 0x015c, {1, {0x015d}}},
 { 0x015e, {1, {0x015f}}},
 { 0x0160, {1, {0x0161}}},
 { 0x0162, {1, {0x0163}}},
 { 0x0164, {1, {0x0165}}},
 { 0x0166, {1, {0x0167}}},
 { 0x0168, {1, {0x0169}}},
 { 0x016a, {1, {0x016b}}},
 { 0x016c, {1, {0x016d}}},
 { 0x016e, {1, {0x016f}}},
 { 0x0170, {1, {0x0171}}},
 { 0x0172, {1, {0x0173}}},
 { 0x0174, {1, {0x0175}}},
 { 0x0176, {1, {0x0177}}},
 { 0x0178, {1, {0x00ff}}},
 { 0x0179, {1, {0x017a}}},
 { 0x017b, {1, {0x017c}}},
 { 0x017d, {1, {0x017e}}},
 { 0x017f, {1, {0x0073}}},
 { 0x0181, {1, {0x0253}}},
 { 0x0182, {1, {0x0183}}},
 { 0x0184, {1, {0x0185}}},
 { 0x0186, {1, {0x0254}}},
 { 0x0187, {1, {0x0188}}},
 { 0x0189, {1, {0x0256}}},
 { 0x018a, {1, {0x0257}}},
 { 0x018b, {1, {0x018c}}},
 { 0x018e, {1, {0x01dd}}},
 { 0x018f, {1, {0x0259}}},
 { 0x0190, {1, {0x025b}}},
 { 0x0191, {1, {0x0192}}},
 { 0x0193, {1, {0x0260}}},
 { 0x0194, {1, {0x0263}}},
 { 0x0196, {1, {0x0269}}},
 { 0x0197, {1, {0x0268}}},
 { 0x0198, {1, {0x0199}}},
 { 0x019c, {1, {0x026f}}},
 { 0x019d, {1, {0x0272}}},
 { 0x019f, {1, {0x0275}}},
 { 0x01a0, {1, {0x01a1}}},
 { 0x01a2, {1, {0x01a3}}},
 { 0x01a4, {1, {0x01a5}}},
 { 0x01a6, {1, {0x0280}}},
 { 0x01a7, {1, {0x01a8}}},
 { 0x01a9, {1, {0x0283}}},
 { 0x01ac, {1, {0x01ad}}},
 { 0x01ae, {1, {0x0288}}},
 { 0x01af, {1, {0x01b0}}},
 { 0x01b1, {1, {0x028a}}},
 { 0x01b2, {1, {0x028b}}},
 { 0x01b3, {1, {0x01b4}}},
 { 0x01b5, {1, {0x01b6}}},
 { 0x01b7, {1, {0x0292}}},
 { 0x01b8, {1, {0x01b9}}},
 { 0x01bc, {1, {0x01bd}}},
 { 0x01c4, {1, {0x01c6}}},
 { 0x01c5, {1, {0x01c6}}},
 { 0x01c7, {1, {0x01c9}}},
 { 0x01c8, {1, {0x01c9}}},
 { 0x01ca, {1, {0x01cc}}},
 { 0x01cb, {1, {0x01cc}}},
 { 0x01cd, {1, {0x01ce}}},
 { 0x01cf, {1, {0x01d0}}},
 { 0x01d1, {1, {0x01d2}}},
 { 0x01d3, {1, {0x01d4}}},
 { 0x01d5, {1, {0x01d6}}},
 { 0x01d7, {1, {0x01d8}}},
 { 0x01d9, {1, {0x01da}}},
 { 0x01db, {1, {0x01dc}}},
 { 0x01de, {1, {0x01df}}},
 { 0x01e0, {1, {0x01e1}}},
 { 0x01e2, {1, {0x01e3}}},
 { 0x01e4, {1, {0x01e5}}},
 { 0x01e6, {1, {0x01e7}}},
 { 0x01e8, {1, {0x01e9}}},
 { 0x01ea, {1, {0x01eb}}},
 { 0x01ec, {1, {0x01ed}}},
 { 0x01ee, {1, {0x01ef}}},
 { 0x01f0, {2, {0x006a, 0x030c}}},
 { 0x01f1, {1, {0x01f3}}},
 { 0x01f2, {1, {0x01f3}}},
 { 0x01f4, {1, {0x01f5}}},
 { 0x01f6, {1, {0x0195}}},
 { 0x01f7, {1, {0x01bf}}},
 { 0x01f8, {1, {0x01f9}}},
 { 0x01fa, {1, {0x01fb}}},
 { 0x01fc, {1, {0x01fd}}},
 { 0x01fe, {1, {0x01ff}}},
 { 0x0200, {1, {0x0201}}},
 { 0x0202, {1, {0x0203}}},
 { 0x0204, {1, {0x0205}}},
 { 0x0206, {1, {0x0207}}},
 { 0x0208, {1, {0x0209}}},
 { 0x020a, {1, {0x020b}}},
 { 0x020c, {1, {0x020d}}},
 { 0x020e, {1, {0x020f}}},
 { 0x0210, {1, {0x0211}}},
 { 0x0212, {1, {0x0213}}},
 { 0x0214, {1, {0x0215}}},
 { 0x0216, {1, {0x0217}}},
 { 0x0218, {1, {0x0219}}},
 { 0x021a, {1, {0x021b}}},
 { 0x021c, {1, {0x021d}}},
 { 0x021e, {1, {0x021f}}},
 { 0x0220, {1, {0x019e}}},
 { 0x0222, {1, {0x0223}}},
 { 0x0224, {1, {0x0225}}},
 { 0x0226, {1, {0x0227}}},
 { 0x0228, {1, {0x0229}}},
 { 0x022a, {1, {0x022b}}},
 { 0x022c, {1, {0x022d}}},
 { 0x022e, {1, {0x022f}}},
 { 0x0230, {1, {0x0231}}},
 { 0x0232, {1, {0x0233}}},
 { 0x023b, {1, {0x023c}}},
 { 0x023d, {1, {0x019a}}},
 { 0x0241, {1, {0x0294}}},
 { 0x0345, {1, {0x03b9}}},
 { 0x0386, {1, {0x03ac}}},
 { 0x0388, {1, {0x03ad}}},
 { 0x0389, {1, {0x03ae}}},
 { 0x038a, {1, {0x03af}}},
 { 0x038c, {1, {0x03cc}}},
 { 0x038e, {1, {0x03cd}}},
 { 0x038f, {1, {0x03ce}}},
 { 0x0390, {3, {0x03b9, 0x0308, 0x0301}}},
 { 0x0391, {1, {0x03b1}}},
 { 0x0392, {1, {0x03b2}}},
 { 0x0393, {1, {0x03b3}}},
 { 0x0394, {1, {0x03b4}}},
 { 0x0395, {1, {0x03b5}}},
 { 0x0396, {1, {0x03b6}}},
 { 0x0397, {1, {0x03b7}}},
 { 0x0398, {1, {0x03b8}}},
 { 0x0399, {1, {0x03b9}}},
 { 0x039a, {1, {0x03ba}}},
 { 0x039b, {1, {0x03bb}}},
 { 0x039c, {1, {0x03bc}}},
 { 0x039d, {1, {0x03bd}}},
 { 0x039e, {1, {0x03be}}},
 { 0x039f, {1, {0x03bf}}},
 { 0x03a0, {1, {0x03c0}}},
 { 0x03a1, {1, {0x03c1}}},
 { 0x03a3, {1, {0x03c3}}},
 { 0x03a4, {1, {0x03c4}}},
 { 0x03a5, {1, {0x03c5}}},
 { 0x03a6, {1, {0x03c6}}},
 { 0x03a7, {1, {0x03c7}}},
 { 0x03a8, {1, {0x03c8}}},
 { 0x03a9, {1, {0x03c9}}},
 { 0x03aa, {1, {0x03ca}}},
 { 0x03ab, {1, {0x03cb}}},
 { 0x03b0, {3, {0x03c5, 0x0308, 0x0301}}},
 { 0x03c2, {1, {0x03c3}}},
 { 0x03d0, {1, {0x03b2}}},
 { 0x03d1, {1, {0x03b8}}},
 { 0x03d5, {1, {0x03c6}}},
 { 0x03d6, {1, {0x03c0}}},
 { 0x03d8, {1, {0x03d9}}},
 { 0x03da, {1, {0x03db}}},
 { 0x03dc, {1, {0x03dd}}},
 { 0x03de, {1, {0x03df}}},
 { 0x03e0, {1, {0x03e1}}},
 { 0x03e2, {1, {0x03e3}}},
 { 0x03e4, {1, {0x03e5}}},
 { 0x03e6, {1, {0x03e7}}},
 { 0x03e8, {1, {0x03e9}}},
 { 0x03ea, {1, {0x03eb}}},
 { 0x03ec, {1, {0x03ed}}},
 { 0x03ee, {1, {0x03ef}}},
 { 0x03f0, {1, {0x03ba}}},
 { 0x03f1, {1, {0x03c1}}},
 { 0x03f4, {1, {0x03b8}}},
 { 0x03f5, {1, {0x03b5}}},
 { 0x03f7, {1, {0x03f8}}},
 { 0x03f9, {1, {0x03f2}}},
 { 0x03fa, {1, {0x03fb}}},
 { 0x0400, {1, {0x0450}}},
 { 0x0401, {1, {0x0451}}},
 { 0x0402, {1, {0x0452}}},
 { 0x0403, {1, {0x0453}}},
 { 0x0404, {1, {0x0454}}},
 { 0x0405, {1, {0x0455}}},
 { 0x0406, {1, {0x0456}}},
 { 0x0407, {1, {0x0457}}},
 { 0x0408, {1, {0x0458}}},
 { 0x0409, {1, {0x0459}}},
 { 0x040a, {1, {0x045a}}},
 { 0x040b, {1, {0x045b}}},
 { 0x040c, {1, {0x045c}}},
 { 0x040d, {1, {0x045d}}},
 { 0x040e, {1, {0x045e}}},
 { 0x040f, {1, {0x045f}}},
 { 0x0410, {1, {0x0430}}},
 { 0x0411, {1, {0x0431}}},
 { 0x0412, {1, {0x0432}}},
 { 0x0413, {1, {0x0433}}},
 { 0x0414, {1, {0x0434}}},
 { 0x0415, {1, {0x0435}}},
 { 0x0416, {1, {0x0436}}},
 { 0x0417, {1, {0x0437}}},
 { 0x0418, {1, {0x0438}}},
 { 0x0419, {1, {0x0439}}},
 { 0x041a, {1, {0x043a}}},
 { 0x041b, {1, {0x043b}}},
 { 0x041c, {1, {0x043c}}},
 { 0x041d, {1, {0x043d}}},
 { 0x041e, {1, {0x043e}}},
 { 0x041f, {1, {0x043f}}},
 { 0x0420, {1, {0x0440}}},
 { 0x0421, {1, {0x0441}}},
 { 0x0422, {1, {0x0442}}},
 { 0x0423, {1, {0x0443}}},
 { 0x0424, {1, {0x0444}}},
 { 0x0425, {1, {0x0445}}},
 { 0x0426, {1, {0x0446}}},
 { 0x0427, {1, {0x0447}}},
 { 0x0428, {1, {0x0448}}},
 { 0x0429, {1, {0x0449}}},
 { 0x042a, {1, {0x044a}}},
 { 0x042b, {1, {0x044b}}},
 { 0x042c, {1, {0x044c}}},
 { 0x042d, {1, {0x044d}}},
 { 0x042e, {1, {0x044e}}},
 { 0x042f, {1, {0x044f}}},
 { 0x0460, {1, {0x0461}}},
 { 0x0462, {1, {0x0463}}},
 { 0x0464, {1, {0x0465}}},
 { 0x0466, {1, {0x0467}}},
 { 0x0468, {1, {0x0469}}},
 { 0x046a, {1, {0x046b}}},
 { 0x046c, {1, {0x046d}}},
 { 0x046e, {1, {0x046f}}},
 { 0x0470, {1, {0x0471}}},
 { 0x0472, {1, {0x0473}}},
 { 0x0474, {1, {0x0475}}},
 { 0x0476, {1, {0x0477}}},
 { 0x0478, {1, {0x0479}}},
 { 0x047a, {1, {0x047b}}},
 { 0x047c, {1, {0x047d}}},
 { 0x047e, {1, {0x047f}}},
 { 0x0480, {1, {0x0481}}},
 { 0x048a, {1, {0x048b}}},
 { 0x048c, {1, {0x048d}}},
 { 0x048e, {1, {0x048f}}},
 { 0x0490, {1, {0x0491}}},
 { 0x0492, {1, {0x0493}}},
 { 0x0494, {1, {0x0495}}},
 { 0x0496, {1, {0x0497}}},
 { 0x0498, {1, {0x0499}}},
 { 0x049a, {1, {0x049b}}},
 { 0x049c, {1, {0x049d}}},
 { 0x049e, {1, {0x049f}}},
 { 0x04a0, {1, {0x04a1}}},
 { 0x04a2, {1, {0x04a3}}},
 { 0x04a4, {1, {0x04a5}}},
 { 0x04a6, {1, {0x04a7}}},
 { 0x04a8, {1, {0x04a9}}},
 { 0x04aa, {1, {0x04ab}}},
 { 0x04ac, {1, {0x04ad}}},
 { 0x04ae, {1, {0x04af}}},
 { 0x04b0, {1, {0x04b1}}},
 { 0x04b2, {1, {0x04b3}}},
 { 0x04b4, {1, {0x04b5}}},
 { 0x04b6, {1, {0x04b7}}},
 { 0x04b8, {1, {0x04b9}}},
 { 0x04ba, {1, {0x04bb}}},
 { 0x04bc, {1, {0x04bd}}},
 { 0x04be, {1, {0x04bf}}},
 { 0x04c1, {1, {0x04c2}}},
 { 0x04c3, {1, {0x04c4}}},
 { 0x04c5, {1, {0x04c6}}},
 { 0x04c7, {1, {0x04c8}}},
 { 0x04c9, {1, {0x04ca}}},
 { 0x04cb, {1, {0x04cc}}},
 { 0x04cd, {1, {0x04ce}}},
 { 0x04d0, {1, {0x04d1}}},
 { 0x04d2, {1, {0x04d3}}},
 { 0x04d4, {1, {0x04d5}}},
 { 0x04d6, {1, {0x04d7}}},
 { 0x04d8, {1, {0x04d9}}},
 { 0x04da, {1, {0x04db}}},
 { 0x04dc, {1, {0x04dd}}},
 { 0x04de, {1, {0x04df}}},
 { 0x04e0, {1, {0x04e1}}},
 { 0x04e2, {1, {0x04e3}}},
 { 0x04e4, {1, {0x04e5}}},
 { 0x04e6, {1, {0x04e7}}},
 { 0x04e8, {1, {0x04e9}}},
 { 0x04ea, {1, {0x04eb}}},
 { 0x04ec, {1, {0x04ed}}},
 { 0x04ee, {1, {0x04ef}}},
 { 0x04f0, {1, {0x04f1}}},
 { 0x04f2, {1, {0x04f3}}},
 { 0x04f4, {1, {0x04f5}}},
 { 0x04f6, {1, {0x04f7}}},
 { 0x04f8, {1, {0x04f9}}},
 { 0x0500, {1, {0x0501}}},
 { 0x0502, {1, {0x0503}}},
 { 0x0504, {1, {0x0505}}},
 { 0x0506, {1, {0x0507}}},
 { 0x0508, {1, {0x0509}}},
 { 0x050a, {1, {0x050b}}},
 { 0x050c, {1, {0x050d}}},
 { 0x050e, {1, {0x050f}}},
 { 0x0531, {1, {0x0561}}},
 { 0x0532, {1, {0x0562}}},
 { 0x0533, {1, {0x0563}}},
 { 0x0534, {1, {0x0564}}},
 { 0x0535, {1, {0x0565}}},
 { 0x0536, {1, {0x0566}}},
 { 0x0537, {1, {0x0567}}},
 { 0x0538, {1, {0x0568}}},
 { 0x0539, {1, {0x0569}}},
 { 0x053a, {1, {0x056a}}},
 { 0x053b, {1, {0x056b}}},
 { 0x053c, {1, {0x056c}}},
 { 0x053d, {1, {0x056d}}},
 { 0x053e, {1, {0x056e}}},
 { 0x053f, {1, {0x056f}}},
 { 0x0540, {1, {0x0570}}},
 { 0x0541, {1, {0x0571}}},
 { 0x0542, {1, {0x0572}}},
 { 0x0543, {1, {0x0573}}},
 { 0x0544, {1, {0x0574}}},
 { 0x0545, {1, {0x0575}}},
 { 0x0546, {1, {0x0576}}},
 { 0x0547, {1, {0x0577}}},
 { 0x0548, {1, {0x0578}}},
 { 0x0549, {1, {0x0579}}},
 { 0x054a, {1, {0x057a}}},
 { 0x054b, {1, {0x057b}}},
 { 0x054c, {1, {0x057c}}},
 { 0x054d, {1, {0x057d}}},
 { 0x054e, {1, {0x057e}}},
 { 0x054f, {1, {0x057f}}},
 { 0x0550, {1, {0x0580}}},
 { 0x0551, {1, {0x0581}}},
 { 0x0552, {1, {0x0582}}},
 { 0x0553, {1, {0x0583}}},
 { 0x0554, {1, {0x0584}}},
 { 0x0555, {1, {0x0585}}},
 { 0x0556, {1, {0x0586}}},
 { 0x0587, {2, {0x0565, 0x0582}}},
 { 0x10a0, {1, {0x2d00}}},
 { 0x10a1, {1, {0x2d01}}},
 { 0x10a2, {1, {0x2d02}}},
 { 0x10a3, {1, {0x2d03}}},
 { 0x10a4, {1, {0x2d04}}},
 { 0x10a5, {1, {0x2d05}}},
 { 0x10a6, {1, {0x2d06}}},
 { 0x10a7, {1, {0x2d07}}},
 { 0x10a8, {1, {0x2d08}}},
 { 0x10a9, {1, {0x2d09}}},
 { 0x10aa, {1, {0x2d0a}}},
 { 0x10ab, {1, {0x2d0b}}},
 { 0x10ac, {1, {0x2d0c}}},
 { 0x10ad, {1, {0x2d0d}}},
 { 0x10ae, {1, {0x2d0e}}},
 { 0x10af, {1, {0x2d0f}}},
 { 0x10b0, {1, {0x2d10}}},
 { 0x10b1, {1, {0x2d11}}},
 { 0x10b2, {1, {0x2d12}}},
 { 0x10b3, {1, {0x2d13}}},
 { 0x10b4, {1, {0x2d14}}},
 { 0x10b5, {1, {0x2d15}}},
 { 0x10b6, {1, {0x2d16}}},
 { 0x10b7, {1, {0x2d17}}},
 { 0x10b8, {1, {0x2d18}}},
 { 0x10b9, {1, {0x2d19}}},
 { 0x10ba, {1, {0x2d1a}}},
 { 0x10bb, {1, {0x2d1b}}},
 { 0x10bc, {1, {0x2d1c}}},
 { 0x10bd, {1, {0x2d1d}}},
 { 0x10be, {1, {0x2d1e}}},
 { 0x10bf, {1, {0x2d1f}}},
 { 0x10c0, {1, {0x2d20}}},
 { 0x10c1, {1, {0x2d21}}},
 { 0x10c2, {1, {0x2d22}}},
 { 0x10c3, {1, {0x2d23}}},
 { 0x10c4, {1, {0x2d24}}},
 { 0x10c5, {1, {0x2d25}}},
 { 0x1e00, {1, {0x1e01}}},
 { 0x1e02, {1, {0x1e03}}},
 { 0x1e04, {1, {0x1e05}}},
 { 0x1e06, {1, {0x1e07}}},
 { 0x1e08, {1, {0x1e09}}},
 { 0x1e0a, {1, {0x1e0b}}},
 { 0x1e0c, {1, {0x1e0d}}},
 { 0x1e0e, {1, {0x1e0f}}},
 { 0x1e10, {1, {0x1e11}}},
 { 0x1e12, {1, {0x1e13}}},
 { 0x1e14, {1, {0x1e15}}},
 { 0x1e16, {1, {0x1e17}}},
 { 0x1e18, {1, {0x1e19}}},
 { 0x1e1a, {1, {0x1e1b}}},
 { 0x1e1c, {1, {0x1e1d}}},
 { 0x1e1e, {1, {0x1e1f}}},
 { 0x1e20, {1, {0x1e21}}},
 { 0x1e22, {1, {0x1e23}}},
 { 0x1e24, {1, {0x1e25}}},
 { 0x1e26, {1, {0x1e27}}},
 { 0x1e28, {1, {0x1e29}}},
 { 0x1e2a, {1, {0x1e2b}}},
 { 0x1e2c, {1, {0x1e2d}}},
 { 0x1e2e, {1, {0x1e2f}}},
 { 0x1e30, {1, {0x1e31}}},
 { 0x1e32, {1, {0x1e33}}},
 { 0x1e34, {1, {0x1e35}}},
 { 0x1e36, {1, {0x1e37}}},
 { 0x1e38, {1, {0x1e39}}},
 { 0x1e3a, {1, {0x1e3b}}},
 { 0x1e3c, {1, {0x1e3d}}},
 { 0x1e3e, {1, {0x1e3f}}},
 { 0x1e40, {1, {0x1e41}}},
 { 0x1e42, {1, {0x1e43}}},
 { 0x1e44, {1, {0x1e45}}},
 { 0x1e46, {1, {0x1e47}}},
 { 0x1e48, {1, {0x1e49}}},
 { 0x1e4a, {1, {0x1e4b}}},
 { 0x1e4c, {1, {0x1e4d}}},
 { 0x1e4e, {1, {0x1e4f}}},
 { 0x1e50, {1, {0x1e51}}},
 { 0x1e52, {1, {0x1e53}}},
 { 0x1e54, {1, {0x1e55}}},
 { 0x1e56, {1, {0x1e57}}},
 { 0x1e58, {1, {0x1e59}}},
 { 0x1e5a, {1, {0x1e5b}}},
 { 0x1e5c, {1, {0x1e5d}}},
 { 0x1e5e, {1, {0x1e5f}}},
 { 0x1e60, {1, {0x1e61}}},
 { 0x1e62, {1, {0x1e63}}},
 { 0x1e64, {1, {0x1e65}}},
 { 0x1e66, {1, {0x1e67}}},
 { 0x1e68, {1, {0x1e69}}},
 { 0x1e6a, {1, {0x1e6b}}},
 { 0x1e6c, {1, {0x1e6d}}},
 { 0x1e6e, {1, {0x1e6f}}},
 { 0x1e70, {1, {0x1e71}}},
 { 0x1e72, {1, {0x1e73}}},
 { 0x1e74, {1, {0x1e75}}},
 { 0x1e76, {1, {0x1e77}}},
 { 0x1e78, {1, {0x1e79}}},
 { 0x1e7a, {1, {0x1e7b}}},
 { 0x1e7c, {1, {0x1e7d}}},
 { 0x1e7e, {1, {0x1e7f}}},
 { 0x1e80, {1, {0x1e81}}},
 { 0x1e82, {1, {0x1e83}}},
 { 0x1e84, {1, {0x1e85}}},
 { 0x1e86, {1, {0x1e87}}},
 { 0x1e88, {1, {0x1e89}}},
 { 0x1e8a, {1, {0x1e8b}}},
 { 0x1e8c, {1, {0x1e8d}}},
 { 0x1e8e, {1, {0x1e8f}}},
 { 0x1e90, {1, {0x1e91}}},
 { 0x1e92, {1, {0x1e93}}},
 { 0x1e94, {1, {0x1e95}}},
 { 0x1e96, {2, {0x0068, 0x0331}}},
 { 0x1e97, {2, {0x0074, 0x0308}}},
 { 0x1e98, {2, {0x0077, 0x030a}}},
 { 0x1e99, {2, {0x0079, 0x030a}}},
 { 0x1e9a, {2, {0x0061, 0x02be}}},
 { 0x1e9b, {1, {0x1e61}}},
 { 0x1ea0, {1, {0x1ea1}}},
 { 0x1ea2, {1, {0x1ea3}}},
 { 0x1ea4, {1, {0x1ea5}}},
 { 0x1ea6, {1, {0x1ea7}}},
 { 0x1ea8, {1, {0x1ea9}}},
 { 0x1eaa, {1, {0x1eab}}},
 { 0x1eac, {1, {0x1ead}}},
 { 0x1eae, {1, {0x1eaf}}},
 { 0x1eb0, {1, {0x1eb1}}},
 { 0x1eb2, {1, {0x1eb3}}},
 { 0x1eb4, {1, {0x1eb5}}},
 { 0x1eb6, {1, {0x1eb7}}},
 { 0x1eb8, {1, {0x1eb9}}},
 { 0x1eba, {1, {0x1ebb}}},
 { 0x1ebc, {1, {0x1ebd}}},
 { 0x1ebe, {1, {0x1ebf}}},
 { 0x1ec0, {1, {0x1ec1}}},
 { 0x1ec2, {1, {0x1ec3}}},
 { 0x1ec4, {1, {0x1ec5}}},
 { 0x1ec6, {1, {0x1ec7}}},
 { 0x1ec8, {1, {0x1ec9}}},
 { 0x1eca, {1, {0x1ecb}}},
 { 0x1ecc, {1, {0x1ecd}}},
 { 0x1ece, {1, {0x1ecf}}},
 { 0x1ed0, {1, {0x1ed1}}},
 { 0x1ed2, {1, {0x1ed3}}},
 { 0x1ed4, {1, {0x1ed5}}},
 { 0x1ed6, {1, {0x1ed7}}},
 { 0x1ed8, {1, {0x1ed9}}},
 { 0x1eda, {1, {0x1edb}}},
 { 0x1edc, {1, {0x1edd}}},
 { 0x1ede, {1, {0x1edf}}},
 { 0x1ee0, {1, {0x1ee1}}},
 { 0x1ee2, {1, {0x1ee3}}},
 { 0x1ee4, {1, {0x1ee5}}},
 { 0x1ee6, {1, {0x1ee7}}},
 { 0x1ee8, {1, {0x1ee9}}},
 { 0x1eea, {1, {0x1eeb}}},
 { 0x1eec, {1, {0x1eed}}},
 { 0x1eee, {1, {0x1eef}}},
 { 0x1ef0, {1, {0x1ef1}}},
 { 0x1ef2, {1, {0x1ef3}}},
 { 0x1ef4, {1, {0x1ef5}}},
 { 0x1ef6, {1, {0x1ef7}}},
 { 0x1ef8, {1, {0x1ef9}}},
 { 0x1f08, {1, {0x1f00}}},
 { 0x1f09, {1, {0x1f01}}},
 { 0x1f0a, {1, {0x1f02}}},
 { 0x1f0b, {1, {0x1f03}}},
 { 0x1f0c, {1, {0x1f04}}},
 { 0x1f0d, {1, {0x1f05}}},
 { 0x1f0e, {1, {0x1f06}}},
 { 0x1f0f, {1, {0x1f07}}},
 { 0x1f18, {1, {0x1f10}}},
 { 0x1f19, {1, {0x1f11}}},
 { 0x1f1a, {1, {0x1f12}}},
 { 0x1f1b, {1, {0x1f13}}},
 { 0x1f1c, {1, {0x1f14}}},
 { 0x1f1d, {1, {0x1f15}}},
 { 0x1f28, {1, {0x1f20}}},
 { 0x1f29, {1, {0x1f21}}},
 { 0x1f2a, {1, {0x1f22}}},
 { 0x1f2b, {1, {0x1f23}}},
 { 0x1f2c, {1, {0x1f24}}},
 { 0x1f2d, {1, {0x1f25}}},
 { 0x1f2e, {1, {0x1f26}}},
 { 0x1f2f, {1, {0x1f27}}},
 { 0x1f38, {1, {0x1f30}}},
 { 0x1f39, {1, {0x1f31}}},
 { 0x1f3a, {1, {0x1f32}}},
 { 0x1f3b, {1, {0x1f33}}},
 { 0x1f3c, {1, {0x1f34}}},
 { 0x1f3d, {1, {0x1f35}}},
 { 0x1f3e, {1, {0x1f36}}},
 { 0x1f3f, {1, {0x1f37}}},
 { 0x1f48, {1, {0x1f40}}},
 { 0x1f49, {1, {0x1f41}}},
 { 0x1f4a, {1, {0x1f42}}},
 { 0x1f4b, {1, {0x1f43}}},
 { 0x1f4c, {1, {0x1f44}}},
 { 0x1f4d, {1, {0x1f45}}},
 { 0x1f50, {2, {0x03c5, 0x0313}}},
 { 0x1f52, {3, {0x03c5, 0x0313, 0x0300}}},
 { 0x1f54, {3, {0x03c5, 0x0313, 0x0301}}},
 { 0x1f56, {3, {0x03c5, 0x0313, 0x0342}}},
 { 0x1f59, {1, {0x1f51}}},
 { 0x1f5b, {1, {0x1f53}}},
 { 0x1f5d, {1, {0x1f55}}},
 { 0x1f5f, {1, {0x1f57}}},
 { 0x1f68, {1, {0x1f60}}},
 { 0x1f69, {1, {0x1f61}}},
 { 0x1f6a, {1, {0x1f62}}},
 { 0x1f6b, {1, {0x1f63}}},
 { 0x1f6c, {1, {0x1f64}}},
 { 0x1f6d, {1, {0x1f65}}},
 { 0x1f6e, {1, {0x1f66}}},
 { 0x1f6f, {1, {0x1f67}}},
 { 0x1f80, {2, {0x1f00, 0x03b9}}},
 { 0x1f81, {2, {0x1f01, 0x03b9}}},
 { 0x1f82, {2, {0x1f02, 0x03b9}}},
 { 0x1f83, {2, {0x1f03, 0x03b9}}},
 { 0x1f84, {2, {0x1f04, 0x03b9}}},
 { 0x1f85, {2, {0x1f05, 0x03b9}}},
 { 0x1f86, {2, {0x1f06, 0x03b9}}},
 { 0x1f87, {2, {0x1f07, 0x03b9}}},
 { 0x1f88, {2, {0x1f00, 0x03b9}}},
 { 0x1f89, {2, {0x1f01, 0x03b9}}},
 { 0x1f8a, {2, {0x1f02, 0x03b9}}},
 { 0x1f8b, {2, {0x1f03, 0x03b9}}},
 { 0x1f8c, {2, {0x1f04, 0x03b9}}},
 { 0x1f8d, {2, {0x1f05, 0x03b9}}},
 { 0x1f8e, {2, {0x1f06, 0x03b9}}},
 { 0x1f8f, {2, {0x1f07, 0x03b9}}},
 { 0x1f90, {2, {0x1f20, 0x03b9}}},
 { 0x1f91, {2, {0x1f21, 0x03b9}}},
 { 0x1f92, {2, {0x1f22, 0x03b9}}},
 { 0x1f93, {2, {0x1f23, 0x03b9}}},
 { 0x1f94, {2, {0x1f24, 0x03b9}}},
 { 0x1f95, {2, {0x1f25, 0x03b9}}},
 { 0x1f96, {2, {0x1f26, 0x03b9}}},
 { 0x1f97, {2, {0x1f27, 0x03b9}}},
 { 0x1f98, {2, {0x1f20, 0x03b9}}},
 { 0x1f99, {2, {0x1f21, 0x03b9}}},
 { 0x1f9a, {2, {0x1f22, 0x03b9}}},
 { 0x1f9b, {2, {0x1f23, 0x03b9}}},
 { 0x1f9c, {2, {0x1f24, 0x03b9}}},
 { 0x1f9d, {2, {0x1f25, 0x03b9}}},
 { 0x1f9e, {2, {0x1f26, 0x03b9}}},
 { 0x1f9f, {2, {0x1f27, 0x03b9}}},
 { 0x1fa0, {2, {0x1f60, 0x03b9}}},
 { 0x1fa1, {2, {0x1f61, 0x03b9}}},
 { 0x1fa2, {2, {0x1f62, 0x03b9}}},
 { 0x1fa3, {2, {0x1f63, 0x03b9}}},
 { 0x1fa4, {2, {0x1f64, 0x03b9}}},
 { 0x1fa5, {2, {0x1f65, 0x03b9}}},
 { 0x1fa6, {2, {0x1f66, 0x03b9}}},
 { 0x1fa7, {2, {0x1f67, 0x03b9}}},
 { 0x1fa8, {2, {0x1f60, 0x03b9}}},
 { 0x1fa9, {2, {0x1f61, 0x03b9}}},
 { 0x1faa, {2, {0x1f62, 0x03b9}}},
 { 0x1fab, {2, {0x1f63, 0x03b9}}},
 { 0x1fac, {2, {0x1f64, 0x03b9}}},
 { 0x1fad, {2, {0x1f65, 0x03b9}}},
 { 0x1fae, {2, {0x1f66, 0x03b9}}},
 { 0x1faf, {2, {0x1f67, 0x03b9}}},
 { 0x1fb2, {2, {0x1f70, 0x03b9}}},
 { 0x1fb3, {2, {0x03b1, 0x03b9}}},
 { 0x1fb4, {2, {0x03ac, 0x03b9}}},
 { 0x1fb6, {2, {0x03b1, 0x0342}}},
 { 0x1fb7, {3, {0x03b1, 0x0342, 0x03b9}}},
 { 0x1fb8, {1, {0x1fb0}}},
 { 0x1fb9, {1, {0x1fb1}}},
 { 0x1fba, {1, {0x1f70}}},
 { 0x1fbb, {1, {0x1f71}}},
 { 0x1fbc, {2, {0x03b1, 0x03b9}}},
 { 0x1fbe, {1, {0x03b9}}},
 { 0x1fc2, {2, {0x1f74, 0x03b9}}},
 { 0x1fc3, {2, {0x03b7, 0x03b9}}},
 { 0x1fc4, {2, {0x03ae, 0x03b9}}},
 { 0x1fc6, {2, {0x03b7, 0x0342}}},
 { 0x1fc7, {3, {0x03b7, 0x0342, 0x03b9}}},
 { 0x1fc8, {1, {0x1f72}}},
 { 0x1fc9, {1, {0x1f73}}},
 { 0x1fca, {1, {0x1f74}}},
 { 0x1fcb, {1, {0x1f75}}},
 { 0x1fcc, {2, {0x03b7, 0x03b9}}},
 { 0x1fd2, {3, {0x03b9, 0x0308, 0x0300}}},
 { 0x1fd3, {3, {0x03b9, 0x0308, 0x0301}}},
 { 0x1fd6, {2, {0x03b9, 0x0342}}},
 { 0x1fd7, {3, {0x03b9, 0x0308, 0x0342}}},
 { 0x1fd8, {1, {0x1fd0}}},
 { 0x1fd9, {1, {0x1fd1}}},
 { 0x1fda, {1, {0x1f76}}},
 { 0x1fdb, {1, {0x1f77}}},
 { 0x1fe2, {3, {0x03c5, 0x0308, 0x0300}}},
 { 0x1fe3, {3, {0x03c5, 0x0308, 0x0301}}},
 { 0x1fe4, {2, {0x03c1, 0x0313}}},
 { 0x1fe6, {2, {0x03c5, 0x0342}}},
 { 0x1fe7, {3, {0x03c5, 0x0308, 0x0342}}},
 { 0x1fe8, {1, {0x1fe0}}},
 { 0x1fe9, {1, {0x1fe1}}},
 { 0x1fea, {1, {0x1f7a}}},
 { 0x1feb, {1, {0x1f7b}}},
 { 0x1fec, {1, {0x1fe5}}},
 { 0x1ff2, {2, {0x1f7c, 0x03b9}}},
 { 0x1ff3, {2, {0x03c9, 0x03b9}}},
 { 0x1ff4, {2, {0x03ce, 0x03b9}}},
 { 0x1ff6, {2, {0x03c9, 0x0342}}},
 { 0x1ff7, {3, {0x03c9, 0x0342, 0x03b9}}},
 { 0x1ff8, {1, {0x1f78}}},
 { 0x1ff9, {1, {0x1f79}}},
 { 0x1ffa, {1, {0x1f7c}}},
 { 0x1ffb, {1, {0x1f7d}}},
 { 0x1ffc, {2, {0x03c9, 0x03b9}}},
 { 0x2126, {1, {0x03c9}}},
 { 0x212a, {1, {0x006b}}},
 { 0x212b, {1, {0x00e5}}},
 { 0x2160, {1, {0x2170}}},
 { 0x2161, {1, {0x2171}}},
 { 0x2162, {1, {0x2172}}},
 { 0x2163, {1, {0x2173}}},
 { 0x2164, {1, {0x2174}}},
 { 0x2165, {1, {0x2175}}},
 { 0x2166, {1, {0x2176}}},
 { 0x2167, {1, {0x2177}}},
 { 0x2168, {1, {0x2178}}},
 { 0x2169, {1, {0x2179}}},
 { 0x216a, {1, {0x217a}}},
 { 0x216b, {1, {0x217b}}},
 { 0x216c, {1, {0x217c}}},
 { 0x216d, {1, {0x217d}}},
 { 0x216e, {1, {0x217e}}},
 { 0x216f, {1, {0x217f}}},
 { 0x24b6, {1, {0x24d0}}},
 { 0x24b7, {1, {0x24d1}}},
 { 0x24b8, {1, {0x24d2}}},
 { 0x24b9, {1, {0x24d3}}},
 { 0x24ba, {1, {0x24d4}}},
 { 0x24bb, {1, {0x24d5}}},
 { 0x24bc, {1, {0x24d6}}},
 { 0x24bd, {1, {0x24d7}}},
 { 0x24be, {1, {0x24d8}}},
 { 0x24bf, {1, {0x24d9}}},
 { 0x24c0, {1, {0x24da}}},
 { 0x24c1, {1, {0x24db}}},
 { 0x24c2, {1, {0x24dc}}},
 { 0x24c3, {1, {0x24dd}}},
 { 0x24c4, {1, {0x24de}}},
 { 0x24c5, {1, {0x24df}}},
 { 0x24c6, {1, {0x24e0}}},
 { 0x24c7, {1, {0x24e1}}},
 { 0x24c8, {1, {0x24e2}}},
 { 0x24c9, {1, {0x24e3}}},
 { 0x24ca, {1, {0x24e4}}},
 { 0x24cb, {1, {0x24e5}}},
 { 0x24cc, {1, {0x24e6}}},
 { 0x24cd, {1, {0x24e7}}},
 { 0x24ce, {1, {0x24e8}}},
 { 0x24cf, {1, {0x24e9}}},
 { 0x2c00, {1, {0x2c30}}},
 { 0x2c01, {1, {0x2c31}}},
 { 0x2c02, {1, {0x2c32}}},
 { 0x2c03, {1, {0x2c33}}},
 { 0x2c04, {1, {0x2c34}}},
 { 0x2c05, {1, {0x2c35}}},
 { 0x2c06, {1, {0x2c36}}},
 { 0x2c07, {1, {0x2c37}}},
 { 0x2c08, {1, {0x2c38}}},
 { 0x2c09, {1, {0x2c39}}},
 { 0x2c0a, {1, {0x2c3a}}},
 { 0x2c0b, {1, {0x2c3b}}},
 { 0x2c0c, {1, {0x2c3c}}},
 { 0x2c0d, {1, {0x2c3d}}},
 { 0x2c0e, {1, {0x2c3e}}},
 { 0x2c0f, {1, {0x2c3f}}},
 { 0x2c10, {1, {0x2c40}}},
 { 0x2c11, {1, {0x2c41}}},
 { 0x2c12, {1, {0x2c42}}},
 { 0x2c13, {1, {0x2c43}}},
 { 0x2c14, {1, {0x2c44}}},
 { 0x2c15, {1, {0x2c45}}},
 { 0x2c16, {1, {0x2c46}}},
 { 0x2c17, {1, {0x2c47}}},
 { 0x2c18, {1, {0x2c48}}},
 { 0x2c19, {1, {0x2c49}}},
 { 0x2c1a, {1, {0x2c4a}}},
 { 0x2c1b, {1, {0x2c4b}}},
 { 0x2c1c, {1, {0x2c4c}}},
 { 0x2c1d, {1, {0x2c4d}}},
 { 0x2c1e, {1, {0x2c4e}}},
 { 0x2c1f, {1, {0x2c4f}}},
 { 0x2c20, {1, {0x2c50}}},
 { 0x2c21, {1, {0x2c51}}},
 { 0x2c22, {1, {0x2c52}}},
 { 0x2c23, {1, {0x2c53}}},
 { 0x2c24, {1, {0x2c54}}},
 { 0x2c25, {1, {0x2c55}}},
 { 0x2c26, {1, {0x2c56}}},
 { 0x2c27, {1, {0x2c57}}},
 { 0x2c28, {1, {0x2c58}}},
 { 0x2c29, {1, {0x2c59}}},
 { 0x2c2a, {1, {0x2c5a}}},
 { 0x2c2b, {1, {0x2c5b}}},
 { 0x2c2c, {1, {0x2c5c}}},
 { 0x2c2d, {1, {0x2c5d}}},
 { 0x2c2e, {1, {0x2c5e}}},
 { 0x2c80, {1, {0x2c81}}},
 { 0x2c82, {1, {0x2c83}}},
 { 0x2c84, {1, {0x2c85}}},
 { 0x2c86, {1, {0x2c87}}},
 { 0x2c88, {1, {0x2c89}}},
 { 0x2c8a, {1, {0x2c8b}}},
 { 0x2c8c, {1, {0x2c8d}}},
 { 0x2c8e, {1, {0x2c8f}}},
 { 0x2c90, {1, {0x2c91}}},
 { 0x2c92, {1, {0x2c93}}},
 { 0x2c94, {1, {0x2c95}}},
 { 0x2c96, {1, {0x2c97}}},
 { 0x2c98, {1, {0x2c99}}},
 { 0x2c9a, {1, {0x2c9b}}},
 { 0x2c9c, {1, {0x2c9d}}},
 { 0x2c9e, {1, {0x2c9f}}},
 { 0x2ca0, {1, {0x2ca1}}},
 { 0x2ca2, {1, {0x2ca3}}},
 { 0x2ca4, {1, {0x2ca5}}},
 { 0x2ca6, {1, {0x2ca7}}},
 { 0x2ca8, {1, {0x2ca9}}},
 { 0x2caa, {1, {0x2cab}}},
 { 0x2cac, {1, {0x2cad}}},
 { 0x2cae, {1, {0x2caf}}},
 { 0x2cb0, {1, {0x2cb1}}},
 { 0x2cb2, {1, {0x2cb3}}},
 { 0x2cb4, {1, {0x2cb5}}},
 { 0x2cb6, {1, {0x2cb7}}},
 { 0x2cb8, {1, {0x2cb9}}},
 { 0x2cba, {1, {0x2cbb}}},
 { 0x2cbc, {1, {0x2cbd}}},
 { 0x2cbe, {1, {0x2cbf}}},
 { 0x2cc0, {1, {0x2cc1}}},
 { 0x2cc2, {1, {0x2cc3}}},
 { 0x2cc4, {1, {0x2cc5}}},
 { 0x2cc6, {1, {0x2cc7}}},
 { 0x2cc8, {1, {0x2cc9}}},
 { 0x2cca, {1, {0x2ccb}}},
 { 0x2ccc, {1, {0x2ccd}}},
 { 0x2cce, {1, {0x2ccf}}},
 { 0x2cd0, {1, {0x2cd1}}},
 { 0x2cd2, {1, {0x2cd3}}},
 { 0x2cd4, {1, {0x2cd5}}},
 { 0x2cd6, {1, {0x2cd7}}},
 { 0x2cd8, {1, {0x2cd9}}},
 { 0x2cda, {1, {0x2cdb}}},
 { 0x2cdc, {1, {0x2cdd}}},
 { 0x2cde, {1, {0x2cdf}}},
 { 0x2ce0, {1, {0x2ce1}}},
 { 0x2ce2, {1, {0x2ce3}}},
 { 0xfb00, {2, {0x0066, 0x0066}}},
 { 0xfb01, {2, {0x0066, 0x0069}}},
 { 0xfb02, {2, {0x0066, 0x006c}}},
 { 0xfb03, {3, {0x0066, 0x0066, 0x0069}}},
 { 0xfb04, {3, {0x0066, 0x0066, 0x006c}}},
 { 0xfb05, {2, {0x0073, 0x0074}}},
 { 0xfb06, {2, {0x0073, 0x0074}}},
 { 0xfb13, {2, {0x0574, 0x0576}}},
 { 0xfb14, {2, {0x0574, 0x0565}}},
 { 0xfb15, {2, {0x0574, 0x056b}}},
 { 0xfb16, {2, {0x057e, 0x0576}}},
 { 0xfb17, {2, {0x0574, 0x056d}}},
 { 0xff21, {1, {0xff41}}},
 { 0xff22, {1, {0xff42}}},
 { 0xff23, {1, {0xff43}}},
 { 0xff24, {1, {0xff44}}},
 { 0xff25, {1, {0xff45}}},
 { 0xff26, {1, {0xff46}}},
 { 0xff27, {1, {0xff47}}},
 { 0xff28, {1, {0xff48}}},
 { 0xff29, {1, {0xff49}}},
 { 0xff2a, {1, {0xff4a}}},
 { 0xff2b, {1, {0xff4b}}},
 { 0xff2c, {1, {0xff4c}}},
 { 0xff2d, {1, {0xff4d}}},
 { 0xff2e, {1, {0xff4e}}},
 { 0xff2f, {1, {0xff4f}}},
 { 0xff30, {1, {0xff50}}},
 { 0xff31, {1, {0xff51}}},
 { 0xff32, {1, {0xff52}}},
 { 0xff33, {1, {0xff53}}},
 { 0xff34, {1, {0xff54}}},
 { 0xff35, {1, {0xff55}}},
 { 0xff36, {1, {0xff56}}},
 { 0xff37, {1, {0xff57}}},
 { 0xff38, {1, {0xff58}}},
 { 0xff39, {1, {0xff59}}},
 { 0xff3a, {1, {0xff5a}}},
 { 0x10400, {1, {0x10428}}},
 { 0x10401, {1, {0x10429}}},
 { 0x10402, {1, {0x1042a}}},
 { 0x10403, {1, {0x1042b}}},
 { 0x10404, {1, {0x1042c}}},
 { 0x10405, {1, {0x1042d}}},
 { 0x10406, {1, {0x1042e}}},
 { 0x10407, {1, {0x1042f}}},
 { 0x10408, {1, {0x10430}}},
 { 0x10409, {1, {0x10431}}},
 { 0x1040a, {1, {0x10432}}},
 { 0x1040b, {1, {0x10433}}},
 { 0x1040c, {1, {0x10434}}},
 { 0x1040d, {1, {0x10435}}},
 { 0x1040e, {1, {0x10436}}},
 { 0x1040f, {1, {0x10437}}},
 { 0x10410, {1, {0x10438}}},
 { 0x10411, {1, {0x10439}}},
 { 0x10412, {1, {0x1043a}}},
 { 0x10413, {1, {0x1043b}}},
 { 0x10414, {1, {0x1043c}}},
 { 0x10415, {1, {0x1043d}}},
 { 0x10416, {1, {0x1043e}}},
 { 0x10417, {1, {0x1043f}}},
 { 0x10418, {1, {0x10440}}},
 { 0x10419, {1, {0x10441}}},
 { 0x1041a, {1, {0x10442}}},
 { 0x1041b, {1, {0x10443}}},
 { 0x1041c, {1, {0x10444}}},
 { 0x1041d, {1, {0x10445}}},
 { 0x1041e, {1, {0x10446}}},
 { 0x1041f, {1, {0x10447}}},
 { 0x10420, {1, {0x10448}}},
 { 0x10421, {1, {0x10449}}},
 { 0x10422, {1, {0x1044a}}},
 { 0x10423, {1, {0x1044b}}},
 { 0x10424, {1, {0x1044c}}},
 { 0x10425, {1, {0x1044d}}},
 { 0x10426, {1, {0x1044e}}},
 { 0x10427, {1, {0x1044f}}}
};

static const CaseFold_11_Type CaseFold_Locale[] = {
 { 0x0049, {1, {0x0069}}},
 { 0x0130, {2, {0x0069, 0x0307}}}
};

static const CaseUnfold_11_Type CaseUnfold_11[] = {
 { 0x0061, {1, {0x0041 }}},
 { 0x0062, {1, {0x0042 }}},
 { 0x0063, {1, {0x0043 }}},
 { 0x0064, {1, {0x0044 }}},
 { 0x0065, {1, {0x0045 }}},
 { 0x0066, {1, {0x0046 }}},
 { 0x0067, {1, {0x0047 }}},
 { 0x0068, {1, {0x0048 }}},
 { 0x006a, {1, {0x004a }}},
 { 0x006b, {2, {0x212a, 0x004b }}},
 { 0x006c, {1, {0x004c }}},
 { 0x006d, {1, {0x004d }}},
 { 0x006e, {1, {0x004e }}},
 { 0x006f, {1, {0x004f }}},
 { 0x0070, {1, {0x0050 }}},
 { 0x0071, {1, {0x0051 }}},
 { 0x0072, {1, {0x0052 }}},
 { 0x0073, {2, {0x0053, 0x017f }}},
 { 0x0074, {1, {0x0054 }}},
 { 0x0075, {1, {0x0055 }}},
 { 0x0076, {1, {0x0056 }}},
 { 0x0077, {1, {0x0057 }}},
 { 0x0078, {1, {0x0058 }}},
 { 0x0079, {1, {0x0059 }}},
 { 0x007a, {1, {0x005a }}},
 { 0x00e0, {1, {0x00c0 }}},
 { 0x00e1, {1, {0x00c1 }}},
 { 0x00e2, {1, {0x00c2 }}},
 { 0x00e3, {1, {0x00c3 }}},
 { 0x00e4, {1, {0x00c4 }}},
 { 0x00e5, {2, {0x212b, 0x00c5 }}},
 { 0x00e6, {1, {0x00c6 }}},
 { 0x00e7, {1, {0x00c7 }}},
 { 0x00e8, {1, {0x00c8 }}},
 { 0x00e9, {1, {0x00c9 }}},
 { 0x00ea, {1, {0x00ca }}},
 { 0x00eb, {1, {0x00cb }}},
 { 0x00ec, {1, {0x00cc }}},
 { 0x00ed, {1, {0x00cd }}},
 { 0x00ee, {1, {0x00ce }}},
 { 0x00ef, {1, {0x00cf }}},
 { 0x00f0, {1, {0x00d0 }}},
 { 0x00f1, {1, {0x00d1 }}},
 { 0x00f2, {1, {0x00d2 }}},
 { 0x00f3, {1, {0x00d3 }}},
 { 0x00f4, {1, {0x00d4 }}},
 { 0x00f5, {1, {0x00d5 }}},
 { 0x00f6, {1, {0x00d6 }}},
 { 0x00f8, {1, {0x00d8 }}},
 { 0x00f9, {1, {0x00d9 }}},
 { 0x00fa, {1, {0x00da }}},
 { 0x00fb, {1, {0x00db }}},
 { 0x00fc, {1, {0x00dc }}},
 { 0x00fd, {1, {0x00dd }}},
 { 0x00fe, {1, {0x00de }}},
 { 0x00ff, {1, {0x0178 }}},
 { 0x0101, {1, {0x0100 }}},
 { 0x0103, {1, {0x0102 }}},
 { 0x0105, {1, {0x0104 }}},
 { 0x0107, {1, {0x0106 }}},
 { 0x0109, {1, {0x0108 }}},
 { 0x010b, {1, {0x010a }}},
 { 0x010d, {1, {0x010c }}},
 { 0x010f, {1, {0x010e }}},
 { 0x0111, {1, {0x0110 }}},
 { 0x0113, {1, {0x0112 }}},
 { 0x0115, {1, {0x0114 }}},
 { 0x0117, {1, {0x0116 }}},
 { 0x0119, {1, {0x0118 }}},
 { 0x011b, {1, {0x011a }}},
 { 0x011d, {1, {0x011c }}},
 { 0x011f, {1, {0x011e }}},
 { 0x0121, {1, {0x0120 }}},
 { 0x0123, {1, {0x0122 }}},
 { 0x0125, {1, {0x0124 }}},
 { 0x0127, {1, {0x0126 }}},
 { 0x0129, {1, {0x0128 }}},
 { 0x012b, {1, {0x012a }}},
 { 0x012d, {1, {0x012c }}},
 { 0x012f, {1, {0x012e }}},
 { 0x0133, {1, {0x0132 }}},
 { 0x0135, {1, {0x0134 }}},
 { 0x0137, {1, {0x0136 }}},
 { 0x013a, {1, {0x0139 }}},
 { 0x013c, {1, {0x013b }}},
 { 0x013e, {1, {0x013d }}},
 { 0x0140, {1, {0x013f }}},
 { 0x0142, {1, {0x0141 }}},
 { 0x0144, {1, {0x0143 }}},
 { 0x0146, {1, {0x0145 }}},
 { 0x0148, {1, {0x0147 }}},
 { 0x014b, {1, {0x014a }}},
 { 0x014d, {1, {0x014c }}},
 { 0x014f, {1, {0x014e }}},
 { 0x0151, {1, {0x0150 }}},
 { 0x0153, {1, {0x0152 }}},
 { 0x0155, {1, {0x0154 }}},
 { 0x0157, {1, {0x0156 }}},
 { 0x0159, {1, {0x0158 }}},
 { 0x015b, {1, {0x015a }}},
 { 0x015d, {1, {0x015c }}},
 { 0x015f, {1, {0x015e }}},
 { 0x0161, {1, {0x0160 }}},
 { 0x0163, {1, {0x0162 }}},
 { 0x0165, {1, {0x0164 }}},
 { 0x0167, {1, {0x0166 }}},
 { 0x0169, {1, {0x0168 }}},
 { 0x016b, {1, {0x016a }}},
 { 0x016d, {1, {0x016c }}},
 { 0x016f, {1, {0x016e }}},
 { 0x0171, {1, {0x0170 }}},
 { 0x0173, {1, {0x0172 }}},
 { 0x0175, {1, {0x0174 }}},
 { 0x0177, {1, {0x0176 }}},
 { 0x017a, {1, {0x0179 }}},
 { 0x017c, {1, {0x017b }}},
 { 0x017e, {1, {0x017d }}},
 { 0x0183, {1, {0x0182 }}},
 { 0x0185, {1, {0x0184 }}},
 { 0x0188, {1, {0x0187 }}},
 { 0x018c, {1, {0x018b }}},
 { 0x0192, {1, {0x0191 }}},
 { 0x0195, {1, {0x01f6 }}},
 { 0x0199, {1, {0x0198 }}},
 { 0x019a, {1, {0x023d }}},
 { 0x019e, {1, {0x0220 }}},
 { 0x01a1, {1, {0x01a0 }}},
 { 0x01a3, {1, {0x01a2 }}},
 { 0x01a5, {1, {0x01a4 }}},
 { 0x01a8, {1, {0x01a7 }}},
 { 0x01ad, {1, {0x01ac }}},
 { 0x01b0, {1, {0x01af }}},
 { 0x01b4, {1, {0x01b3 }}},
 { 0x01b6, {1, {0x01b5 }}},
 { 0x01b9, {1, {0x01b8 }}},
 { 0x01bd, {1, {0x01bc }}},
 { 0x01bf, {1, {0x01f7 }}},
 { 0x01c6, {2, {0x01c4, 0x01c5 }}},
 { 0x01c9, {2, {0x01c7, 0x01c8 }}},
 { 0x01cc, {2, {0x01ca, 0x01cb }}},
 { 0x01ce, {1, {0x01cd }}},
 { 0x01d0, {1, {0x01cf }}},
 { 0x01d2, {1, {0x01d1 }}},
 { 0x01d4, {1, {0x01d3 }}},
 { 0x01d6, {1, {0x01d5 }}},
 { 0x01d8, {1, {0x01d7 }}},
 { 0x01da, {1, {0x01d9 }}},
 { 0x01dc, {1, {0x01db }}},
 { 0x01dd, {1, {0x018e }}},
 { 0x01df, {1, {0x01de }}},
 { 0x01e1, {1, {0x01e0 }}},
 { 0x01e3, {1, {0x01e2 }}},
 { 0x01e5, {1, {0x01e4 }}},
 { 0x01e7, {1, {0x01e6 }}},
 { 0x01e9, {1, {0x01e8 }}},
 { 0x01eb, {1, {0x01ea }}},
 { 0x01ed, {1, {0x01ec }}},
 { 0x01ef, {1, {0x01ee }}},
 { 0x01f3, {2, {0x01f1, 0x01f2 }}},
 { 0x01f5, {1, {0x01f4 }}},
 { 0x01f9, {1, {0x01f8 }}},
 { 0x01fb, {1, {0x01fa }}},
 { 0x01fd, {1, {0x01fc }}},
 { 0x01ff, {1, {0x01fe }}},
 { 0x0201, {1, {0x0200 }}},
 { 0x0203, {1, {0x0202 }}},
 { 0x0205, {1, {0x0204 }}},
 { 0x0207, {1, {0x0206 }}},
 { 0x0209, {1, {0x0208 }}},
 { 0x020b, {1, {0x020a }}},
 { 0x020d, {1, {0x020c }}},
 { 0x020f, {1, {0x020e }}},
 { 0x0211, {1, {0x0210 }}},
 { 0x0213, {1, {0x0212 }}},
 { 0x0215, {1, {0x0214 }}},
 { 0x0217, {1, {0x0216 }}},
 { 0x0219, {1, {0x0218 }}},
 { 0x021b, {1, {0x021a }}},
 { 0x021d, {1, {0x021c }}},
 { 0x021f, {1, {0x021e }}},
 { 0x0223, {1, {0x0222 }}},
 { 0x0225, {1, {0x0224 }}},
 { 0x0227, {1, {0x0226 }}},
 { 0x0229, {1, {0x0228 }}},
 { 0x022b, {1, {0x022a }}},
 { 0x022d, {1, {0x022c }}},
 { 0x022f, {1, {0x022e }}},
 { 0x0231, {1, {0x0230 }}},
 { 0x0233, {1, {0x0232 }}},
 { 0x023c, {1, {0x023b }}},
 { 0x0253, {1, {0x0181 }}},
 { 0x0254, {1, {0x0186 }}},
 { 0x0256, {1, {0x0189 }}},
 { 0x0257, {1, {0x018a }}},
 { 0x0259, {1, {0x018f }}},
 { 0x025b, {1, {0x0190 }}},
 { 0x0260, {1, {0x0193 }}},
 { 0x0263, {1, {0x0194 }}},
 { 0x0268, {1, {0x0197 }}},
 { 0x0269, {1, {0x0196 }}},
 { 0x026f, {1, {0x019c }}},
 { 0x0272, {1, {0x019d }}},
 { 0x0275, {1, {0x019f }}},
 { 0x0280, {1, {0x01a6 }}},
 { 0x0283, {1, {0x01a9 }}},
 { 0x0288, {1, {0x01ae }}},
 { 0x028a, {1, {0x01b1 }}},
 { 0x028b, {1, {0x01b2 }}},
 { 0x0292, {1, {0x01b7 }}},
 { 0x0294, {1, {0x0241 }}},
 { 0x03ac, {1, {0x0386 }}},
 { 0x03ad, {1, {0x0388 }}},
 { 0x03ae, {1, {0x0389 }}},
 { 0x03af, {1, {0x038a }}},
 { 0x03b1, {1, {0x0391 }}},
 { 0x03b2, {2, {0x0392, 0x03d0 }}},
 { 0x03b3, {1, {0x0393 }}},
 { 0x03b4, {1, {0x0394 }}},
 { 0x03b5, {2, {0x03f5, 0x0395 }}},
 { 0x03b6, {1, {0x0396 }}},
 { 0x03b7, {1, {0x0397 }}},
 { 0x03b8, {3, {0x03f4, 0x0398, 0x03d1 }}},
 { 0x03b9, {3, {0x1fbe, 0x0399, 0x0345 }}},
 { 0x03ba, {2, {0x03f0, 0x039a }}},
 { 0x03bb, {1, {0x039b }}},
 { 0x03bc, {2, {0x00b5, 0x039c }}},
 { 0x03bd, {1, {0x039d }}},
 { 0x03be, {1, {0x039e }}},
 { 0x03bf, {1, {0x039f }}},
 { 0x03c0, {2, {0x03a0, 0x03d6 }}},
 { 0x03c1, {2, {0x03f1, 0x03a1 }}},
 { 0x03c3, {2, {0x03a3, 0x03c2 }}},
 { 0x03c4, {1, {0x03a4 }}},
 { 0x03c5, {1, {0x03a5 }}},
 { 0x03c6, {2, {0x03a6, 0x03d5 }}},
 { 0x03c7, {1, {0x03a7 }}},
 { 0x03c8, {1, {0x03a8 }}},
 { 0x03c9, {2, {0x03a9, 0x2126 }}},
 { 0x03ca, {1, {0x03aa }}},
 { 0x03cb, {1, {0x03ab }}},
 { 0x03cc, {1, {0x038c }}},
 { 0x03cd, {1, {0x038e }}},
 { 0x03ce, {1, {0x038f }}},
 { 0x03d9, {1, {0x03d8 }}},
 { 0x03db, {1, {0x03da }}},
 { 0x03dd, {1, {0x03dc }}},
 { 0x03df, {1, {0x03de }}},
 { 0x03e1, {1, {0x03e0 }}},
 { 0x03e3, {1, {0x03e2 }}},
 { 0x03e5, {1, {0x03e4 }}},
 { 0x03e7, {1, {0x03e6 }}},
 { 0x03e9, {1, {0x03e8 }}},
 { 0x03eb, {1, {0x03ea }}},
 { 0x03ed, {1, {0x03ec }}},
 { 0x03ef, {1, {0x03ee }}},
 { 0x03f2, {1, {0x03f9 }}},
 { 0x03f8, {1, {0x03f7 }}},
 { 0x03fb, {1, {0x03fa }}},
 { 0x0430, {1, {0x0410 }}},
 { 0x0431, {1, {0x0411 }}},
 { 0x0432, {1, {0x0412 }}},
 { 0x0433, {1, {0x0413 }}},
 { 0x0434, {1, {0x0414 }}},
 { 0x0435, {1, {0x0415 }}},
 { 0x0436, {1, {0x0416 }}},
 { 0x0437, {1, {0x0417 }}},
 { 0x0438, {1, {0x0418 }}},
 { 0x0439, {1, {0x0419 }}},
 { 0x043a, {1, {0x041a }}},
 { 0x043b, {1, {0x041b }}},
 { 0x043c, {1, {0x041c }}},
 { 0x043d, {1, {0x041d }}},
 { 0x043e, {1, {0x041e }}},
 { 0x043f, {1, {0x041f }}},
 { 0x0440, {1, {0x0420 }}},
 { 0x0441, {1, {0x0421 }}},
 { 0x0442, {1, {0x0422 }}},
 { 0x0443, {1, {0x0423 }}},
 { 0x0444, {1, {0x0424 }}},
 { 0x0445, {1, {0x0425 }}},
 { 0x0446, {1, {0x0426 }}},
 { 0x0447, {1, {0x0427 }}},
 { 0x0448, {1, {0x0428 }}},
 { 0x0449, {1, {0x0429 }}},
 { 0x044a, {1, {0x042a }}},
 { 0x044b, {1, {0x042b }}},
 { 0x044c, {1, {0x042c }}},
 { 0x044d, {1, {0x042d }}},
 { 0x044e, {1, {0x042e }}},
 { 0x044f, {1, {0x042f }}},
 { 0x0450, {1, {0x0400 }}},
 { 0x0451, {1, {0x0401 }}},
 { 0x0452, {1, {0x0402 }}},
 { 0x0453, {1, {0x0403 }}},
 { 0x0454, {1, {0x0404 }}},
 { 0x0455, {1, {0x0405 }}},
 { 0x0456, {1, {0x0406 }}},
 { 0x0457, {1, {0x0407 }}},
 { 0x0458, {1, {0x0408 }}},
 { 0x0459, {1, {0x0409 }}},
 { 0x045a, {1, {0x040a }}},
 { 0x045b, {1, {0x040b }}},
 { 0x045c, {1, {0x040c }}},
 { 0x045d, {1, {0x040d }}},
 { 0x045e, {1, {0x040e }}},
 { 0x045f, {1, {0x040f }}},
 { 0x0461, {1, {0x0460 }}},
 { 0x0463, {1, {0x0462 }}},
 { 0x0465, {1, {0x0464 }}},
 { 0x0467, {1, {0x0466 }}},
 { 0x0469, {1, {0x0468 }}},
 { 0x046b, {1, {0x046a }}},
 { 0x046d, {1, {0x046c }}},
 { 0x046f, {1, {0x046e }}},
 { 0x0471, {1, {0x0470 }}},
 { 0x0473, {1, {0x0472 }}},
 { 0x0475, {1, {0x0474 }}},
 { 0x0477, {1, {0x0476 }}},
 { 0x0479, {1, {0x0478 }}},
 { 0x047b, {1, {0x047a }}},
 { 0x047d, {1, {0x047c }}},
 { 0x047f, {1, {0x047e }}},
 { 0x0481, {1, {0x0480 }}},
 { 0x048b, {1, {0x048a }}},
 { 0x048d, {1, {0x048c }}},
 { 0x048f, {1, {0x048e }}},
 { 0x0491, {1, {0x0490 }}},
 { 0x0493, {1, {0x0492 }}},
 { 0x0495, {1, {0x0494 }}},
 { 0x0497, {1, {0x0496 }}},
 { 0x0499, {1, {0x0498 }}},
 { 0x049b, {1, {0x049a }}},
 { 0x049d, {1, {0x049c }}},
 { 0x049f, {1, {0x049e }}},
 { 0x04a1, {1, {0x04a0 }}},
 { 0x04a3, {1, {0x04a2 }}},
 { 0x04a5, {1, {0x04a4 }}},
 { 0x04a7, {1, {0x04a6 }}},
 { 0x04a9, {1, {0x04a8 }}},
 { 0x04ab, {1, {0x04aa }}},
 { 0x04ad, {1, {0x04ac }}},
 { 0x04af, {1, {0x04ae }}},
 { 0x04b1, {1, {0x04b0 }}},
 { 0x04b3, {1, {0x04b2 }}},
 { 0x04b5, {1, {0x04b4 }}},
 { 0x04b7, {1, {0x04b6 }}},
 { 0x04b9, {1, {0x04b8 }}},
 { 0x04bb, {1, {0x04ba }}},
 { 0x04bd, {1, {0x04bc }}},
 { 0x04bf, {1, {0x04be }}},
 { 0x04c2, {1, {0x04c1 }}},
 { 0x04c4, {1, {0x04c3 }}},
 { 0x04c6, {1, {0x04c5 }}},
 { 0x04c8, {1, {0x04c7 }}},
 { 0x04ca, {1, {0x04c9 }}},
 { 0x04cc, {1, {0x04cb }}},
 { 0x04ce, {1, {0x04cd }}},
 { 0x04d1, {1, {0x04d0 }}},
 { 0x04d3, {1, {0x04d2 }}},
 { 0x04d5, {1, {0x04d4 }}},
 { 0x04d7, {1, {0x04d6 }}},
 { 0x04d9, {1, {0x04d8 }}},
 { 0x04db, {1, {0x04da }}},
 { 0x04dd, {1, {0x04dc }}},
 { 0x04df, {1, {0x04de }}},
 { 0x04e1, {1, {0x04e0 }}},
 { 0x04e3, {1, {0x04e2 }}},
 { 0x04e5, {1, {0x04e4 }}},
 { 0x04e7, {1, {0x04e6 }}},
 { 0x04e9, {1, {0x04e8 }}},
 { 0x04eb, {1, {0x04ea }}},
 { 0x04ed, {1, {0x04ec }}},
 { 0x04ef, {1, {0x04ee }}},
 { 0x04f1, {1, {0x04f0 }}},
 { 0x04f3, {1, {0x04f2 }}},
 { 0x04f5, {1, {0x04f4 }}},
 { 0x04f7, {1, {0x04f6 }}},
 { 0x04f9, {1, {0x04f8 }}},
 { 0x0501, {1, {0x0500 }}},
 { 0x0503, {1, {0x0502 }}},
 { 0x0505, {1, {0x0504 }}},
 { 0x0507, {1, {0x0506 }}},
 { 0x0509, {1, {0x0508 }}},
 { 0x050b, {1, {0x050a }}},
 { 0x050d, {1, {0x050c }}},
 { 0x050f, {1, {0x050e }}},
 { 0x0561, {1, {0x0531 }}},
 { 0x0562, {1, {0x0532 }}},
 { 0x0563, {1, {0x0533 }}},
 { 0x0564, {1, {0x0534 }}},
 { 0x0565, {1, {0x0535 }}},
 { 0x0566, {1, {0x0536 }}},
 { 0x0567, {1, {0x0537 }}},
 { 0x0568, {1, {0x0538 }}},
 { 0x0569, {1, {0x0539 }}},
 { 0x056a, {1, {0x053a }}},
 { 0x056b, {1, {0x053b }}},
 { 0x056c, {1, {0x053c }}},
 { 0x056d, {1, {0x053d }}},
 { 0x056e, {1, {0x053e }}},
 { 0x056f, {1, {0x053f }}},
 { 0x0570, {1, {0x0540 }}},
 { 0x0571, {1, {0x0541 }}},
 { 0x0572, {1, {0x0542 }}},
 { 0x0573, {1, {0x0543 }}},
 { 0x0574, {1, {0x0544 }}},
 { 0x0575, {1, {0x0545 }}},
 { 0x0576, {1, {0x0546 }}},
 { 0x0577, {1, {0x0547 }}},
 { 0x0578, {1, {0x0548 }}},
 { 0x0579, {1, {0x0549 }}},
 { 0x057a, {1, {0x054a }}},
 { 0x057b, {1, {0x054b }}},
 { 0x057c, {1, {0x054c }}},
 { 0x057d, {1, {0x054d }}},
 { 0x057e, {1, {0x054e }}},
 { 0x057f, {1, {0x054f }}},
 { 0x0580, {1, {0x0550 }}},
 { 0x0581, {1, {0x0551 }}},
 { 0x0582, {1, {0x0552 }}},
 { 0x0583, {1, {0x0553 }}},
 { 0x0584, {1, {0x0554 }}},
 { 0x0585, {1, {0x0555 }}},
 { 0x0586, {1, {0x0556 }}},
 { 0x1e01, {1, {0x1e00 }}},
 { 0x1e03, {1, {0x1e02 }}},
 { 0x1e05, {1, {0x1e04 }}},
 { 0x1e07, {1, {0x1e06 }}},
 { 0x1e09, {1, {0x1e08 }}},
 { 0x1e0b, {1, {0x1e0a }}},
 { 0x1e0d, {1, {0x1e0c }}},
 { 0x1e0f, {1, {0x1e0e }}},
 { 0x1e11, {1, {0x1e10 }}},
 { 0x1e13, {1, {0x1e12 }}},
 { 0x1e15, {1, {0x1e14 }}},
 { 0x1e17, {1, {0x1e16 }}},
 { 0x1e19, {1, {0x1e18 }}},
 { 0x1e1b, {1, {0x1e1a }}},
 { 0x1e1d, {1, {0x1e1c }}},
 { 0x1e1f, {1, {0x1e1e }}},
 { 0x1e21, {1, {0x1e20 }}},
 { 0x1e23, {1, {0x1e22 }}},
 { 0x1e25, {1, {0x1e24 }}},
 { 0x1e27, {1, {0x1e26 }}},
 { 0x1e29, {1, {0x1e28 }}},
 { 0x1e2b, {1, {0x1e2a }}},
 { 0x1e2d, {1, {0x1e2c }}},
 { 0x1e2f, {1, {0x1e2e }}},
 { 0x1e31, {1, {0x1e30 }}},
 { 0x1e33, {1, {0x1e32 }}},
 { 0x1e35, {1, {0x1e34 }}},
 { 0x1e37, {1, {0x1e36 }}},
 { 0x1e39, {1, {0x1e38 }}},
 { 0x1e3b, {1, {0x1e3a }}},
 { 0x1e3d, {1, {0x1e3c }}},
 { 0x1e3f, {1, {0x1e3e }}},
 { 0x1e41, {1, {0x1e40 }}},
 { 0x1e43, {1, {0x1e42 }}},
 { 0x1e45, {1, {0x1e44 }}},
 { 0x1e47, {1, {0x1e46 }}},
 { 0x1e49, {1, {0x1e48 }}},
 { 0x1e4b, {1, {0x1e4a }}},
 { 0x1e4d, {1, {0x1e4c }}},
 { 0x1e4f, {1, {0x1e4e }}},
 { 0x1e51, {1, {0x1e50 }}},
 { 0x1e53, {1, {0x1e52 }}},
 { 0x1e55, {1, {0x1e54 }}},
 { 0x1e57, {1, {0x1e56 }}},
 { 0x1e59, {1, {0x1e58 }}},
 { 0x1e5b, {1, {0x1e5a }}},
 { 0x1e5d, {1, {0x1e5c }}},
 { 0x1e5f, {1, {0x1e5e }}},
 { 0x1e61, {2, {0x1e9b, 0x1e60 }}},
 { 0x1e63, {1, {0x1e62 }}},
 { 0x1e65, {1, {0x1e64 }}},
 { 0x1e67, {1, {0x1e66 }}},
 { 0x1e69, {1, {0x1e68 }}},
 { 0x1e6b, {1, {0x1e6a }}},
 { 0x1e6d, {1, {0x1e6c }}},
 { 0x1e6f, {1, {0x1e6e }}},
 { 0x1e71, {1, {0x1e70 }}},
 { 0x1e73, {1, {0x1e72 }}},
 { 0x1e75, {1, {0x1e74 }}},
 { 0x1e77, {1, {0x1e76 }}},
 { 0x1e79, {1, {0x1e78 }}},
 { 0x1e7b, {1, {0x1e7a }}},
 { 0x1e7d, {1, {0x1e7c }}},
 { 0x1e7f, {1, {0x1e7e }}},
 { 0x1e81, {1, {0x1e80 }}},
 { 0x1e83, {1, {0x1e82 }}},
 { 0x1e85, {1, {0x1e84 }}},
 { 0x1e87, {1, {0x1e86 }}},
 { 0x1e89, {1, {0x1e88 }}},
 { 0x1e8b, {1, {0x1e8a }}},
 { 0x1e8d, {1, {0x1e8c }}},
 { 0x1e8f, {1, {0x1e8e }}},
 { 0x1e91, {1, {0x1e90 }}},
 { 0x1e93, {1, {0x1e92 }}},
 { 0x1e95, {1, {0x1e94 }}},
 { 0x1ea1, {1, {0x1ea0 }}},
 { 0x1ea3, {1, {0x1ea2 }}},
 { 0x1ea5, {1, {0x1ea4 }}},
 { 0x1ea7, {1, {0x1ea6 }}},
 { 0x1ea9, {1, {0x1ea8 }}},
 { 0x1eab, {1, {0x1eaa }}},
 { 0x1ead, {1, {0x1eac }}},
 { 0x1eaf, {1, {0x1eae }}},
 { 0x1eb1, {1, {0x1eb0 }}},
 { 0x1eb3, {1, {0x1eb2 }}},
 { 0x1eb5, {1, {0x1eb4 }}},
 { 0x1eb7, {1, {0x1eb6 }}},
 { 0x1eb9, {1, {0x1eb8 }}},
 { 0x1ebb, {1, {0x1eba }}},
 { 0x1ebd, {1, {0x1ebc }}},
 { 0x1ebf, {1, {0x1ebe }}},
 { 0x1ec1, {1, {0x1ec0 }}},
 { 0x1ec3, {1, {0x1ec2 }}},
 { 0x1ec5, {1, {0x1ec4 }}},
 { 0x1ec7, {1, {0x1ec6 }}},
 { 0x1ec9, {1, {0x1ec8 }}},
 { 0x1ecb, {1, {0x1eca }}},
 { 0x1ecd, {1, {0x1ecc }}},
 { 0x1ecf, {1, {0x1ece }}},
 { 0x1ed1, {1, {0x1ed0 }}},
 { 0x1ed3, {1, {0x1ed2 }}},
 { 0x1ed5, {1, {0x1ed4 }}},
 { 0x1ed7, {1, {0x1ed6 }}},
 { 0x1ed9, {1, {0x1ed8 }}},
 { 0x1edb, {1, {0x1eda }}},
 { 0x1edd, {1, {0x1edc }}},
 { 0x1edf, {1, {0x1ede }}},
 { 0x1ee1, {1, {0x1ee0 }}},
 { 0x1ee3, {1, {0x1ee2 }}},
 { 0x1ee5, {1, {0x1ee4 }}},
 { 0x1ee7, {1, {0x1ee6 }}},
 { 0x1ee9, {1, {0x1ee8 }}},
 { 0x1eeb, {1, {0x1eea }}},
 { 0x1eed, {1, {0x1eec }}},
 { 0x1eef, {1, {0x1eee }}},
 { 0x1ef1, {1, {0x1ef0 }}},
 { 0x1ef3, {1, {0x1ef2 }}},
 { 0x1ef5, {1, {0x1ef4 }}},
 { 0x1ef7, {1, {0x1ef6 }}},
 { 0x1ef9, {1, {0x1ef8 }}},
 { 0x1f00, {1, {0x1f08 }}},
 { 0x1f01, {1, {0x1f09 }}},
 { 0x1f02, {1, {0x1f0a }}},
 { 0x1f03, {1, {0x1f0b }}},
 { 0x1f04, {1, {0x1f0c }}},
 { 0x1f05, {1, {0x1f0d }}},
 { 0x1f06, {1, {0x1f0e }}},
 { 0x1f07, {1, {0x1f0f }}},
 { 0x1f10, {1, {0x1f18 }}},
 { 0x1f11, {1, {0x1f19 }}},
 { 0x1f12, {1, {0x1f1a }}},
 { 0x1f13, {1, {0x1f1b }}},
 { 0x1f14, {1, {0x1f1c }}},
 { 0x1f15, {1, {0x1f1d }}},
 { 0x1f20, {1, {0x1f28 }}},
 { 0x1f21, {1, {0x1f29 }}},
 { 0x1f22, {1, {0x1f2a }}},
 { 0x1f23, {1, {0x1f2b }}},
 { 0x1f24, {1, {0x1f2c }}},
 { 0x1f25, {1, {0x1f2d }}},
 { 0x1f26, {1, {0x1f2e }}},
 { 0x1f27, {1, {0x1f2f }}},
 { 0x1f30, {1, {0x1f38 }}},
 { 0x1f31, {1, {0x1f39 }}},
 { 0x1f32, {1, {0x1f3a }}},
 { 0x1f33, {1, {0x1f3b }}},
 { 0x1f34, {1, {0x1f3c }}},
 { 0x1f35, {1, {0x1f3d }}},
 { 0x1f36, {1, {0x1f3e }}},
 { 0x1f37, {1, {0x1f3f }}},
 { 0x1f40, {1, {0x1f48 }}},
 { 0x1f41, {1, {0x1f49 }}},
 { 0x1f42, {1, {0x1f4a }}},
 { 0x1f43, {1, {0x1f4b }}},
 { 0x1f44, {1, {0x1f4c }}},
 { 0x1f45, {1, {0x1f4d }}},
 { 0x1f51, {1, {0x1f59 }}},
 { 0x1f53, {1, {0x1f5b }}},
 { 0x1f55, {1, {0x1f5d }}},
 { 0x1f57, {1, {0x1f5f }}},
 { 0x1f60, {1, {0x1f68 }}},
 { 0x1f61, {1, {0x1f69 }}},
 { 0x1f62, {1, {0x1f6a }}},
 { 0x1f63, {1, {0x1f6b }}},
 { 0x1f64, {1, {0x1f6c }}},
 { 0x1f65, {1, {0x1f6d }}},
 { 0x1f66, {1, {0x1f6e }}},
 { 0x1f67, {1, {0x1f6f }}},
 { 0x1f70, {1, {0x1fba }}},
 { 0x1f71, {1, {0x1fbb }}},
 { 0x1f72, {1, {0x1fc8 }}},
 { 0x1f73, {1, {0x1fc9 }}},
 { 0x1f74, {1, {0x1fca }}},
 { 0x1f75, {1, {0x1fcb }}},
 { 0x1f76, {1, {0x1fda }}},
 { 0x1f77, {1, {0x1fdb }}},
 { 0x1f78, {1, {0x1ff8 }}},
 { 0x1f79, {1, {0x1ff9 }}},
 { 0x1f7a, {1, {0x1fea }}},
 { 0x1f7b, {1, {0x1feb }}},
 { 0x1f7c, {1, {0x1ffa }}},
 { 0x1f7d, {1, {0x1ffb }}},
 { 0x1fb0, {1, {0x1fb8 }}},
 { 0x1fb1, {1, {0x1fb9 }}},
 { 0x1fd0, {1, {0x1fd8 }}},
 { 0x1fd1, {1, {0x1fd9 }}},
 { 0x1fe0, {1, {0x1fe8 }}},
 { 0x1fe1, {1, {0x1fe9 }}},
 { 0x1fe5, {1, {0x1fec }}},
 { 0x2170, {1, {0x2160 }}},
 { 0x2171, {1, {0x2161 }}},
 { 0x2172, {1, {0x2162 }}},
 { 0x2173, {1, {0x2163 }}},
 { 0x2174, {1, {0x2164 }}},
 { 0x2175, {1, {0x2165 }}},
 { 0x2176, {1, {0x2166 }}},
 { 0x2177, {1, {0x2167 }}},
 { 0x2178, {1, {0x2168 }}},
 { 0x2179, {1, {0x2169 }}},
 { 0x217a, {1, {0x216a }}},
 { 0x217b, {1, {0x216b }}},
 { 0x217c, {1, {0x216c }}},
 { 0x217d, {1, {0x216d }}},
 { 0x217e, {1, {0x216e }}},
 { 0x217f, {1, {0x216f }}},
 { 0x24d0, {1, {0x24b6 }}},
 { 0x24d1, {1, {0x24b7 }}},
 { 0x24d2, {1, {0x24b8 }}},
 { 0x24d3, {1, {0x24b9 }}},
 { 0x24d4, {1, {0x24ba }}},
 { 0x24d5, {1, {0x24bb }}},
 { 0x24d6, {1, {0x24bc }}},
 { 0x24d7, {1, {0x24bd }}},
 { 0x24d8, {1, {0x24be }}},
 { 0x24d9, {1, {0x24bf }}},
 { 0x24da, {1, {0x24c0 }}},
 { 0x24db, {1, {0x24c1 }}},
 { 0x24dc, {1, {0x24c2 }}},
 { 0x24dd, {1, {0x24c3 }}},
 { 0x24de, {1, {0x24c4 }}},
 { 0x24df, {1, {0x24c5 }}},
 { 0x24e0, {1, {0x24c6 }}},
 { 0x24e1, {1, {0x24c7 }}},
 { 0x24e2, {1, {0x24c8 }}},
 { 0x24e3, {1, {0x24c9 }}},
 { 0x24e4, {1, {0x24ca }}},
 { 0x24e5, {1, {0x24cb }}},
 { 0x24e6, {1, {0x24cc }}},
 { 0x24e7, {1, {0x24cd }}},
 { 0x24e8, {1, {0x24ce }}},
 { 0x24e9, {1, {0x24cf }}},
 { 0x2c30, {1, {0x2c00 }}},
 { 0x2c31, {1, {0x2c01 }}},
 { 0x2c32, {1, {0x2c02 }}},
 { 0x2c33, {1, {0x2c03 }}},
 { 0x2c34, {1, {0x2c04 }}},
 { 0x2c35, {1, {0x2c05 }}},
 { 0x2c36, {1, {0x2c06 }}},
 { 0x2c37, {1, {0x2c07 }}},
 { 0x2c38, {1, {0x2c08 }}},
 { 0x2c39, {1, {0x2c09 }}},
 { 0x2c3a, {1, {0x2c0a }}},
 { 0x2c3b, {1, {0x2c0b }}},
 { 0x2c3c, {1, {0x2c0c }}},
 { 0x2c3d, {1, {0x2c0d }}},
 { 0x2c3e, {1, {0x2c0e }}},
 { 0x2c3f, {1, {0x2c0f }}},
 { 0x2c40, {1, {0x2c10 }}},
 { 0x2c41, {1, {0x2c11 }}},
 { 0x2c42, {1, {0x2c12 }}},
 { 0x2c43, {1, {0x2c13 }}},
 { 0x2c44, {1, {0x2c14 }}},
 { 0x2c45, {1, {0x2c15 }}},
 { 0x2c46, {1, {0x2c16 }}},
 { 0x2c47, {1, {0x2c17 }}},
 { 0x2c48, {1, {0x2c18 }}},
 { 0x2c49, {1, {0x2c19 }}},
 { 0x2c4a, {1, {0x2c1a }}},
 { 0x2c4b, {1, {0x2c1b }}},
 { 0x2c4c, {1, {0x2c1c }}},
 { 0x2c4d, {1, {0x2c1d }}},
 { 0x2c4e, {1, {0x2c1e }}},
 { 0x2c4f, {1, {0x2c1f }}},
 { 0x2c50, {1, {0x2c20 }}},
 { 0x2c51, {1, {0x2c21 }}},
 { 0x2c52, {1, {0x2c22 }}},
 { 0x2c53, {1, {0x2c23 }}},
 { 0x2c54, {1, {0x2c24 }}},
 { 0x2c55, {1, {0x2c25 }}},
 { 0x2c56, {1, {0x2c26 }}},
 { 0x2c57, {1, {0x2c27 }}},
 { 0x2c58, {1, {0x2c28 }}},
 { 0x2c59, {1, {0x2c29 }}},
 { 0x2c5a, {1, {0x2c2a }}},
 { 0x2c5b, {1, {0x2c2b }}},
 { 0x2c5c, {1, {0x2c2c }}},
 { 0x2c5d, {1, {0x2c2d }}},
 { 0x2c5e, {1, {0x2c2e }}},
 { 0x2c81, {1, {0x2c80 }}},
 { 0x2c83, {1, {0x2c82 }}},
 { 0x2c85, {1, {0x2c84 }}},
 { 0x2c87, {1, {0x2c86 }}},
 { 0x2c89, {1, {0x2c88 }}},
 { 0x2c8b, {1, {0x2c8a }}},
 { 0x2c8d, {1, {0x2c8c }}},
 { 0x2c8f, {1, {0x2c8e }}},
 { 0x2c91, {1, {0x2c90 }}},
 { 0x2c93, {1, {0x2c92 }}},
 { 0x2c95, {1, {0x2c94 }}},
 { 0x2c97, {1, {0x2c96 }}},
 { 0x2c99, {1, {0x2c98 }}},
 { 0x2c9b, {1, {0x2c9a }}},
 { 0x2c9d, {1, {0x2c9c }}},
 { 0x2c9f, {1, {0x2c9e }}},
 { 0x2ca1, {1, {0x2ca0 }}},
 { 0x2ca3, {1, {0x2ca2 }}},
 { 0x2ca5, {1, {0x2ca4 }}},
 { 0x2ca7, {1, {0x2ca6 }}},
 { 0x2ca9, {1, {0x2ca8 }}},
 { 0x2cab, {1, {0x2caa }}},
 { 0x2cad, {1, {0x2cac }}},
 { 0x2caf, {1, {0x2cae }}},
 { 0x2cb1, {1, {0x2cb0 }}},
 { 0x2cb3, {1, {0x2cb2 }}},
 { 0x2cb5, {1, {0x2cb4 }}},
 { 0x2cb7, {1, {0x2cb6 }}},
 { 0x2cb9, {1, {0x2cb8 }}},
 { 0x2cbb, {1, {0x2cba }}},
 { 0x2cbd, {1, {0x2cbc }}},
 { 0x2cbf, {1, {0x2cbe }}},
 { 0x2cc1, {1, {0x2cc0 }}},
 { 0x2cc3, {1, {0x2cc2 }}},
 { 0x2cc5, {1, {0x2cc4 }}},
 { 0x2cc7, {1, {0x2cc6 }}},
 { 0x2cc9, {1, {0x2cc8 }}},
 { 0x2ccb, {1, {0x2cca }}},
 { 0x2ccd, {1, {0x2ccc }}},
 { 0x2ccf, {1, {0x2cce }}},
 { 0x2cd1, {1, {0x2cd0 }}},
 { 0x2cd3, {1, {0x2cd2 }}},
 { 0x2cd5, {1, {0x2cd4 }}},
 { 0x2cd7, {1, {0x2cd6 }}},
 { 0x2cd9, {1, {0x2cd8 }}},
 { 0x2cdb, {1, {0x2cda }}},
 { 0x2cdd, {1, {0x2cdc }}},
 { 0x2cdf, {1, {0x2cde }}},
 { 0x2ce1, {1, {0x2ce0 }}},
 { 0x2ce3, {1, {0x2ce2 }}},
 { 0x2d00, {1, {0x10a0 }}},
 { 0x2d01, {1, {0x10a1 }}},
 { 0x2d02, {1, {0x10a2 }}},
 { 0x2d03, {1, {0x10a3 }}},
 { 0x2d04, {1, {0x10a4 }}},
 { 0x2d05, {1, {0x10a5 }}},
 { 0x2d06, {1, {0x10a6 }}},
 { 0x2d07, {1, {0x10a7 }}},
 { 0x2d08, {1, {0x10a8 }}},
 { 0x2d09, {1, {0x10a9 }}},
 { 0x2d0a, {1, {0x10aa }}},
 { 0x2d0b, {1, {0x10ab }}},
 { 0x2d0c, {1, {0x10ac }}},
 { 0x2d0d, {1, {0x10ad }}},
 { 0x2d0e, {1, {0x10ae }}},
 { 0x2d0f, {1, {0x10af }}},
 { 0x2d10, {1, {0x10b0 }}},
 { 0x2d11, {1, {0x10b1 }}},
 { 0x2d12, {1, {0x10b2 }}},
 { 0x2d13, {1, {0x10b3 }}},
 { 0x2d14, {1, {0x10b4 }}},
 { 0x2d15, {1, {0x10b5 }}},
 { 0x2d16, {1, {0x10b6 }}},
 { 0x2d17, {1, {0x10b7 }}},
 { 0x2d18, {1, {0x10b8 }}},
 { 0x2d19, {1, {0x10b9 }}},
 { 0x2d1a, {1, {0x10ba }}},
 { 0x2d1b, {1, {0x10bb }}},
 { 0x2d1c, {1, {0x10bc }}},
 { 0x2d1d, {1, {0x10bd }}},
 { 0x2d1e, {1, {0x10be }}},
 { 0x2d1f, {1, {0x10bf }}},
 { 0x2d20, {1, {0x10c0 }}},
 { 0x2d21, {1, {0x10c1 }}},
 { 0x2d22, {1, {0x10c2 }}},
 { 0x2d23, {1, {0x10c3 }}},
 { 0x2d24, {1, {0x10c4 }}},
 { 0x2d25, {1, {0x10c5 }}},
 { 0xff41, {1, {0xff21 }}},
 { 0xff42, {1, {0xff22 }}},
 { 0xff43, {1, {0xff23 }}},
 { 0xff44, {1, {0xff24 }}},
 { 0xff45, {1, {0xff25 }}},
 { 0xff46, {1, {0xff26 }}},
 { 0xff47, {1, {0xff27 }}},
 { 0xff48, {1, {0xff28 }}},
 { 0xff49, {1, {0xff29 }}},
 { 0xff4a, {1, {0xff2a }}},
 { 0xff4b, {1, {0xff2b }}},
 { 0xff4c, {1, {0xff2c }}},
 { 0xff4d, {1, {0xff2d }}},
 { 0xff4e, {1, {0xff2e }}},
 { 0xff4f, {1, {0xff2f }}},
 { 0xff50, {1, {0xff30 }}},
 { 0xff51, {1, {0xff31 }}},
 { 0xff52, {1, {0xff32 }}},
 { 0xff53, {1, {0xff33 }}},
 { 0xff54, {1, {0xff34 }}},
 { 0xff55, {1, {0xff35 }}},
 { 0xff56, {1, {0xff36 }}},
 { 0xff57, {1, {0xff37 }}},
 { 0xff58, {1, {0xff38 }}},
 { 0xff59, {1, {0xff39 }}},
 { 0xff5a, {1, {0xff3a }}},
 { 0x10428, {1, {0x10400 }}},
 { 0x10429, {1, {0x10401 }}},
 { 0x1042a, {1, {0x10402 }}},
 { 0x1042b, {1, {0x10403 }}},
 { 0x1042c, {1, {0x10404 }}},
 { 0x1042d, {1, {0x10405 }}},
 { 0x1042e, {1, {0x10406 }}},
 { 0x1042f, {1, {0x10407 }}},
 { 0x10430, {1, {0x10408 }}},
 { 0x10431, {1, {0x10409 }}},
 { 0x10432, {1, {0x1040a }}},
 { 0x10433, {1, {0x1040b }}},
 { 0x10434, {1, {0x1040c }}},
 { 0x10435, {1, {0x1040d }}},
 { 0x10436, {1, {0x1040e }}},
 { 0x10437, {1, {0x1040f }}},
 { 0x10438, {1, {0x10410 }}},
 { 0x10439, {1, {0x10411 }}},
 { 0x1043a, {1, {0x10412 }}},
 { 0x1043b, {1, {0x10413 }}},
 { 0x1043c, {1, {0x10414 }}},
 { 0x1043d, {1, {0x10415 }}},
 { 0x1043e, {1, {0x10416 }}},
 { 0x1043f, {1, {0x10417 }}},
 { 0x10440, {1, {0x10418 }}},
 { 0x10441, {1, {0x10419 }}},
 { 0x10442, {1, {0x1041a }}},
 { 0x10443, {1, {0x1041b }}},
 { 0x10444, {1, {0x1041c }}},
 { 0x10445, {1, {0x1041d }}},
 { 0x10446, {1, {0x1041e }}},
 { 0x10447, {1, {0x1041f }}},
 { 0x10448, {1, {0x10420 }}},
 { 0x10449, {1, {0x10421 }}},
 { 0x1044a, {1, {0x10422 }}},
 { 0x1044b, {1, {0x10423 }}},
 { 0x1044c, {1, {0x10424 }}},
 { 0x1044d, {1, {0x10425 }}},
 { 0x1044e, {1, {0x10426 }}},
 { 0x1044f, {1, {0x10427 }}}
};

static const CaseUnfold_11_Type CaseUnfold_11_Locale[] = {
 { 0x0069, {1, {0x0049 }}}
};

static const CaseUnfold_12_Type CaseUnfold_12[] = {
 { {0x0061, 0x02be}, {1, {0x1e9a }}},
 { {0x0066, 0x0066}, {1, {0xfb00 }}},
 { {0x0066, 0x0069}, {1, {0xfb01 }}},
 { {0x0066, 0x006c}, {1, {0xfb02 }}},
 { {0x0068, 0x0331}, {1, {0x1e96 }}},
 { {0x006a, 0x030c}, {1, {0x01f0 }}},
 { {0x0073, 0x0073}, {1, {0x00df }}},
 { {0x0073, 0x0074}, {2, {0xfb05, 0xfb06 }}},
 { {0x0074, 0x0308}, {1, {0x1e97 }}},
 { {0x0077, 0x030a}, {1, {0x1e98 }}},
 { {0x0079, 0x030a}, {1, {0x1e99 }}},
 { {0x02bc, 0x006e}, {1, {0x0149 }}},
 { {0x03ac, 0x03b9}, {1, {0x1fb4 }}},
 { {0x03ae, 0x03b9}, {1, {0x1fc4 }}},
 { {0x03b1, 0x0342}, {1, {0x1fb6 }}},
 { {0x03b1, 0x03b9}, {2, {0x1fb3, 0x1fbc }}},
 { {0x03b7, 0x0342}, {1, {0x1fc6 }}},
 { {0x03b7, 0x03b9}, {2, {0x1fc3, 0x1fcc }}},
 { {0x03b9, 0x0342}, {1, {0x1fd6 }}},
 { {0x03c1, 0x0313}, {1, {0x1fe4 }}},
 { {0x03c5, 0x0313}, {1, {0x1f50 }}},
 { {0x03c5, 0x0342}, {1, {0x1fe6 }}},
 { {0x03c9, 0x0342}, {1, {0x1ff6 }}},
 { {0x03c9, 0x03b9}, {2, {0x1ff3, 0x1ffc }}},
 { {0x03ce, 0x03b9}, {1, {0x1ff4 }}},
 { {0x0565, 0x0582}, {1, {0x0587 }}},
 { {0x0574, 0x0565}, {1, {0xfb14 }}},
 { {0x0574, 0x056b}, {1, {0xfb15 }}},
 { {0x0574, 0x056d}, {1, {0xfb17 }}},
 { {0x0574, 0x0576}, {1, {0xfb13 }}},
 { {0x057e, 0x0576}, {1, {0xfb16 }}},
 { {0x1f00, 0x03b9}, {2, {0x1f88, 0x1f80 }}},
 { {0x1f01, 0x03b9}, {2, {0x1f81, 0x1f89 }}},
 { {0x1f02, 0x03b9}, {2, {0x1f82, 0x1f8a }}},
 { {0x1f03, 0x03b9}, {2, {0x1f83, 0x1f8b }}},
 { {0x1f04, 0x03b9}, {2, {0x1f84, 0x1f8c }}},
 { {0x1f05, 0x03b9}, {2, {0x1f85, 0x1f8d }}},
 { {0x1f06, 0x03b9}, {2, {0x1f86, 0x1f8e }}},
 { {0x1f07, 0x03b9}, {2, {0x1f87, 0x1f8f }}},
 { {0x1f20, 0x03b9}, {2, {0x1f90, 0x1f98 }}},
 { {0x1f21, 0x03b9}, {2, {0x1f91, 0x1f99 }}},
 { {0x1f22, 0x03b9}, {2, {0x1f92, 0x1f9a }}},
 { {0x1f23, 0x03b9}, {2, {0x1f93, 0x1f9b }}},
 { {0x1f24, 0x03b9}, {2, {0x1f94, 0x1f9c }}},
 { {0x1f25, 0x03b9}, {2, {0x1f95, 0x1f9d }}},
 { {0x1f26, 0x03b9}, {2, {0x1f96, 0x1f9e }}},
 { {0x1f27, 0x03b9}, {2, {0x1f97, 0x1f9f }}},
 { {0x1f60, 0x03b9}, {2, {0x1fa0, 0x1fa8 }}},
 { {0x1f61, 0x03b9}, {2, {0x1fa1, 0x1fa9 }}},
 { {0x1f62, 0x03b9}, {2, {0x1fa2, 0x1faa }}},
 { {0x1f63, 0x03b9}, {2, {0x1fa3, 0x1fab }}},
 { {0x1f64, 0x03b9}, {2, {0x1fa4, 0x1fac }}},
 { {0x1f65, 0x03b9}, {2, {0x1fa5, 0x1fad }}},
 { {0x1f66, 0x03b9}, {2, {0x1fa6, 0x1fae }}},
 { {0x1f67, 0x03b9}, {2, {0x1fa7, 0x1faf }}},
 { {0x1f70, 0x03b9}, {1, {0x1fb2 }}},
 { {0x1f74, 0x03b9}, {1, {0x1fc2 }}},
 { {0x1f7c, 0x03b9}, {1, {0x1ff2 }}}
};

static const CaseUnfold_12_Type CaseUnfold_12_Locale[] = {
 { {0x0069, 0x0307}, {1, {0x0130 }}}
};

static const CaseUnfold_13_Type CaseUnfold_13[] = {
 { {0x0066, 0x0066, 0x0069}, {1, {0xfb03 }}},
 { {0x0066, 0x0066, 0x006c}, {1, {0xfb04 }}},
 { {0x03b1, 0x0342, 0x03b9}, {1, {0x1fb7 }}},
 { {0x03b7, 0x0342, 0x03b9}, {1, {0x1fc7 }}},
 { {0x03b9, 0x0308, 0x0300}, {1, {0x1fd2 }}},
 { {0x03b9, 0x0308, 0x0301}, {2, {0x0390, 0x1fd3 }}},
 { {0x03b9, 0x0308, 0x0342}, {1, {0x1fd7 }}},
 { {0x03c5, 0x0308, 0x0300}, {1, {0x1fe2 }}},
 { {0x03c5, 0x0308, 0x0301}, {2, {0x03b0, 0x1fe3 }}},
 { {0x03c5, 0x0308, 0x0342}, {1, {0x1fe7 }}},
 { {0x03c5, 0x0313, 0x0300}, {1, {0x1f52 }}},
 { {0x03c5, 0x0313, 0x0301}, {1, {0x1f54 }}},
 { {0x03c5, 0x0313, 0x0342}, {1, {0x1f56 }}},
 { {0x03c9, 0x0342, 0x03b9}, {1, {0x1ff7 }}}
};


static PosixBracketEntryType HashEntryData[] = {
  { (UChar* )"NEWLINE",                0,  7 },
  { (UChar* )"Alpha",                  1,  5 },
  { (UChar* )"Blank",                  2,  5 },
  { (UChar* )"Cntrl",                  3,  5 },
  { (UChar* )"Digit",                  4,  5 },
  { (UChar* )"Graph",                  5,  5 },
  { (UChar* )"Lower",                  6,  5 },
  { (UChar* )"Print",                  7,  5 },
  { (UChar* )"Punct",                  8,  5 },
  { (UChar* )"Space",                  9,  5 },
  { (UChar* )"Upper",                 10,  5 },
  { (UChar* )"XDigit",                11,  6 },
  { (UChar* )"Word",                  12,  4 },
  { (UChar* )"Alnum",                 13,  5 },
  { (UChar* )"ASCII",                 14,  5 },
  { (UChar* )NULL,                    -1,  0 }
};

#define CODE_RANGES_NUM      15

static const OnigCodePoint* CodeRanges[CODE_RANGES_NUM];
static int CodeRangeTableInited = 0;

static void init_code_range_array(void) {
  THREAD_ATOMIC_START;

  CodeRanges[0] = CR_NEWLINE;
  CodeRanges[1] = CR_Alpha;
  CodeRanges[2] = CR_Blank;
  CodeRanges[3] = CR_Cntrl;
  CodeRanges[4] = CR_Digit;
  CodeRanges[5] = CR_Graph;
  CodeRanges[6] = CR_Lower;
  CodeRanges[7] = CR_Print;
  CodeRanges[8] = CR_Punct;
  CodeRanges[9] = CR_Space;
  CodeRanges[10] = CR_Upper;
  CodeRanges[11] = CR_XDigit;
  CodeRanges[12] = CR_Word;
  CodeRanges[13] = CR_Alnum;
  CodeRanges[14] = CR_ASCII;

  CodeRangeTableInited = 1;
  THREAD_ATOMIC_END;
}

extern int
onigenc_unicode_is_code_ctype(OnigCodePoint code, unsigned int ctype)
{
  if (code < 256) {
    return ONIGENC_IS_UNICODE_ISO_8859_1_CTYPE(code, ctype);
  }

  if (ctype >= CODE_RANGES_NUM) {
    return ONIGERR_TYPE_BUG;
  }

  if (CodeRangeTableInited == 0) init_code_range_array();

  return onig_is_in_code_range((UChar* )CodeRanges[ctype], code);
}


extern int
onigenc_unicode_ctype_code_range(int ctype, const OnigCodePoint* ranges[])
{
  if (ctype >= CODE_RANGES_NUM) {
    return ONIGERR_TYPE_BUG;
  }

  if (CodeRangeTableInited == 0) init_code_range_array();

  *ranges = CodeRanges[ctype];

  return 0;
}

extern int
onigenc_utf16_32_get_ctype_code_range(OnigCtype ctype, OnigCodePoint* sb_out,
                                      const OnigCodePoint* ranges[])
{
  *sb_out = 0x00;
  return onigenc_unicode_ctype_code_range(ctype, ranges);
}

#include "st.h"

#define PROPERTY_NAME_MAX_SIZE    20

static st_table* NameCtypeTable;
static int NameTableInited = 0;

static int init_name_ctype_table(void)
{
  PosixBracketEntryType *pb;

  THREAD_ATOMIC_START;

  NameCtypeTable = onig_st_init_strend_table_with_size(100);
  if (ONIG_IS_NULL(NameCtypeTable)) return ONIGERR_MEMORY;

  for (pb = HashEntryData; ONIG_IS_NOT_NULL(pb->name); pb++) {
    onig_st_insert_strend(NameCtypeTable, pb->name, pb->name + pb->len,
			  (st_data_t )pb->ctype);
  }

  NameTableInited = 1;
  THREAD_ATOMIC_END;
  return 0;
}

extern int
onigenc_unicode_property_name_to_ctype(OnigEncoding enc, UChar* name, UChar* end)
{
  int len;
  hash_data_type ctype;
  UChar buf[PROPERTY_NAME_MAX_SIZE];
  UChar *p;
  OnigCodePoint code;

  p = name;
  len = 0;
  while (p < end) {
    code = ONIGENC_MBC_TO_CODE(enc, p, end);
    if (code >= 0x80)
      return ONIGERR_INVALID_CHAR_PROPERTY_NAME;

    buf[len++] = (UChar )code;
    if (len >= PROPERTY_NAME_MAX_SIZE)
      return ONIGERR_INVALID_CHAR_PROPERTY_NAME;

    p += enclen(enc, p);
  }

  buf[len] = 0;

  if (NameTableInited == 0)  init_name_ctype_table();

  if (onig_st_lookup_strend(NameCtypeTable, buf, buf + len, &ctype) == 0) {
    return ONIGERR_INVALID_CHAR_PROPERTY_NAME;
  }

  return (int )ctype;
}


static int
code2_cmp(OnigCodePoint* x, OnigCodePoint* y)
{
  if (x[0] == y[0] && x[1] == y[1]) return 0;
  return 1;
}

static int
code2_hash(OnigCodePoint* x)
{
  return (int )(x[0] + x[1]);
}

static struct st_hash_type type_code2_hash = {
  code2_cmp,
  code2_hash,
};

static int
code3_cmp(OnigCodePoint* x, OnigCodePoint* y)
{
  if (x[0] == y[0] && x[1] == y[1] && x[2] == y[2]) return 0;
  return 1;
}

static int
code3_hash(OnigCodePoint* x)
{
  return (int )(x[0] + x[1] + x[2]);
}

static struct st_hash_type type_code3_hash = {
  code3_cmp,
  code3_hash,
};


static st_table* FoldTable;    /* fold-1, fold-2, fold-3 */
static st_table* Unfold1Table;
static st_table* Unfold2Table;
static st_table* Unfold3Table;
static int CaseFoldInited = 0;

static int init_case_fold_table(void)
{
  const CaseFold_11_Type   *p;
  const CaseUnfold_11_Type *p1;
  const CaseUnfold_12_Type *p2;
  const CaseUnfold_13_Type *p3;
  int i;

  THREAD_ATOMIC_START;

  FoldTable = st_init_numtable_with_size(1200);
  if (ONIG_IS_NULL(FoldTable)) return ONIGERR_MEMORY;
  for (i = 0; i < (int )(sizeof(CaseFold)/sizeof(CaseFold_11_Type)); i++) {
    p = &CaseFold[i];
    st_add_direct(FoldTable, (st_data_t )p->from, (st_data_t )&(p->to));
  }
  for (i = 0; i < (int )(sizeof(CaseFold_Locale)/sizeof(CaseFold_11_Type));
       i++) {
    p = &CaseFold_Locale[i];
    st_add_direct(FoldTable, (st_data_t )p->from, (st_data_t )&(p->to));
  }

  Unfold1Table = st_init_numtable_with_size(1000);
  if (ONIG_IS_NULL(Unfold1Table)) return ONIGERR_MEMORY;

  for (i = 0; i < (int )(sizeof(CaseUnfold_11)/sizeof(CaseUnfold_11_Type));
       i++) {
    p1 = &CaseUnfold_11[i];
    st_add_direct(Unfold1Table, (st_data_t )p1->from, (st_data_t )&(p1->to));
  }
  for (i = 0;
       i < (int )(sizeof(CaseUnfold_11_Locale)/sizeof(CaseUnfold_11_Type));
       i++) {
    p1 = &CaseUnfold_11_Locale[i];
    st_add_direct(Unfold1Table, (st_data_t )p1->from, (st_data_t )&(p1->to));
  }

  Unfold2Table = st_init_table_with_size(&type_code2_hash, 200);
  if (ONIG_IS_NULL(Unfold2Table)) return ONIGERR_MEMORY;

  for (i = 0; i < (int )(sizeof(CaseUnfold_12)/sizeof(CaseUnfold_12_Type));
       i++) {
    p2 = &CaseUnfold_12[i];
    st_add_direct(Unfold2Table, (st_data_t )p2->from, (st_data_t )(&p2->to));
  }
  for (i = 0;
       i < (int )(sizeof(CaseUnfold_12_Locale)/sizeof(CaseUnfold_12_Type));
       i++) {
    p2 = &CaseUnfold_12_Locale[i];
    st_add_direct(Unfold2Table, (st_data_t )p2->from, (st_data_t )(&p2->to));
  }

  Unfold3Table = st_init_table_with_size(&type_code3_hash, 30);
  if (ONIG_IS_NULL(Unfold3Table)) return ONIGERR_MEMORY;

  for (i = 0; i < (int )(sizeof(CaseUnfold_13)/sizeof(CaseUnfold_13_Type));
       i++) {
    p3 = &CaseUnfold_13[i];
    st_add_direct(Unfold3Table, (st_data_t )p3->from, (st_data_t )(&p3->to));
  }

  CaseFoldInited = 1;
  THREAD_ATOMIC_END;
  return 0;
}

extern int
onigenc_unicode_mbc_case_fold(OnigEncoding enc,
    OnigCaseFoldType flag ARG_UNUSED, const UChar** pp, const UChar* end,
    UChar* fold)
{
  CodePointList3 *to;
  OnigCodePoint code;
  int i, len, rlen;
  const UChar *p = *pp;

  if (CaseFoldInited == 0) init_case_fold_table();

  code = ONIGENC_MBC_TO_CODE(enc, p, end);
  len = enclen(enc, p);
  *pp += len;

#ifdef USE_UNICODE_CASE_FOLD_TURKISH_AZERI
  if ((flag & ONIGENC_CASE_FOLD_TURKISH_AZERI) != 0) {
    if (code == 0x0049) {
      return ONIGENC_CODE_TO_MBC(enc, 0x0131, fold);
    }
    else if (code == 0x0130) {
      return ONIGENC_CODE_TO_MBC(enc, 0x0069, fold);
    }
  }
#endif

  if (onig_st_lookup(FoldTable, (st_data_t )code, (void* )&to) != 0) {
    if (to->n == 1) {
      return ONIGENC_CODE_TO_MBC(enc, to->code[0], fold);      
    }
#if 0
    /* NO NEEDS TO CHECK */
    else if ((flag & INTERNAL_ONIGENC_CASE_FOLD_MULTI_CHAR) != 0) {
#else
    else {
#endif
      rlen = 0;
      for (i = 0; i < to->n; i++) {
	len = ONIGENC_CODE_TO_MBC(enc, to->code[i], fold);
	fold += len;
	rlen += len;
      }
      return rlen;
    }
  }

  for (i = 0; i < len; i++) {
    *fold++ = *p++;
  }
  return len;
}

extern int
onigenc_unicode_apply_all_case_fold(OnigCaseFoldType flag,
				    OnigApplyAllCaseFoldFunc f, void* arg)
{
  const CaseUnfold_11_Type* p11;
  OnigCodePoint code;
  int i, j, k, r;

  /* if (CaseFoldInited == 0) init_case_fold_table(); */

  for (i = 0; i < (int )(sizeof(CaseUnfold_11)/sizeof(CaseUnfold_11_Type));
       i++) {
    p11 = &CaseUnfold_11[i];
    for (j = 0; j < p11->to.n; j++) {
      code = p11->from;
      r = (*f)(p11->to.code[j], &code, 1, arg);
      if (r != 0) return r;

      code = p11->to.code[j];
      r = (*f)(p11->from, &code, 1, arg);
      if (r != 0) return r;

      for (k = 0; k < j; k++) {
	r = (*f)(p11->to.code[j], (OnigCodePoint* )(&p11->to.code[k]), 1, arg);
	if (r != 0) return r;

	r = (*f)(p11->to.code[k], (OnigCodePoint* )(&p11->to.code[j]), 1, arg);
	if (r != 0) return r;
      }
    }
  }

#ifdef USE_UNICODE_CASE_FOLD_TURKISH_AZERI
  if ((flag & ONIGENC_CASE_FOLD_TURKISH_AZERI) != 0) {
    code = 0x0131;
    r = (*f)(0x0049, &code, 1, arg);
    if (r != 0) return r;
    code = 0x0049;
    r = (*f)(0x0131, &code, 1, arg);
    if (r != 0) return r;

    code = 0x0130;
    r = (*f)(0x0069, &code, 1, arg);
    if (r != 0) return r;
    code = 0x0069;
    r = (*f)(0x0130, &code, 1, arg);
    if (r != 0) return r;
  }
  else {
#endif
    for (i = 0;
	 i < (int )(sizeof(CaseUnfold_11_Locale)/sizeof(CaseUnfold_11_Type));
	 i++) {
      p11 = &CaseUnfold_11_Locale[i];
      for (j = 0; j < p11->to.n; j++) {
	code = p11->from;
	r = (*f)(p11->to.code[j], &code, 1, arg);
	if (r != 0) return r;

	code = p11->to.code[j];
	r = (*f)(p11->from, &code, 1, arg);
	if (r != 0) return r;

	for (k = 0; k < j; k++) {
	  r = (*f)(p11->to.code[j], (OnigCodePoint* )(&p11->to.code[k]),
		   1, arg);
	  if (r != 0) return r;

	  r = (*f)(p11->to.code[k], (OnigCodePoint* )(&p11->to.code[j]),
		   1, arg);
	  if (r != 0) return r;
	}
      }
    }
#ifdef USE_UNICODE_CASE_FOLD_TURKISH_AZERI
  }
#endif

  if ((flag & INTERNAL_ONIGENC_CASE_FOLD_MULTI_CHAR) != 0) {
    for (i = 0; i < (int )(sizeof(CaseUnfold_12)/sizeof(CaseUnfold_12_Type));
	 i++) {
      for (j = 0; j < CaseUnfold_12[i].to.n; j++) {
	r = (*f)(CaseUnfold_12[i].to.code[j],
		 (OnigCodePoint* )CaseUnfold_12[i].from, 2, arg);
	if (r != 0) return r;	

	for (k = 0; k < CaseUnfold_12[i].to.n; k++) {
	  if (k == j) continue;

	  r = (*f)(CaseUnfold_12[i].to.code[j],
		   (OnigCodePoint* )(&CaseUnfold_12[i].to.code[k]), 1, arg);
	  if (r != 0) return r;
	}
      }
    }

#ifdef USE_UNICODE_CASE_FOLD_TURKISH_AZERI
    if ((flag & ONIGENC_CASE_FOLD_TURKISH_AZERI) == 0) {
#endif
      for (i = 0;
	   i < (int )(sizeof(CaseUnfold_12_Locale)/sizeof(CaseUnfold_12_Type));
	   i++) {
	for (j = 0; j < CaseUnfold_12_Locale[i].to.n; j++) {
	  r = (*f)(CaseUnfold_12_Locale[i].to.code[j],
		   (OnigCodePoint* )CaseUnfold_12_Locale[i].from, 2, arg);
	  if (r != 0) return r;	

	  for (k = 0; k < CaseUnfold_12_Locale[i].to.n; k++) {
	    if (k == j) continue;

	    r = (*f)(CaseUnfold_12_Locale[i].to.code[j],
		     (OnigCodePoint* )(&CaseUnfold_12_Locale[i].to.code[k]),
		     1, arg);
	    if (r != 0) return r;
	  }
	}
      }
#ifdef USE_UNICODE_CASE_FOLD_TURKISH_AZERI
    }
#endif

    for (i = 0; i < (int )(sizeof(CaseUnfold_13)/sizeof(CaseUnfold_13_Type));
	 i++) {
      for (j = 0; j < CaseUnfold_13[i].to.n; j++) {
	r = (*f)(CaseUnfold_13[i].to.code[j],
		 (OnigCodePoint* )CaseUnfold_13[i].from, 3, arg);
	if (r != 0) return r;	

	for (k = 0; k < CaseUnfold_13[i].to.n; k++) {
	  if (k == j) continue;

	  r = (*f)(CaseUnfold_13[i].to.code[j],
		   (OnigCodePoint* )(&CaseUnfold_13[i].to.code[k]), 1, arg);
	  if (r != 0) return r;
	}
      }
    }
  }

  return 0;
}

extern int
onigenc_unicode_get_case_fold_codes_by_str(OnigEncoding enc,
    OnigCaseFoldType flag, const OnigUChar* p, const OnigUChar* end,
    OnigCaseFoldCodeItem items[])
{
  int n, i, j, k, len;
  OnigCodePoint code, codes[3];
  CodePointList3 *to, *z3;
  CodePointList2 *z2;

  if (CaseFoldInited == 0) init_case_fold_table();

  n = 0;

  code = ONIGENC_MBC_TO_CODE(enc, p, end);
  len = enclen(enc, p);

#ifdef USE_UNICODE_CASE_FOLD_TURKISH_AZERI
  if ((flag & ONIGENC_CASE_FOLD_TURKISH_AZERI) != 0) {
    if (code == 0x0049) {
      items[0].byte_len = len;
      items[0].code_len = 1;
      items[0].code[0]  = 0x0131;
      return 1;
    }
    else if (code == 0x0130) {
      items[0].byte_len = len;
      items[0].code_len = 1;
      items[0].code[0]  = 0x0069;
      return 1;
    }
    else if (code == 0x0131) {
      items[0].byte_len = len;
      items[0].code_len = 1;
      items[0].code[0]  = 0x0049;
      return 1;
    }
    else if (code == 0x0069) {
      items[0].byte_len = len;
      items[0].code_len = 1;
      items[0].code[0]  = 0x0130;
      return 1;
    }
  }
#endif

  if (onig_st_lookup(FoldTable, (st_data_t )code, (void* )&to) != 0) {
    if (to->n == 1) {
      OnigCodePoint orig_code = code;

      items[0].byte_len = len;
      items[0].code_len = 1;
      items[0].code[0]  = to->code[0];
      n++;

      code = to->code[0];
      if (onig_st_lookup(Unfold1Table, (st_data_t )code, (void* )&to) != 0) {
	for (i = 0; i < to->n; i++) {
	  if (to->code[i] != orig_code) {
	    items[n].byte_len = len;
	    items[n].code_len = 1;
	    items[n].code[0]  = to->code[i];
	    n++;
	  }
	}
      }
    }
    else if ((flag & INTERNAL_ONIGENC_CASE_FOLD_MULTI_CHAR) != 0) {
      OnigCodePoint cs[3][4];
      int fn, ncs[3];

      for (fn = 0; fn < to->n; fn++) {
	cs[fn][0] = to->code[fn];
	if (onig_st_lookup(Unfold1Table, (st_data_t )cs[fn][0],
			   (void* )&z3) != 0) {
	  for (i = 0; i < z3->n; i++) {
	    cs[fn][i+1] = z3->code[i];
	  }
	  ncs[fn] = z3->n + 1;
	}
	else
	  ncs[fn] = 1;
      }

      if (fn == 2) {
	for (i = 0; i < ncs[0]; i++) {
	  for (j = 0; j < ncs[1]; j++) {
	    items[n].byte_len = len;
	    items[n].code_len = 2;
	    items[n].code[0]  = cs[0][i];
	    items[n].code[1]  = cs[1][j];
	    n++;
	  }
	}

	if (onig_st_lookup(Unfold2Table, (st_data_t )to->code,
			   (void* )&z2) != 0) {
	  for (i = 0; i < z2->n; i++) {
	    if (z2->code[i] == code) continue;

	    items[n].byte_len = len;
	    items[n].code_len = 1;
	    items[n].code[0]  = z2->code[i];
	    n++;
	  }
	}
      }
      else {
	for (i = 0; i < ncs[0]; i++) {
	  for (j = 0; j < ncs[1]; j++) {
	    for (k = 0; k < ncs[2]; k++) {
	      items[n].byte_len = len;
	      items[n].code_len = 3;
	      items[n].code[0]  = cs[0][i];
	      items[n].code[1]  = cs[1][j];
	      items[n].code[2]  = cs[2][k];
	      n++;
	    }
	  }
	}

	if (onig_st_lookup(Unfold3Table, (st_data_t )to->code,
			   (void* )&z2) != 0) {
	  for (i = 0; i < z2->n; i++) {
	    if (z2->code[i] == code) continue;

	    items[n].byte_len = len;
	    items[n].code_len = 1;
	    items[n].code[0]  = z2->code[i];
	    n++;
	  }
	}
      }

      /* multi char folded code is not head of another folded multi char */
      flag = 0; /* DISABLE_CASE_FOLD_MULTI_CHAR(flag); */
    }
  }
  else {
    if (onig_st_lookup(Unfold1Table, (st_data_t )code, (void* )&to) != 0) {
      for (i = 0; i < to->n; i++) {
	items[n].byte_len = len;
	items[n].code_len = 1;
	items[n].code[0]  = to->code[i];
	n++;
      }
    }
  }


  if ((flag & INTERNAL_ONIGENC_CASE_FOLD_MULTI_CHAR) != 0) {
    p += len;
    if (p < end) {
      int clen;

      codes[0] = code;
      code = ONIGENC_MBC_TO_CODE(enc, p, end);
      if (onig_st_lookup(FoldTable, (st_data_t )code, (void* )&to) != 0
	  && to->n == 1) {
	codes[1] = to->code[0];
      }
      else
	codes[1] = code;

      clen = enclen(enc, p);
      len += clen;
      if (onig_st_lookup(Unfold2Table, (st_data_t )codes, (void* )&z2) != 0) {
	for (i = 0; i < z2->n; i++) {
	  items[n].byte_len = len;
	  items[n].code_len = 1;
	  items[n].code[0]  = z2->code[i];
	  n++;
	}
      }

      p += clen;
      if (p < end) {
	code = ONIGENC_MBC_TO_CODE(enc, p, end);
	if (onig_st_lookup(FoldTable, (st_data_t )code, (void* )&to) != 0
	    && to->n == 1) {
	  codes[2] = to->code[0];
	}
	else
	  codes[2] = code;

	clen = enclen(enc, p);
	len += clen;
	if (onig_st_lookup(Unfold3Table, (st_data_t )codes,
			   (void* )&z2) != 0) {
	  for (i = 0; i < z2->n; i++) {
	    items[n].byte_len = len;
	    items[n].code_len = 1;
	    items[n].code[0]  = z2->code[i];
	    n++;
	  }
	}
      }
    }
  }

  return n;
}
