//
//  CollectedShip.m
//  KanColleLevelManager
//
//  Created by Hori,Masaki on 2013/10/14.
//  Copyright (c) 2013年 Hori,Masaki. All rights reserved.
//

#import "CollectedShip.h"

#import "HMAppDelegate.h"


@implementation CollectedShip

@dynamic exp;
@dynamic level;
@dynamic nextLevelExp;
@dynamic fleetNumber;
@dynamic fleetOrder;

@dynamic ship;


+ (NSSet *)keyPathsForValuesAffectingLevel
{
	return [NSSet setWithObject:@"exp"];
}
+ (NSSet *)keyPathsForValuesAffectingNextLevelExp
{
	return [NSSet setWithObject:@"exp"];
}

- (NSNumber *)level
{
	NSArray *table = ((HMAppDelegate *)[NSApp delegate]).levelUpExp;
	
	NSUInteger index = [table indexOfObject:self.exp
							  inSortedRange:NSMakeRange(0, [table count])
									options:NSBinarySearchingInsertionIndex
							usingComparator:^(id obj1, id obj2) {
								return [obj1 compare:obj2];
							}];
	NSNumber *establish = [table objectAtIndex:index];
	if([establish compare:self.exp] == NSOrderedSame) {
		index++;
	}
	return [NSNumber numberWithInteger:index];
}
- (void)setLevel:(NSNumber *)level
{
	if([level integerValue] <= 0) return;
	
	NSArray *table = ((HMAppDelegate *)[NSApp delegate]).levelUpExp;
	id aExp = [table objectAtIndex:[level integerValue] - 1];
//	NSLog(@"exp for level %@ -> %@", level, aExp);
	self.exp = aExp;
}

- (NSNumber *)nextLevelExp
{
	NSArray *table = ((HMAppDelegate *)[NSApp delegate]).levelUpExp;
	NSUInteger nextExp = [[table objectAtIndex:[self.level integerValue]] integerValue];
	
	return [NSNumber numberWithInteger:nextExp - [self.exp integerValue]];
}
- (void)setNextLevelExp:(NSNumber *)nextLevelExp
{
	if([nextLevelExp integerValue] <= 0) return;
	
	id current = self.nextLevelExp;
	NSInteger diff = [current integerValue] - [nextLevelExp integerValue];
	self.exp = [NSNumber numberWithInteger:[self.exp integerValue] + diff];
}

@end
