//
//  KCBattleViewController.m
//  KanColleLevelManager
//
//  Created by Hori,Masaki on 2013/10/31.
//  Copyright (c) 2013年 Hori,Masaki. All rights reserved.
//

#import "KCBattleViewController.h"

#import "HMAppDelegate.h"


@interface KCBattleViewController ()

@end

@implementation KCBattleViewController

- (id)init
{
    self = [super initWithNibName:NSStringFromClass([self class]) bundle:nil];
    if (self) {
        // Initialization code here.
    }
    return self;
}

- (void)awakeFromNib
{
	
	[self updateAreaSegment];
	[self.areaSegment setSelectedSegment:0];
	
	[self updatePlanSegment];
	
}

- (NSManagedObjectContext *)managedObjectContext
{
	return ((HMAppDelegate *)[NSApp delegate]).managedObjectContext;
}

- (NSObjectController *)controller
{
	return self.planConroller;
}

- (NSArray *)areas
{
	NSFetchRequest *req = [NSFetchRequest fetchRequestWithEntityName:@"Area"];
	NSSortDescriptor *sortDesc = [NSSortDescriptor sortDescriptorWithKey:@"id" ascending:YES];
	[req setSortDescriptors:@[sortDesc]];
	
	return [self.managedObjectContext executeFetchRequest:req
													error:NULL];
}
- (NSArray *)planWithAreaID:(NSNumber *)identifire
{
	NSFetchRequest *req = [NSFetchRequest fetchRequestWithEntityName:@"Plan"];
	NSSortDescriptor *sortDesc = [NSSortDescriptor sortDescriptorWithKey:@"areaExp" ascending:YES];
	NSPredicate	*predicate = [NSPredicate predicateWithFormat:@"area.id = %@", identifire];
	[req setSortDescriptors:@[sortDesc]];
	[req setPredicate:predicate];
	
	return [self.managedObjectContext executeFetchRequest:req
													error:NULL];
}

- (void)updateAreaSegment
{
	NSRect frame = self.areaSegment.frame;
	
	NSArray *areas = self.areas;
	NSInteger count = [areas count];
	
	[self.areaSegment setSegmentCount:count];
	
	for(NSInteger i = 0; i < count; i++) {
		id area = [areas objectAtIndex:i];
		[self.areaSegment setLabel:[area valueForKey:@"name"]
						forSegment:i];
	}
	self.areaSegment.frame = frame;
}

- (void)updatePlanSegment
{
	NSRect frame = self.planSegment.frame;
	
	NSUInteger areaID = [self.areaSegment selectedSegment] + 1;
	
	NSArray *plans = [self planWithAreaID:@(areaID)];
	NSInteger count = [plans count];
	
	[self.planSegment setSegmentCount:count];
	
	for(NSInteger i = 0; i < count; i++) {
		id plan = [plans objectAtIndex:i];
		[self.planSegment setLabel:[plan valueForKey:@"planName"]
						forSegment:i];
	}
	self.planSegment.frame = frame;
	
	[self.planSegment setSelectedSegment:0];
	[self selectPlan:nil];
}

- (IBAction)selectArea:(id)sender
{
	[self updatePlanSegment];
}

- (IBAction)selectPlan:(id)sender
{
	NSString *planName = [self.planSegment labelForSegment:[self.planSegment selectedSegment]];
	NSFetchRequest *req = [NSFetchRequest fetchRequestWithEntityName:@"Plan"];
	NSPredicate	*predicate = [NSPredicate predicateWithFormat:@"planName = %@", planName];
	[req setPredicate:predicate];
	
	NSArray *plans = [self.managedObjectContext executeFetchRequest:req
															  error:NULL];
	if(!plans) {
		NSBeep();
		return;
	}
	
	id plan = [plans objectAtIndex:0];
	self.planConroller.content = plan;
}

@end
