//
//  KCDataImporter.m
//  KanColleLevelManager
//
//  Created by Hori,Masaki on 2013/11/05.
//  Copyright (c) 2013年 Hori,Masaki. All rights reserved.
//

#import "KCDataImporter.h"

#import "HMAppDelegate.h"

@interface KCDataImporter ()
@property (readonly) NSManagedObjectContext *managedObjectContext;

@property (copy) NSDictionary *types;

- (void)appendTypeIfNeeded;
- (void)appendAreaIfNeeded;
- (void)appendShipIfNeeded;

@end

@implementation KCDataImporter

- (NSManagedObjectContext *)managedObjectContext
{
	return ((HMAppDelegate *)[NSApp delegate]).managedObjectContext;
}


- (void)buildData;
{
	[self appendTypeIfNeeded];
	[self appendAreaIfNeeded];
	[self appendShipIfNeeded];
}

- (void)appendTypeIfNeeded
{
	NSMutableDictionary *typesObject = [NSMutableDictionary dictionary];
	
	NSFetchRequest *req = [NSFetchRequest fetchRequestWithEntityName:@"ShipType"];
	NSArray *existedType = [self.managedObjectContext executeFetchRequest:req
																	error:NULL];
	NSMutableArray *existedTypeName = [NSMutableArray new];
	for(id type in existedType) {
		[existedTypeName addObject:[type valueForKey:@"name"]];
		[typesObject setObject:type forKey:[type valueForKey:@"name"]];
	}
	
	NSBundle *mainBundle = [NSBundle mainBundle];
	NSString *path = [mainBundle pathForResource:@"AllTypes" ofType:@"plist"];
	NSDictionary *types = [NSDictionary dictionaryWithContentsOfFile:path];
	
	for(id key in types) {
		if([existedTypeName containsObject:key]) continue;
		id obj = [NSEntityDescription insertNewObjectForEntityForName:@"ShipType"
											   inManagedObjectContext:self.managedObjectContext];
		id value = [types valueForKey:key];
		[obj setValue:key forKey:@"name"];
		[obj setValue:value forKey:@"shortName"];
		[typesObject setObject:obj forKey:key];
	}
	
	self.types = typesObject;
}

- (void)appendAreaIfNeeded
{
	NSFetchRequest *req = [NSFetchRequest fetchRequestWithEntityName:@"Area"];
	NSArray *existedArea = [self.managedObjectContext executeFetchRequest:req
																	error:NULL];
	NSMutableArray *existedAreaName = [NSMutableArray new];
	for(id area in existedArea) {
		[existedAreaName addObject:[area valueForKey:@"name"]];
	}
	
	NSBundle *mainBundle = [NSBundle mainBundle];
	NSString *path = [mainBundle pathForResource:@"BattleArea" ofType:@"plist"];
	NSArray *areas = [NSArray arrayWithContentsOfFile:path];
	NSMutableDictionary *areaDict = [NSMutableDictionary new];
	NSInteger identifier = 1;
	for(id area in areas) {
		id name = [area objectForKey:@"areaName"];
		if([existedAreaName containsObject:name]) continue;
		
		id areaEnt = [areaDict objectForKey:name];
		if(!areaEnt) {
			areaEnt = [NSEntityDescription insertNewObjectForEntityForName:@"Area"
													inManagedObjectContext:self.managedObjectContext];
			[areaEnt setValue:name forKey:@"name"];
			[areaEnt setValue:@(identifier++) forKey:@"id"];
			[areaDict setObject:areaEnt forKey:name];
		}
		
		id obj = [NSEntityDescription insertNewObjectForEntityForName:@"Plan"
											   inManagedObjectContext:self.managedObjectContext];
		NSArray *keys = @[@"subAreaName", @"level", @"areaExp", @"planName", @"account"];
		for(id key in keys) {
			id val = [area objectForKey:key];
			[obj setValue:val forKey:key];
		}
		[obj setValue:areaEnt forKey:@"area"];
		id plans = [areaEnt mutableSetValueForKey:@"plans"];
		[plans addObject:obj];
	}
	
	NSError *error = nil;
	if(![self.managedObjectContext save:&error]) {
		NSLog(@"Error -> %@\n%@\n%@", [error localizedDescription], [error localizedFailureReason], [error localizedRecoverySuggestion]);
		[NSApp terminate:nil];
	}
}

- (void)appendShipIfNeeded
{
	NSFetchRequest *req = [NSFetchRequest fetchRequestWithEntityName:@"Ship"];
	NSArray *existedShip = [self.managedObjectContext executeFetchRequest:req
																	error:NULL];
	NSMutableArray *existedShipName = [NSMutableArray new];
	for(id ship in existedShip) {
		[existedShipName addObject:[ship valueForKey:@"name"]];
	}
	
	NSBundle *mainBundle = [NSBundle mainBundle];
	NSString *path = [mainBundle pathForResource:@"AllShips" ofType:@"plist"];
	NSArray *ships = [NSArray arrayWithContentsOfFile:path];
	for(id ship in ships) {
		id name = [ship valueForKey:@"name"];
		if([existedShipName containsObject:name]) {
			// check new upgrade
			NSPredicate *predicate = [NSPredicate predicateWithFormat:@"name = %@", name];
			[req setPredicate:predicate];
			NSArray *oldData = [self.managedObjectContext executeFetchRequest:req
																		error:NULL];
			id old = oldData[0];
			NSNumber *oldUpdateLevel = [old valueForKey:@"updateLevel"];
			if(oldUpdateLevel) continue;
			
			NSNumber *newUpdateLevel = [ship valueForKey:@"next"];
			if(!newUpdateLevel) continue;
			
			[old setValue:newUpdateLevel forKey:@"updateLevel"];
			
			id next = [ship valueForKey:@"nextNum"];
			[old setValue:next forKey:@"updateNumber"];
			
			continue;
		}
		
		id obj = [NSEntityDescription insertNewObjectForEntityForName:@"Ship"
											   inManagedObjectContext:self.managedObjectContext];
		[obj setValue:name forKey:@"name"];
		
		id type = [ship valueForKey:@"type"];
		id typeObj = [self.types valueForKey:type];
		[obj setValue:typeObj forKey:@"type"];
		
		id number = [ship valueForKey:@"id"];
		[obj setValue:number forKey:@"number"];
		
		id next = [ship	objectForKey:@"next"];
		if(next) {
			[obj setValue:next forKey:@"updateLevel"];
		}
		
		id nextNumber = [ship objectForKey:@"nextNum"];
		if(nextNumber) {
			[obj setValue:nextNumber forKey:@"updateNumber"];
		}
	}
	
	NSError *error = nil;
	if(![self.managedObjectContext save:&error]) {
		NSLog(@"Error -> %@\n%@\n%@", [error localizedDescription], [error localizedFailureReason], [error localizedRecoverySuggestion]);
		[NSApp terminate:nil];
	}
}

@end
