//
//  KCFleetViewController.m
//  KanColleLevelManager
//
//  Created by Hori,Masaki on 2013/10/26.
//  Copyright (c) 2013年 Hori,Masaki. All rights reserved.
//

#import "KCFleetViewController.h"

#import "KCShipViewController.h"

#import "HMAppDelegate.h"
#import "CollectedShip.h"


@interface KCFleetViewController ()
@property (retain) NSMutableArray *ships;

@end

@implementation KCFleetViewController

- (id)init
{
    self = [super initWithNibName:NSStringFromClass([self class]) bundle:nil];
    if (self) {
		_ships = [NSMutableArray new];
    }
    return self;
}

- (void)awakeFromNib
{
	NSArray *views = @[self.flagShipPlaceholder,
					   self.secondShipPlaceholder,
					   self.thirdShipPlaceholder,
					   self.fourthShipPlaceholder,
					   self.fifthShipPlaceholder,
					   self.sixthShipPlaceholder];
	
	for(int i = 0; i < 6; i++) {
		self.ships[i] = [KCShipViewController new];
		NSView *view = [self.ships[i] view];
		view.frame = [views[i] frame];
		[[views[i] superview] replaceSubview:views[i] with:view];
	}
	
	self.fleetNumber = @1;
	
	
	[self.selectedFleet addObserver:self
						 forKeyPath:@"selection"
							options:0
							context:NULL];
	
	
	NSSortDescriptor *sortDesc = [NSSortDescriptor sortDescriptorWithKey:@"fleetOrder"
															   ascending:YES];
	[self.selectedFleet setSortDescriptors:@[sortDesc]];
}

- (void)update
{
	// deselect fleet
	for(NSViewController *controller in self.ships) {
		controller.representedObject = nil;
	}
	
	if([[self.selectedFleet arrangedObjects] count] > 6) {
		NSLog(@"fleet ship over 6!!!! -> \n %@", [self.selectedFleet arrangedObjects]);
		return;
	}
	
	for(CollectedShip *ship in [self.selectedFleet arrangedObjects]) {
		NSInteger order = [ship.fleetOrder integerValue];
		if(order == 0) {
			NSLog(@"Fleet Order is 0 for %@", [ship.ship valueForKey:@"name"]);
			return;
		}
		[self.ships[[ship.fleetOrder integerValue] - 1] setRepresentedObject:ship];
	}
}

- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context
{
	[self update];
}

- (NSManagedObjectContext *)managedObjectContext
{
	return ((HMAppDelegate *)[NSApp delegate]).managedObjectContext;
}

- (NSPredicate *)predicateWithFleetNumber:(NSNumber *)fleetNumber
{
	return [NSPredicate predicateWithFormat:@"fleetNumber = %@", fleetNumber];
}

- (void)setFleetNumber:(NSNumber *)fleetNumber
{
	if([_fleetNumber isEqual:fleetNumber]) return;
	
	_fleetNumber = fleetNumber;
	[self.selectedFleet setFetchPredicate:[self predicateWithFleetNumber:self.fleetNumber]];
}


- (IBAction)selectFleet:(id)sender
{
	NSSegmentedControl *segmentControl = sender;
	NSInteger segment = [segmentControl selectedSegment];
	NSInteger tag = [[segmentControl cell] tagForSegment:segment];
	
	self.fleetNumber = @(tag);
}

@end
