#!/bin/sh

. ./_blfsset.sh

APPNAME=Node.js
VER=7.10.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/v$VER.tar.gz
TARGETDIR=node-$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	python-2
. $WRK/_checkOptions.sh  \
	c-ares icu openssl
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

if [ ${OPTION_icu} -eq "1" ]; then
  Patching
  patch -Np1 -i $DLD/node-$VER-icu59-1.patch \
        1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
fi

Configuring
./configure --prefix=/usr          \
            --shared-cares         \
            --shared-openssl       \
            --shared-zlib          \
$([ ${OPTION_icu} -eq 1 ] && echo --with-intl=system-icu) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make -j1 \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sf node /usr/share/doc/node-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

