#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=libinput
VER=1.11.3
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	libevdev mtdev
. $WRK/_checkOptions.sh  \
	doxygen valgrind graphviz \
	gtk+-3 libunwind libwacom
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

mkdir build
cd    build

Configuring
meson --prefix=$XORG_PREFIX \
      -Dudev-dir=/lib/udev  \
      -Ddebug-gui=false     \
      -Dtests=false         \
      -Ddocumentation=false \
$([ ${OPTION_libwacom} -ne 1 ] && echo -Dlibwacom=false) \
$([ ${OPTION_libwacom} -eq 1 ] && echo -Dlibwacom=true) \
      -Dlibwacom=false      \
      ..                    \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
ninja \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "ninja install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone
