#!/bin/sh

. ../_blfsset.sh
. ./_xorgset.sh

APPNAME=xorgproto
VER=2019.2
TARGET=$APPNAME-$VER
TARGETBALL=$XORGDLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	util-macros
. $WRK/_checkOptions.sh  \
	fop libxslt xmlto asciidoc
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

mkdir build
cd    build

Configuring
meson --prefix=$XORG_PREFIX .. \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
ninja \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

PWD=`pwd`
Installing
porg -lp $TARGET -E$PWD "ninja install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

install -vdm 755 $XORG_PREFIX/share/doc/xorgproto-$VER \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install -vm 644 ../[^m]*.txt ../PM_spec $XORG_PREFIX/share/doc/xorgproto-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

