#!/bin/sh

. ./_blfsset.sh

APPNAME=apt
VER=1.4.8
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${APPNAME}_$VER.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	cmake dpkg po4a
. $WRK/_checkOptions.sh  \
	lz4
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

mkdir build
cd    build

Configuring
cmake -DCMAKE_BUILD_TYPE=Release                      \
      -DCMAKE_INSTALL_PREFIX=/usr                     \
      -DINSTALL_MANDIR=share/man                      \
      -DSKIP_TESTS=ON                                 \
      -DWITH_DOC=NO                                   \
      .. \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET -E`pwd` "\
make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

