#!/bin/sh

. ./_blfsset.sh

APPNAME=autogen
VER=5.18.7
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	guile
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $WRK/autogen-$VER-guile-2.2.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

echo Autoconfig...
autoreconf \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1

Configuring
GUILE_VERSION=$VER \
./configure --prefix=/usr \
	--disable-dependency-tracking \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
GUILE_VERSION=$VER \
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

