#!/bin/sh

#ln -sv /usr/include/python3.7m /usr/include/python3.7

. ./_blfsset.sh

APPNAME=boost
VER=1.68.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${APPNAME}_1_68_0.tar.bz2
TARGETDIR=${APPNAME}_1_68_0

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	icu python-2
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Bootstrapping
./bootstrap.sh --prefix=/usr \
	--with-python=python3 \
	1> $LOG/$TARGET.1_boot.log 2>&1 || exit 1

Making
./b2 stage threading=multi link=shared \
	1> $LOG/$TARGET.2_make.log 2>&1 || (echo Error occured!)

Installing
porg -lp $TARGET "\
./b2 install threading=multi link=shared" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
ln -svf detail/sha1.hpp /usr/include/boost/uuid/sha1.hpp" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

