#!/bin/sh

. ./_blfsset.sh

APPNAME=cups
VER=2.1.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${TARGET}-source.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	libjpeg-turbo libpng tiff tcp_wrappers dbus libusb \
	acl Linux-PAM openldap gnutls openssl heimdal \
	php python jdk xdg-utils openslp libpaper \
	valgrind
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

useradd -c "Print Service User" -d /var/spool/cups -g lp -s /bin/false -u 9 lp
groupadd -g 19 lpadmin

cd $TARGETDIR

#Patching
#patch -Np1 -i $DLD/cups-$VER-content_type-1.patch \
#	1>  $LOG/$TARGET.0_patch.log 2>&1 || exit 1
#patch -Np1 -i $DLD/cups-$VER-blfs-1.patch \
#	1>> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

sed -i 's:555:755:g;s:444:644:g' Makedefs.in
sed -i '/MAN.*.EXT/s:.gz::g' \
       configure config-scripts/cups-manpages.m4
sed -i '/LIBGCRYPTCONFIG/d' config-scripts/cups-ssl.m4
sed -i 's@else /\* HAVE_AVAHI \*/@elif defined(HAVE_AVAHI)@' test/ippserver.c

echo Autoconfing...
aclocal -I config-scripts \
	1> $LOG/$TARGET.1_auto.log 2>&1 || exit 1
autoconf -I config-scripts \
	1>> $LOG/$TARGET.1_auto.log 2>&1 || exit 1

Configuring
./configure --libdir=/usr/lib            \
            --disable-systemd            \
            --with-rcdir=/tmp/cupsinit   \
            --with-system-groups=lpadmin \
            --with-docdir=/usr/share/cups/doc-$VER \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

rm -rf /tmp/cupsinit
porg -lp+ $TARGET "\
ln -sv ../cups/doc-$VER /usr/share/doc/cups-$VER" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

echo "ServerName /var/run/cups/cups.sock" > /etc/cups/client.conf
porg -lp+ $TARGET "\
touch /etc/cups/client.conf"

porg -lp+ $TARGET "\
rm -rf /usr/share/cups/banners"
porg -lp+ $TARGET "\
rm -rf /usr/share/cups/data/testprint"

cat > /etc/pam.d/cups << "EOF"
# Begin /etc/pam.d/cups

auth    include system-auth
account include system-account
session include system-session

# End /etc/pam.d/cups
EOF

porg -lp+ $TARGET "\
chmod -v 644 /etc/pam.d/cups" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

