#!/bin/sh

. ./_blfsset.sh

APPNAME=fcron
VER=3.1.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.src.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	docbook-dsssl
. $WRK/_checkOptions.sh  \
	Linux-PAM docbook-utils
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

cat >> /etc/syslog.conf << "EOF"
# Begin fcron addition to /etc/syslog.conf

cron.* -/var/log/cron.log

# End fcron addition
EOF

/etc/rc.d/init.d/sysklogd reload

groupadd -g 22 fcron
useradd -d /dev/null -c "Fcron User" -g fcron -s /bin/false -u 22 fcron

Configuring
./configure --prefix=/usr --sysconfdir=/etc \
    --localstatedir=/var --without-sendmail --with-boot-install=no \
    --with-dsssl-dir=/usr/share/sgml/docbook/dsssl-stylesheets-1.79 \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

