#!/bin/sh

. ./_blfsset.sh

APPNAME=fuse
VER=3.9.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	doxygen
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i '/^udev/,$ s/^/#/' util/meson.build

mkdir build
cd    build

Configuring
meson --prefix=/usr .. \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
ninja \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "\
ninja install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
mv -vf   /usr/lib/libfuse3.so.3*     /lib " \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -sfvn ../../lib/libfuse3.so.$VER /usr/lib/libfuse3.so " \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
mv -vf /usr/bin/fusermount3  /bin" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
mv -vf /usr/sbin/mount.fuse3 /sbin" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
chmod u+s /bin/fusermount3

#porg -lp+ $TARGET "\
#install -v -m755 -d /usr/share/doc/fuse-$VER" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
#porg -lp+ $TARGET "\
#install -v -m644    ../doc/{README.NFS,kernel.txt} \
#                    /usr/share/doc/fuse-$VER" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
#porg -lp+ $TARGET "\
#cp -Rv ../doc/html  /usr/share/doc/fuse-$VER" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cat > /etc/fuse.conf << "EOF"
# Set the maximum number of FUSE mounts allowed to non-root users.
# The default is 1000.
#
#mount_max = 1000

# Allow non-root users to specify the 'allow_other' or 'allow_root'
# mount options.
#
#user_allow_other
EOF
porg -lp+ $TARGET "\
touch /etc/fuse.conf" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

