#!/bin/sh

. ./_blfsset.sh

APPNAME=gc
VER=7.6.4
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=gc-$VER

echo $TARGET

. $WRK/_checkRequired.sh \
	libatomic_ops
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i 's#pkgdata#doc#' doc/doc.am

Configuring
./configure --prefix=/usr \
            --enable-cplusplus \
            --disable-static   \
            --docdir=/usr/share/doc/gc-$VER \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET -E`pwd` "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

#porg -lp+ $TARGET "\
#install -v -m644 doc/gc.man /usr/share/man/man3/gc_malloc.3" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

