#!/bin/sh

. ./_blfsset.sh

APPNAME=glib
VER=2.62.4
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	pcre
. $WRK/_checkOptions.sh  \
	libxslt dbus gtk-doc elfutils
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

#LIBFIIVER=`porg libffi | sed s/libffi\-//`

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/glib-$VER-skip_warnings-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1

mkdir build
cd    build

Configuring
meson --prefix=/usr      \
      -Dman=false        \
      -Dselinux=disabled \
      ..                 \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
ninja -j1 \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET -E`pwd` "\
ninja install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

#mkdir -p /usr/share/doc/glib-$VER
#porg -lp+  $TARGET "\
#cp -r ../docs/reference/{NEWS,gio,glib,gobject} /usr/share/doc/glib-$VER" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

