#!/bin/sh

. ../_blfsset.sh
. ./_gnomeset.sh

APPNAME=gnome-online-accounts
VER=3.6.2
TARGET=$APPNAME-$VER
TARGETBALL=$GNOMEDLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	gcr libgnome-keyring libnotify librest \
        libsecret json-glib webkitgtk
. $WRK/_checkOptions.sh  \
	gobject-introspection gtk-doc krb5
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr \
            --libexecdir=/usr/lib/gnome-online-accounts \
            --disable-static \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
paco -p $TARGET "make install" \
	1> $LOG/$TARGET.3_instll.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PacoingDone

