#!/bin/sh

. ./_blfsset.sh

APPNAME=ImageMagick
VER=7.0.5-10
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	Xorg-lib-libX11 \
	pkg-config cups curl dmalloc electricfence \
	ffmpeg fftw pgp gnupg-1 gnupg-2 sane ufraw \
	wget xdg-utils \
	corefonts djvulibre flashpix jasper jbigkit lcms-1 \
	lcms2 libexif libjpeg-turbo libpng librsvg libtiff \
	libwebp liquidrescale openexr pango ralcgm 
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Configuring
./configure --prefix=/usr     \
            --sysconfdir=/etc \
	    --enable-hdri     \
            --with-modules    \
            --with-perl       \
            --disable-static  \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "\
make DOCUMENTATION_PATH=/usr/share/doc/imagemagick-7.0.4 install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

