#!/bin/sh

. ./_blfsset.sh

APPNAME=krb5
VER=1.16.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET \(Workaround\)

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	dejagnu keyutils openldap python-2 rpcbind
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

#if [ ${OPTION_openldap} -eq "1" ]; then
#  export WITHLDAP="--with-ldap "
#else
#  export WITHLDAP=" "
#fi

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

cd src

sed -i -e 's@\^u}@^u cols 300}@' tests/dejagnu/config/default.exp
sed -i -e '/eq 0/{N;s/12 //}'    plugins/kdb/db2/libdb2/test/run.test

Configuring
./configure --prefix=/usr            \
            --sysconfdir=/etc        \
            --localstatedir=/var/lib \
            --with-system-et         \
            --with-system-ss         \
            --with-system-verto=no   \
            --enable-dns-for-realm   \
	$([ ${OPTION_openldap} -eq 1 ] && echo --with-ldap) \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

for LIBRARY in gssapi_krb5 gssrpc k5crypto kadm5clnt kadm5srv \
               kdb5 kdb_ldap krad krb5 krb5support verto ; do
    find /usr/lib -type f -name "lib$f*.so*" -exec chmod -v 755 {} \; \
	1>> $LOG/$TARGET.3_install.log 2>&1 || echo Error when chmod
done

porg -lp+ $TARGET "\
mv -v /usr/lib/libkrb5.so.3*        /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
mv -v /usr/lib/libk5crypto.so.3*    /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
mv -v /usr/lib/libkrb5support.so.0* /lib" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
ln -v -sf ../../lib/libkrb5.so.3.3        /usr/lib/libkrb5.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -v -sf ../../lib/libk5crypto.so.3.1    /usr/lib/libk5crypto.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
ln -v -sf ../../lib/libkrb5support.so.0.1 /usr/lib/libkrb5support.so" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
mv -v /usr/bin/ksu /bin" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
chmod -v 755 /bin/ksu \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

#install -v -dm755 /usr/share/doc/krb5-$VER \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

#porg -lp+ $TARGET "\
#cp -vfr ../doc/* /usr/share/doc/krb5-$VER" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
RemoveSrcDir
PorgingDone

