#!/bin/sh

. ./_blfsset.sh

APPNAME=libpaper
VER=1.1.24
TARGET=${APPNAME}_$VER+nmu5
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=libpaper-$VER+nmu5

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Autoreconfing...
autoreconf -fi \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr     \
            --sysconfdir=/etc \
            --disable-static  \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGETDIR "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

mkdir -p /etc/libpaper.d

cat > /usr/bin/run-parts << "EOF"
#!/bin/sh
# run-parts:  Runs all the scripts found in a directory.
# from Slackware, by Patrick J. Volkerding with ideas borrowed
# from the Red Hat and Debian versions of this utility.

# keep going when something fails
set +e

if [ $# -lt 1 ]; then
  echo "Usage: run-parts <directory>"
  exit 1
fi

if [ ! -d $1 ]; then
  echo "Not a directory: $1"
  echo "Usage: run-parts <directory>"
  exit 1
fi

# There are several types of files that we would like to
# ignore automatically, as they are likely to be backups
# of other scripts:
IGNORE_SUFFIXES="~ ^ , .bak .new .rpmsave .rpmorig .rpmnew .swp"

# Main loop:
for SCRIPT in $1/* ; do
  # If this is not a regular file, skip it:
  if [ ! -f $SCRIPT ]; then
    continue
  fi
  # Determine if this file should be skipped by suffix:
  SKIP=false
  for SUFFIX in $IGNORE_SUFFIXES ; do
    if [ ! "$(basename $SCRIPT $SUFFIX)" = "$(basename $SCRIPT)" ]; then
      SKIP=true
      break
    fi
  done
  if [ "$SKIP" = "true" ]; then
    continue
  fi
  # If we've made it this far, then run the script if it's executable:
  if [ -x $SCRIPT ]; then
    $SCRIPT || echo "$SCRIPT failed."
  fi
done

exit 0
EOF
chmod 755 /usr/bin/run-parts
porg -lp+ $TARGETDIR "\
touch /usr/bin/run-parts" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cat > /etc/papersize << "EOF"
a4
EOF
porg -lp+ $TARGETDIR "\
touch /etc/papersize" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone $TARGETDIR

