#!/bin/sh

. ./_blfsset.sh

APPNAME=lua
VER=5.3.5
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

cat > lua.pc << "EOF"
V=5.3
R=5.3.5

prefix=/usr
INSTALL_BIN=${prefix}/bin
INSTALL_INC=${prefix}/include
INSTALL_LIB=${prefix}/lib
INSTALL_MAN=${prefix}/share/man/man1
INSTALL_LMOD=${prefix}/share/lua/${V}
INSTALL_CMOD=${prefix}/lib/lua/${V}
exec_prefix=${prefix}
libdir=${exec_prefix}/lib
includedir=${prefix}/include

Name: Lua
Description: An Extensible Extension Language
Version: ${R}
Requires:
Libs: -L${libdir} -llua -lm -ldl
Cflags: -I${includedir}
EOF

#echo Patching unofficial...
#patch -Np1 -i $WRK/patch/lua-$VER.patch \
Patching
patch -Np1 -i $DLD/lua-$VER-shared_library-1.patch \
	1> $LOG/$TARGET.0_patch.log 2>&1 || exit 1
sed -i '/#define LUA_ROOT/s:/usr/local/:/usr/:' src/luaconf.h

Making
make MYCFLAGS="-DLUA_COMPAT_5_2 -DLUA_COMPAT_5_1" linux \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "\
make INSTALL_TOP=/usr                \
     INSTALL_DATA=\"cp -d\"          \
     INSTALL_MAN=/usr/share/man/man1 \
     TO_LIB=\"liblua.so liblua.so.5.3 liblua.so.5.3.4\" \
     install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

#mkdir -p /usr/share/doc/lua-$VER
#porg -lp+ $TARGET "\
#cp -v doc/*.{html,css,gif,png} /usr/share/doc/lua-$VER" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
touch /usr/lib/pkgconfig/lua.pc"

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

