#!/bin/sh

. ../_blfsset.sh
. ./_lxdeset.sh

VER=0.5.0
TARGET=lxde-icon-theme-$VER
TARGETBALL=$LXDEDLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  \
	gtk+-2 gtk+-3
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
. $WRK/_rmdir.sh
. $WRK/_extract.sh $TARGETBALL

cd $TARGETDIR

echo Configuring...
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

echo Installing...
paco -p  $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cd ..
. $WRK/_rmdir.sh

echo -n Pacoing:\   && paco $TARGET || echo none

