#!/bin/sh

. ./_blfsset.sh

APPNAME=make-ca
VER=1.7
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	p11-kit
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Installing
PWD=`pwd`
porg -lp+ $TARGET -E"/tmp:$PWD" "\
make install" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
install -vdm755 /etc/ssl/local

/usr/sbin/make-ca -g

wget http://www.cacert.org/certs/root.crt
wget http://www.cacert.org/certs/class3.crt

porg -lp $TARGET "\
openssl x509 -in root.crt -text -fingerprint -setalias \"CAcert Class 1 root\" \
        -addtrust serverAuth -addtrust emailProtection -addtrust codeSigning \
        > /etc/ssl/local/CAcert_Class_1_root.pem" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
openssl x509 -in class3.crt -text -fingerprint -setalias \"CAcert Class 3 root\" \
        -addtrust serverAuth -addtrust emailProtection -addtrust codeSigning \
        > /etc/ssl/local/CAcert_Class_3_root.pem" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET -E"/tmp:$PWD" "\
/usr/sbin/make-ca -r -f" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

#porg -lp+ $TARGET -E"/tmp:$PWD" "\
#ln -sfv /etc/pki/tls/certs/ca-bundle.crt \
#        /etc/ssl/ca-bundle.crt" \
#	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

