#!/bin/sh

. ./_blfsset.sh

APPNAME=MarkupSafe
VER=1.1.1
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Making
python3 setup.py build \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

PWD=`pwd`
Installing
porg -lp $TARGET -E$PWD "\
python3 setup.py install --optimize=1" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

