#!/bin/sh

. ./_blfsset.sh

APPNAME=meson
VER=0.48.0
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Building
python3 setup.py build \
        1> $LOG/$TARGET.2_build.log 2>&1 || exit 1

echo Installing...
python3 setup.py install --root=dest \
        1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp $TARGET "\
cp -rv dest/* /" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

