#!/bin/sh

. ./_blfsset.sh

APPNAME=po4a
VER=0.57
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	Module-Build docbook-xml docbook-xsl-nons
. $WRK/_checkOptions.sh  \
	YAML-Tiny
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

echo Executing perl Build.PL...
perl Build.PL \
	1> $LOG/$TARGET.1_Build.PL.log 2>&1 || exit 1

echo Building...
./Build \
	1> $LOG/$TARGET.2_build.log 2>&1 || exit 1

Installing
porg -lp $TARGET "./Build install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

