#!/bin/sh

. ./_blfsset.sh

TARGET=blfs-systemd-units-$S_BOOTSCRIPTDATE
SCRIPT=install-dhcpcd
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $SCRIPT

. $WRK/_checkRequired.sh dhcpcd
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Installing
porg -lp "$SCRIPT" "make $SCRIPT" \
	1> $LOG/${SCRIPT}_1.install.log 2>&1 || (echo Error occured && exit 1)

systemctl enable dhcpcd@eth0
systemctl enable systemd-networkd

TimeEnd

cd ..
RemoveSrcDir
PorgingDone $SCRIPT

