#!/bin/sh

. ./_blfsset.sh

APPNAME=sgml-common
VER=0.6.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tgz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

Patching
patch -Np1 -i $DLD/sgml-common-$VER-manpage-1.patch

echo Autoconfing...
autoreconf -f -i \
	1> $LOG/$TARGET.0_auto.log 2>&1 || exit 1

Configuring
./configure --prefix=/usr --sysconfdir=/etc \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install-catalog --add /etc/sgml/sgml-ent.cat \
    /usr/share/sgml/sgml-iso-entities-8879.1986/catalog" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
install-catalog --add /etc/sgml/sgml-docbook.cat \
    /etc/sgml/sgml-ent.cat" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone

