#!/bin/sh

. ./_blfsset.sh

APPNAME=squashfs
VER=4.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/${APPNAME}${VER}.tar.gz
TARGETDIR=${APPNAME}${VER}

echo $TARGET

. $WRK/_checkRequired.sh ""
. $WRK/_checkOptions.sh  ""
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR/squashfs-tools

sed -i '/INSTALL_DIR/s/usr\/local/usr/' Makefile

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ../..
#RemoveSrcDir
PorgingDone

