#!/bin/sh

. ./_blfsset.sh

APPNAME=vala
VER=0.40.8
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh glib-2
. $WRK/_checkOptions.sh  \
	dbus graphviz libxslt \
	help2man weasyprint
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

if [ ${OPTION_graphviz} -ne "1" ]; then
  sed -i '115d; 121,137d; 139,140d'  configure.ac
  sed -i '/valadoc/d' Makefile.am
  ACLOCAL= autoreconf -fiv
fi

Configuring
./configure --prefix=/usr \
	1> $LOG/$TARGET.1_conf.log 2>&1 || exit 1

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp $TARGET "make install" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
PorgingDone
