#!/bin/sh

. ./_blfsset.sh

APPNAME=vsftpd
VER=3.0.3
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.gz
TARGETDIR=$TARGET

echo $TARGET

. $WRK/_checkRequired.sh \
	libnsl
. $WRK/_checkOptions.sh  \
	Linux-PAM \
	libcap2
. $WRK/_checkTarball.sh
. $WRK/_checkExit.sh "$1" || exit $?

unset MAKEFLAGS

cd $SRC
RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

install -v -d -m 0755 /usr/share/vsftpd/empty
install -v -d -m 0755 /home/ftp
groupadd -g 47 vsftpd
groupadd -g 45 ftp 
useradd -c "vsftpd User"  -d /dev/null -g vsftpd -s /bin/false -u 47 vsftpd
useradd -c anonymous_user -d /home/ftp -g ftp    -s /bin/false -u 45 ftp

Making
make \
	1> $LOG/$TARGET.2_make.log 2>&1 || exit 1

Installing
porg -lp  $TARGET "\
install -v -m 755 vsftpd        /usr/sbin/vsftpd" \
	1> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
install -v -m 644 vsftpd.8      /usr/share/man/man8" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
install -v -m 644 vsftpd.conf.5 /usr/share/man/man5" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1
porg -lp+ $TARGET "\
install -v -m 644 vsftpd.conf   /etc" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

porg -lp+ $TARGET "\
cp -p /etc/vsftpd.conf{,.orig}" \
	1>> $LOG/$TARGET.3_install.log 2>&1 || exit 1

cat >> /etc/vsftpd.conf << "EOF"
background=YES
listen=YES
nopriv_user=vsftpd
secure_chroot_dir=/usr/share/vsftpd/empty
local_enable=YES
EOF

TimeEnd

cat > /etc/pam.d/vsftpd << "EOF"
#%PAM-1.0
#auth       required    /lib/security/pam_listfile.so item=user sense=deny file=/etc/ftpusers onerr=succeed
auth       required     /lib/security/pam_unix.so shadow nullok
auth       required     /lib/security/pam_shells.so
account    required     /lib/security/pam_unix.so
session    required     /lib/security/pam_unix.so
EOF

porg -lp+ $TARGET "touch /etc/pam.d/vsftpd"

#cat > /etc/vsftpd.chroot_list << "EOF"
#root
#EOF
#porg -p+ $TARGET "touch /etc/vsftpd.chroot_list"

#cat > /etc/vsftpd.user_list << "EOF"
#root
#bin
#daemon
#adm
#lp
#sync
#shutdown
#halt
#mail
#news
#uucp
#operator
#games
#nobody
#EOF
#porg -lp+ $TARGET "touch /etc/vsftpd.user_list"

cd ..
RemoveSrcDir
PorgingDone

