#/bin/sh

THISFILE=`basename $0`
CHAP=`echo $THISFILE | sed s/\.sh//`

. ./_clfsset.sh

VER=2.15
TARGET=eglibc-$VER
TARGETBALL=$DLD/$TARGET-r21467.tar.xz
TARGETDIR=$TARGET

echo $CHAP: $TARGET

cd $SRC

RemoveSrcDir
Extract

TimeStart

cd $TARGETDIR

sed -i 's/\(&& $name ne\) "db1"/ & \1 "nss_test1"/' scripts/test-installation.pl

LINKER=$(readelf -l /tools/bin/bash | sed -n 's@.*interpret.*/tools\(.*\)]$@\1@p')
sed -i "s|libs -o|libs -L/usr/lib -Wl,-dynamic-linker=${LINKER} -o|" \
  scripts/test-installation.pl
unset LINKER

echo Patching...
patch -Np1 -i $DLD/eglibc-$VER-fixes-1.patch \
        1> $LOG/$CHAP.$TARGET.0_patch.log 2>&1 || exit 1

mkdir -v ../eglibc-build
cd ../eglibc-build

echo Configuring...
CC="gcc ${BUILD32}" CXX="g++ ${BUILD32}" \
    CFLAGS="-march=$(cut -d- -f1 <<< ${CLFS_TARGET32}) \
    -mtune=generic -g -O2" ../eglibc-$VER/configure --prefix=/usr \
    --disable-profile --enable-kernel=2.6.32 \
    --libexecdir=/usr/lib/eglibc --host=${CLFS_TARGET32} \
        1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

touch /etc/ld.so.conf

echo Installing...
#paco -p $TARGET "\
#make install" \
make install \
        1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
