#/bin/sh

. ./_clfsset.sh

APPNAME=binutils
VER=2.24
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.bz2
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
rm -fr binutils-build
Extract
TimeStart

cd $TARGETDIR

mkdir ../binutils-build
cd ../binutils-build

echo Configuring...
CC="gcc -isystem /usr/include ${BUILD64}" \
LDFLAGS="-Wl,-rpath-link,/usr/lib64:/lib64:/usr/lib:/lib ${BUILD64}" \
  ../binutils-2.24/configure --prefix=/usr \
    --enable-shared --enable-64-bit-bfd --libdir=/usr/lib64 \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make tooldir=/usr \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make tooldir=/usr install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir
rm -fr binutils-build

echo Done.
