#/bin/sh

. ./_clfsset.sh

APPNAME=libtool
VER=2.4.2
TARGET=$APPNAME-$VER
TARGETBALL=$DLD/$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir
Extract
TimeStart

cd $TARGETDIR

echo "lt_cv_sys_dlsearch_path='/lib64 /usr/lib64 /usr/local/lib64 /opt/lib64'" > config.cache

echo Configuring...
CC="gcc ${BUILD64}" ./configure --prefix=/usr \
   --libdir=/usr/lib64 --cache-file=config.cache \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mv -v /usr/bin/libtool{,-64} \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
ln -sv multiarch_wrapper /usr/bin/libtool \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
