#/bin/sh

. ./_clfsset.sh

APPNAME=systemd
VER=213
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/systemd-$VER-compat-1.patch \
	1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo Configuring...
CC="gcc ${BUILD32}" PKG_CONFIG_PATH="${PKG_CONFIG_PATH32}" \
  ./configure --prefix=/usr \
    --sysconfdir=/etc --localstatedir=/var \
    --libexecdir=/usr/lib --docdir=/usr/share/doc/systemd-213 \
    --with-rootprefix="" --with-rootlibdir=/lib \
    --enable-split-usr --disable-gudev --with-kbd-loadkeys=/bin/loadkeys \
    --with-kbd-setfont=/bin/setfont --with-dbuspolicydir=/etc/dbus-1/system.d \
    --with-dbusinterfacedir=/usr/share/dbus-1/interfaces \
    --with-dbussessionservicedir=/usr/share/dbus-1/services \
    --with-dbussystemservicedir=/usr/share/dbus-1/system-services \
    cc_cv_CFLAGS__flto=no \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make src/shared/{af,errno}-{from,to}-name.h src/libsystemd/libsystemd.sym \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1
make libsystemd.la libudev.la libnss_myhostname.la \
	1>> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install-libLTLIBRARIES
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
make install-pkgconfiglibDATA \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1
mv -v /usr/lib/libnss_myhostname.so.2 /lib \
	1>> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.
