#/bin/sh

. ./_clfsset.sh

APPNAME=ncurses
VER=5.9
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.gz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

echo Patching...
patch -Np1 -i $DLD/ncurses-$VER-bash_fix-1.patch \
	1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1
patch -Np1 -i $DLD/ncurses-$VER-gcc5_buildfixes-1.patch \
	1>> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo Configuring...
./configure --prefix=/cross-tools \
    --without-debug --without-shared \
	1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make -C include \
	1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1
make -C progs tic \
	1>> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
install -v -m755 progs/tic /cross-tools/bin \
	1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.

