#/bin/sh

. ./_clfsset.sh
. ./_6clfsset.sh

APPNAME=coreutils
VER=8.22
TARGET=$APPNAME-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

cd $SRC

echo $TARGET

RemoveSrcDir

. $WRK/_extract.sh

cd $TARGETDIR

TimeStart

cat > config.cache << EOF
fu_cv_sys_stat_statfs2_bsize=yes
gl_cv_func_working_mkstemp=yes
EOF

echo Patching...
patch -Np1 -i $DLD/coreutils-$VER-noman-1.patch \
        1> $LOG/$THISFILE.0_patch.log 2>&1 || exit 1

echo Configuring...
./configure --prefix=/tools \
    --build=${CLFS_HOST} --host=${CLFS_TARGET} \
    --enable-install-program=hostname --cache-file=config.cache \
        1> $LOG/$THISFILE.1_conf.log 2>&1 || exit 1

echo Making...
make \
        1> $LOG/$THISFILE.2_make.log 2>&1 || exit 1

echo Installing...
make install \
        1> $LOG/$THISFILE.3_install.log 2>&1 || exit 1

TimeEnd

cd ..
RemoveSrcDir

echo Done.

