#!/bin/sh

CHAP=5
APPNAME=gcc
APPVER=.1
VER=10.1.0
TARGET=gcc-$VER
TARGETBALL=$TARGET.tar.xz
TARGETDIR=$TARGET

VER_mpfr=4.0.2
VER_gmp=6.2.0
VER_gmp2=${VER_gmp}
VER_mpc=1.1.0

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

cd $TARGETDIR

tar -xf $DLD/mpfr-$VER_mpfr.tar.xz || exit 1
mv mpfr-$VER_mpfr mpfr
tar -xf $DLD/gmp-$VER_gmp.tar.xz || exit 1
mv gmp-$VER_gmp gmp
tar -xf $DLD/mpc-$VER_mpc.tar.gz || exit 1
mv mpc-$VER_mpc mpc

TimeStart

case $(uname -m) in
  x86_64)
    sed -e '/m64=/s/lib64/lib/' \
        -i.orig gcc/config/i386/t-linux64
  ;;
esac

mkdir build
cd    build

echo \ \ Configuring...
../configure                                       \
    --target=$LFS_TGT                              \
    --prefix=$LFS/tools                            \
    --with-glibc-version=2.11                      \
    --with-sysroot=$LFS                            \
    --with-newlib                                  \
    --without-headers                              \
    --enable-initfini-array                        \
    --disable-nls                                  \
    --disable-shared                               \
    --disable-multilib                             \
    --disable-decimal-float                        \
    --disable-threads                              \
    --disable-libatomic                            \
    --disable-libgomp                              \
    --disable-libquadmath                          \
    --disable-libssp                               \
    --disable-libvtv                               \
    --disable-libstdcxx                            \
    --enable-languages=c,c++                       \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1 || exit 1

echo \ \ Making...
make -j1 \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1 || exit 1

echo \ \ Installing...
make install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1 || exit 1

cd ..
cat gcc/limitx.h gcc/glimits.h gcc/limity.h > \
  `dirname $($LFS_TGT-gcc -print-libgcc-file-name)`/install-tools/include/limits.h

TimeEnd chap5

echo \ \ Removing directory...
cd ..
rm -fr $TARGETDIR

echo \ \ Done.
