#!/bin/sh

CHAP=5
APPNAME=libstdc++
VER=10.1.0
TARGET=$APPNAME-$VER
TARGETBALL=gcc-$VER.tar.xz
TARGETDIR=gcc-$VER

. ./_lfsset.sh

cd $SRC

echo $TARGET

echo \ \ Removing old directory...
rm -fr $TARGETDIR

. $WRK/_extract.sh

TimeStart

cd $TARGETDIR

mkdir build
cd    build

echo \ \ Configuring...
../libstdc++-v3/configure           \
    --host=$LFS_TGT                 \
    --prefix=/usr\
    --disable-multilib              \
    --disable-nls                   \
    --disable-libstdcxx-pch         \
    --with-gxx-include-dir=/tools/$LFS_TGT/include/c++/$VER \
	1> $LOG/$CHAP.$TARGET.1_conf.log 2>&1

echo \ \ Making...
make \
	1> $LOG/$CHAP.$TARGET.2_make.log 2>&1

echo \ \ Installing...
make DESTDIR=$LFS install \
	1> $LOG/$CHAP.$TARGET.3_install.log 2>&1

TimeEnd chap5

echo \ \ Removing directory...
cd ../..
rm -fr $TARGETDIR

echo \ \ Done.
